/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.util.IntIntFunction;
import com.intellij.util.containers.UnsignedShortArrayList;
import gnu.trove.TIntIntHashMap;

class MostlyUShortIntList
implements IntIntFunction {
    private static final int IN_MAP = 65535;
    private final UnsignedShortArrayList myList;
    private TIntIntHashMap myMap;

    MostlyUShortIntList(int initialCapacity) {
        this.myList = new UnsignedShortArrayList(initialCapacity);
    }

    void add(int value2) {
        if (value2 < 0 || value2 >= 65535) {
            this.initMap().put(this.myList.size(), value2);
            value2 = 65535;
        }
        this.myList.add(value2);
    }

    void set(int index, int value2) {
        if (value2 < 0 || value2 >= 65535) {
            this.initMap().put(index, value2);
            value2 = 65535;
        }
        this.myList.setQuick(index, value2);
    }

    private TIntIntHashMap initMap() {
        if (this.myMap == null) {
            this.myMap = new TIntIntHashMap();
        }
        return this.myMap;
    }

    @Override
    public int fun(int index) {
        return this.get(index);
    }

    public int get(int index) {
        int value2 = this.myList.getQuick(index);
        return value2 == 65535 ? this.myMap.get(index) : value2;
    }

    int size() {
        return this.myList.size();
    }

    void trimToSize() {
        this.myList.trimToSize();
        if (this.myMap != null) {
            this.myMap.trimToSize();
        }
    }
}

