/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElementTypeHolderEP;
import com.intellij.psi.stubs.StubFieldAccessor;
import com.intellij.psi.stubs.StubSerializationHelper;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.StubFileElementType;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public final class SerializationManagerImpl
extends SerializationManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance(SerializationManagerImpl.class);
    private final AtomicBoolean myNameStorageCrashed;
    private final Path myFile;
    private final boolean myUnmodifiable;
    private final AtomicBoolean myShutdownPerformed;
    private PersistentStringEnumerator myNameStorage;
    private volatile StubSerializationHelper myStubSerializationHelper;
    private volatile boolean mySerializersLoaded;

    public SerializationManagerImpl() {
        this(new File(PathManager.getIndexRoot(), "rep.names").toPath(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializationManagerImpl(@NotNull Path nameStorageFile, boolean unmodifiable) {
        if (nameStorageFile == null) {
            SerializationManagerImpl.$$$reportNull$$$0(0);
        }
        this.myNameStorageCrashed = new AtomicBoolean(false);
        this.myShutdownPerformed = new AtomicBoolean(false);
        this.myFile = nameStorageFile;
        this.myUnmodifiable = unmodifiable;
        try {
            this.myNameStorage = new PersistentStringEnumerator(this.myFile, true);
            this.myStubSerializationHelper = new StubSerializationHelper(this.myNameStorage, unmodifiable, this);
        }
        catch (IOException e) {
            this.nameStorageCrashed();
            LOG.info(e);
            this.repairNameStorage();
            this.nameStorageCrashed();
        }
        finally {
            ShutDownTracker.getInstance().registerShutdownTask(this::performShutdown);
        }
        StubElementTypeHolderEP.EP_NAME.addExtensionPointListener(this::dropSerializerData, (Disposable)this);
    }

    @Override
    public boolean isNameStorageCorrupted() {
        return this.myNameStorageCrashed.get();
    }

    @Override
    public void repairNameStorage() {
        if (this.myNameStorageCrashed.getAndSet(false)) {
            try {
                LOG.info("Name storage is repaired");
                if (this.myNameStorage != null) {
                    this.myNameStorage.close();
                }
                StubSerializationHelper prevHelper = this.myStubSerializationHelper;
                if (this.myUnmodifiable) {
                    LOG.error("Data provided by unmodifiable serialization manager can be invalid after repair");
                }
                IOUtil.deleteAllFilesStartingWith(this.myFile.toFile());
                this.myNameStorage = new PersistentStringEnumerator(this.myFile, true);
                this.myStubSerializationHelper = new StubSerializationHelper(this.myNameStorage, this.myUnmodifiable, this);
                this.myStubSerializationHelper.copyFrom(prevHelper);
            }
            catch (IOException e) {
                LOG.info(e);
                this.nameStorageCrashed();
            }
        }
    }

    @Override
    public void flushNameStorage() {
        if (this.myNameStorage.isDirty()) {
            this.myNameStorage.force();
        }
    }

    @Override
    public String internString(String string) {
        return this.myStubSerializationHelper.intern(string);
    }

    @Override
    public void reinitializeNameStorage() {
        this.nameStorageCrashed();
        this.repairNameStorage();
    }

    private void nameStorageCrashed() {
        this.myNameStorageCrashed.set(true);
    }

    @Override
    public void dispose() {
        this.performShutdown();
    }

    private void performShutdown() {
        if (!this.myShutdownPerformed.compareAndSet(false, true)) {
            return;
        }
        LOG.info("START StubSerializationManager SHUTDOWN");
        try {
            this.myNameStorage.close();
            LOG.info("END StubSerializationManager SHUTDOWN");
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @Override
    protected void registerSerializer(String externalId, Computable<ObjectStubSerializer> lazySerializer) {
        try {
            this.myStubSerializationHelper.assignId(lazySerializer, externalId);
        }
        catch (IOException e) {
            LOG.info(e);
            this.nameStorageCrashed();
        }
    }

    @Override
    public void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) {
        if (rootStub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(1);
        }
        if (stream == null) {
            SerializationManagerImpl.$$$reportNull$$$0(2);
        }
        this.initSerializers();
        try {
            this.myStubSerializationHelper.serialize(rootStub, stream);
        }
        catch (IOException e) {
            LOG.info(e);
            this.nameStorageCrashed();
        }
    }

    @Override
    @NotNull
    public Stub deserialize(@NotNull InputStream stream) throws SerializerNotFoundException {
        Stub stub;
        if (stream == null) {
            SerializationManagerImpl.$$$reportNull$$$0(3);
        }
        this.initSerializers();
        try {
            stub = this.myStubSerializationHelper.deserialize(stream);
        }
        catch (IOException e) {
            this.nameStorageCrashed();
            LOG.info(e);
            throw new RuntimeException(e);
        }
        if (stub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(4);
        }
        return stub;
    }

    @Override
    public void reSerialize(@NotNull InputStream inStub, @NotNull OutputStream outStub, @NotNull SerializationManagerEx newSerializationManager) throws IOException {
        if (inStub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(5);
        }
        if (outStub == null) {
            SerializationManagerImpl.$$$reportNull$$$0(6);
        }
        if (newSerializationManager == null) {
            SerializationManagerImpl.$$$reportNull$$$0(7);
        }
        this.initSerializers();
        newSerializationManager.initSerializers();
        this.myStubSerializationHelper.reSerializeStub(new DataInputStream(inStub), new DataOutputStream(outStub), ((SerializationManagerImpl)newSerializationManager).myStubSerializationHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initSerializers() {
        SerializationManagerImpl serializationManagerImpl = this;
        synchronized (serializationManagerImpl) {
            if (this.mySerializersLoaded) {
                return;
            }
            this.registerSerializer(PsiFileStubImpl.TYPE);
            List<StubFieldAccessor> lazySerializers = IStubElementType.loadRegisteredStubElementTypes();
            IElementType[] stubElementTypes = IElementType.enumerate(type -> type instanceof StubSerializer);
            for (IElementType type2 : stubElementTypes) {
                if (type2 instanceof StubFileElementType && "psi.file".equals(((StubFileElementType)type2).getExternalId())) continue;
                this.registerSerializer((StubSerializer)((Object)type2));
            }
            for (StubFieldAccessor lazySerializer : lazySerializers) {
                this.registerSerializer(lazySerializer.externalId, lazySerializer);
            }
            this.mySerializersLoaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropSerializerData() {
        SerializationManagerImpl serializationManagerImpl = this;
        synchronized (serializationManagerImpl) {
            IStubElementType.dropRegisteredTypes();
            this.myStubSerializationHelper.dropRegisteredSerializers();
            this.mySerializersLoaded = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameStorageFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/SerializationManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inStub";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outStub";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSerializationManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/SerializationManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reSerialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

