/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StubCumulativeInputDiffBuilder
extends DirectInputDataDiffBuilder<Integer, SerializedStubTree> {
    private static final Logger LOG = Logger.getInstance(SerializedStubTree.class);
    private final int myInputId;
    @Nullable
    private final SerializedStubTree myCurrentTree;

    StubCumulativeInputDiffBuilder(int inputId, @Nullable SerializedStubTree currentTree) {
        super(inputId);
        this.myInputId = inputId;
        this.myCurrentTree = currentTree;
    }

    @Override
    public boolean differentiate(@NotNull Map<Integer, SerializedStubTree> newData, @NotNull KeyValueUpdateProcessor<? super Integer, ? super SerializedStubTree> addProcessor, @NotNull KeyValueUpdateProcessor<? super Integer, ? super SerializedStubTree> updateProcessor, @NotNull RemovedKeyProcessor<? super Integer> removeProcessor) throws StorageException {
        if (newData == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(0);
        }
        if (addProcessor == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(1);
        }
        if (updateProcessor == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(2);
        }
        if (removeProcessor == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(3);
        }
        if (!newData.isEmpty()) {
            SerializedStubTree newSerializedStubTree = newData.values().iterator().next();
            if (this.myCurrentTree != null) {
                if (StubCumulativeInputDiffBuilder.treesAreEqual(newSerializedStubTree, this.myCurrentTree)) {
                    return false;
                }
                removeProcessor.process((Integer)this.myInputId, this.myInputId);
            }
            addProcessor.process((Integer)this.myInputId, newSerializedStubTree, this.myInputId);
            this.updateStubIndices(newSerializedStubTree);
        } else {
            removeProcessor.process((Integer)this.myInputId, this.myInputId);
            this.updateStubIndices(null);
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<Integer> getKeys() {
        Set<Integer> set = this.myCurrentTree != null ? Collections.singleton(this.myInputId) : Collections.emptySet();
        if (set == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static boolean treesAreEqual(@NotNull SerializedStubTree newSerializedStubTree, @NotNull SerializedStubTree currentTree) {
        if (newSerializedStubTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(5);
        }
        if (currentTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(6);
        }
        return Arrays.equals(currentTree.getTreeHash(), newSerializedStubTree.getTreeHash()) && StubCumulativeInputDiffBuilder.treesAreReallyEqual(newSerializedStubTree, currentTree);
    }

    private static boolean treesAreReallyEqual(@NotNull SerializedStubTree newSerializedStubTree, @NotNull SerializedStubTree currentTree) {
        if (newSerializedStubTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(7);
        }
        if (currentTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(8);
        }
        if (newSerializedStubTree.equals(currentTree)) {
            return true;
        }
        if (DebugAssertions.DEBUG) {
            StubCumulativeInputDiffBuilder.reportStubTreeHashCollision(newSerializedStubTree, currentTree);
        }
        return false;
    }

    private void updateStubIndices(@Nullable SerializedStubTree newSerializedStubTree) {
        Map<StubIndexKey, Map<Object, StubIdList>> previousStubIndicesValueMap = this.myCurrentTree == null ? Collections.emptyMap() : this.myCurrentTree.getStubIndicesValueMap();
        Map<StubIndexKey, Map<Object, StubIdList>> newStubIndicesValueMap = newSerializedStubTree == null ? Collections.emptyMap() : newSerializedStubTree.getStubIndicesValueMap();
        Collection<StubIndexKey> affectedIndexes = StubCumulativeInputDiffBuilder.getAffectedIndices(previousStubIndicesValueMap, newStubIndicesValueMap);
        if (FileBasedIndexImpl.DO_TRACE_STUB_INDEX_UPDATE) {
            StubIndexImpl.LOG.info("stub indexes" + (newSerializedStubTree == null ? "deletion" : "update") + ": file = " + this.myInputId + " indexes " + affectedIndexes);
        }
        StubCumulativeInputDiffBuilder.updateStubIndices(affectedIndexes, this.myInputId, previousStubIndicesValueMap, newStubIndicesValueMap);
    }

    private static void updateStubIndices(@NotNull Collection<StubIndexKey> indexKeys, int inputId, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> oldStubTree, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> newStubTree) {
        if (indexKeys == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(9);
        }
        if (oldStubTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(10);
        }
        if (newStubTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(11);
        }
        StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
        for (StubIndexKey key : indexKeys) {
            Map<Object, StubIdList> oldMap = oldStubTree.get(key);
            Map<Object, StubIdList> newMap = newStubTree.get(key);
            Map<Object, StubIdList> _oldMap = oldMap != null ? oldMap : Collections.emptyMap();
            Map<Object, StubIdList> _newMap = newMap != null ? newMap : Collections.emptyMap();
            stubIndex.updateIndex(key, inputId, _oldMap, _newMap);
        }
    }

    @NotNull
    private static Collection<StubIndexKey> getAffectedIndices(@NotNull Map<StubIndexKey, Map<Object, StubIdList>> oldStubTree, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> newStubTree) {
        if (oldStubTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(12);
        }
        if (newStubTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(13);
        }
        HashSet<StubIndexKey> allIndices = new HashSet<StubIndexKey>();
        allIndices.addAll(oldStubTree.keySet());
        allIndices.addAll(newStubTree.keySet());
        HashSet<StubIndexKey> hashSet = allIndices;
        if (hashSet == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    private static void reportStubTreeHashCollision(@NotNull SerializedStubTree newTree, @NotNull SerializedStubTree existingTree) {
        if (newTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(15);
        }
        if (existingTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(16);
        }
        String oldTreeDump = "\nexisting tree " + StubCumulativeInputDiffBuilder.dumpStub(existingTree);
        String newTreeDump = "\nnew tree " + StubCumulativeInputDiffBuilder.dumpStub(newTree);
        byte[] hash2 = newTree.getTreeHash();
        LOG.info("Stub tree hashing collision. Different trees have the same hash = " + StubCumulativeInputDiffBuilder.toHexString(hash2, hash2.length) + ". " + oldTreeDump + newTreeDump, new Exception());
    }

    private static String toHexString(byte[] hash2, int length) {
        return IntStreamEx.of((byte[])hash2).limit((long)length).mapToObj(b -> String.format("%02x", b & 0xFF)).joining();
    }

    @NotNull
    private static String dumpStub(@NotNull SerializedStubTree tree) {
        String deserialized;
        if (tree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(17);
        }
        try {
            deserialized = "stub: " + DebugUtil.stubTreeToString(tree.getStub());
        }
        catch (SerializerNotFoundException e) {
            LOG.error(e);
            deserialized = "error while stub deserialization: " + e.getMessage();
        }
        String string = deserialized + "\n bytes: " + StubCumulativeInputDiffBuilder.toHexString(tree.myTreeBytes, tree.myTreeByteLength);
        if (string == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 14: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 14: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeProcessor";
                break;
            }
            case 4: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubCumulativeInputDiffBuilder";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSerializedStubTree";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKeys";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldStubTree";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStubTree";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTree";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingTree";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubCumulativeInputDiffBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedIndices";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "differentiate";
                break;
            }
            case 4: 
            case 14: 
            case 18: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "treesAreEqual";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "treesAreReallyEqual";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateStubIndices";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedIndices";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "reportStubTreeHashCollision";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "dumpStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 14: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

