/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.psi.stubs.StubFieldAccessor;
import com.intellij.util.xmlb.annotations.Attribute;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class StubElementTypeHolderEP
extends AbstractExtensionPointBean {
    private static final Logger LOG = Logger.getInstance(StubElementTypeHolderEP.class);
    public static final ExtensionPointName<StubElementTypeHolderEP> EP_NAME = ExtensionPointName.create("com.intellij.stubElementTypeHolder");
    @Attribute(value="class")
    @RequiredElement
    public String holderClass;
    @Attribute(value="externalIdPrefix")
    @Nullable
    public String externalIdPrefix;

    List<StubFieldAccessor> initializeOptimized() {
        try {
            if (this.externalIdPrefix != null) {
                ArrayList<StubFieldAccessor> result2 = new ArrayList<StubFieldAccessor>();
                Class<?> aClass = Class.forName(this.holderClass, false, this.getLoaderForClass());
                assert (aClass.isInterface());
                for (Field field : aClass.getDeclaredFields()) {
                    result2.add(new StubFieldAccessor(this.externalIdPrefix + field.getName(), field));
                }
                return result2;
            }
            this.findExtensionClass(this.holderClass);
        }
        catch (ClassNotFoundException e) {
            LOG.error(new PluginException(e, this.getPluginId()));
        }
        return Collections.emptyList();
    }

    @Deprecated
    public void initialize() {
        this.findClassNoExceptions(this.holderClass);
    }

    public String toString() {
        return this.holderClass;
    }
}

