/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.stubs.FileLocalStringEnumerator;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexEx;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubForwardIndexExternalizer<StubKeySerializationState>
implements DataExternalizer<Map<StubIndexKey, Map<Object, StubIdList>>> {
    private final SerializationManagerEx myManagerToInitialize;

    protected StubForwardIndexExternalizer(SerializationManagerEx managerToInitialize) {
        this.myManagerToInitialize = managerToInitialize;
    }

    @NotNull
    public static StubForwardIndexExternalizer<?> getIdeUsedExternalizer(@NotNull SerializationManagerEx managerToInitialize) {
        if (managerToInitialize == null) {
            StubForwardIndexExternalizer.$$$reportNull$$$0(0);
        }
        if (System.getProperty("idea.uses.shareable.serialized.stubs") == null) {
            return new IdeStubForwardIndexesExternalizer(managerToInitialize);
        }
        return new FileLocalStubForwardIndexExternalizer(managerToInitialize);
    }

    @NotNull
    public static StubForwardIndexExternalizer<?> createFileLocalExternalizer(@NotNull SerializationManagerEx serializationManager) {
        if (serializationManager == null) {
            StubForwardIndexExternalizer.$$$reportNull$$$0(1);
        }
        return new FileLocalStubForwardIndexExternalizer(serializationManager);
    }

    private static void initializeSerializationManager(@NotNull SerializationManagerEx serializationManager) {
        if (serializationManager == null) {
            StubForwardIndexExternalizer.$$$reportNull$$$0(2);
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            serializationManager.initSerializers();
            StubIndexEx.initExtensions();
        });
        ((StubIndexEx)StubIndex.getInstance()).ensureLoaded();
    }

    protected abstract StubKeySerializationState createStubIndexKeySerializationState(@NotNull DataOutput var1, @NotNull Set<StubIndexKey> var2) throws IOException;

    protected abstract void writeStubIndexKey(@NotNull DataOutput var1, @NotNull StubIndexKey var2, StubKeySerializationState var3) throws IOException;

    protected abstract StubKeySerializationState createStubIndexKeySerializationState(@NotNull DataInput var1, int var2) throws IOException;

    protected abstract ID<?, ?> readStubIndexKey(@NotNull DataInput var1, StubKeySerializationState var2) throws IOException;

    @Override
    public final void save(@NotNull DataOutput out, Map<StubIndexKey, Map<Object, StubIdList>> indexedStubs) throws IOException {
        if (out == null) {
            StubForwardIndexExternalizer.$$$reportNull$$$0(3);
        }
        DataInputOutputUtil.writeINT(out, indexedStubs.size());
        if (!indexedStubs.isEmpty()) {
            StubKeySerializationState stubKeySerializationState = this.createStubIndexKeySerializationState(out, indexedStubs.keySet());
            StubIndexEx stubIndex = (StubIndexEx)StubIndex.getInstance();
            for (StubIndexKey stubIndexKey : indexedStubs.keySet()) {
                this.writeStubIndexKey(out, stubIndexKey, stubKeySerializationState);
                Map<Object, StubIdList> map2 = indexedStubs.get(stubIndexKey);
                stubIndex.serializeIndexValue(out, stubIndexKey, map2);
            }
        }
    }

    @Override
    public final Map<StubIndexKey, Map<Object, StubIdList>> read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            StubForwardIndexExternalizer.$$$reportNull$$$0(4);
        }
        return this.doRead(in, null, null);
    }

    <K> Map<StubIndexKey, Map<Object, StubIdList>> doRead(@NotNull DataInput in, @Nullable StubIndexKey<K, ?> requestedIndex, @Nullable K requestedKey) throws IOException {
        if (in == null) {
            StubForwardIndexExternalizer.$$$reportNull$$$0(5);
        }
        StubForwardIndexExternalizer.initializeSerializationManager(this.myManagerToInitialize);
        int stubIndicesValueMapSize = DataInputOutputUtil.readINT(in);
        if (stubIndicesValueMapSize > 0) {
            THashMap<StubIndexKey, Map<Object, StubIdList>> stubIndicesValueMap = requestedIndex != null ? null : new THashMap<StubIndexKey, Map<Object, StubIdList>>(stubIndicesValueMapSize);
            StubIndexEx stubIndex = (StubIndexEx)StubIndex.getInstance();
            StubKeySerializationState stubKeySerializationState = this.createStubIndexKeySerializationState(in, stubIndicesValueMapSize);
            for (int i = 0; i < stubIndicesValueMapSize; ++i) {
                ID<?, ?> indexKey = this.readStubIndexKey(in, stubKeySerializationState);
                if (indexKey instanceof StubIndexKey) {
                    boolean deserialize;
                    StubIndexKey stubIndexKey = (StubIndexKey)indexKey;
                    boolean bl = deserialize = requestedIndex == null || requestedIndex.equals(stubIndexKey);
                    if (deserialize) {
                        Map<K, StubIdList> value2 = stubIndex.deserializeIndexValue(in, stubIndexKey, requestedKey);
                        if (requestedIndex != null) {
                            return Collections.singletonMap(requestedIndex, value2);
                        }
                        stubIndicesValueMap.put(stubIndexKey, value2);
                        continue;
                    }
                    stubIndex.skipIndexValue(in);
                    continue;
                }
                assert (indexKey == null);
                stubIndex.skipIndexValue(in);
            }
            return stubIndicesValueMap;
        }
        return Collections.emptyMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managerToInitialize";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializationManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/stubs/StubForwardIndexExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIdeUsedExternalizer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileLocalExternalizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initializeSerializationManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doRead";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class FileLocalStubForwardIndexExternalizer
    extends StubForwardIndexExternalizer<FileLocalStringEnumerator> {
        private FileLocalStubForwardIndexExternalizer(SerializationManagerEx managerToInitialize) {
            super(managerToInitialize);
        }

        @Override
        protected FileLocalStringEnumerator createStubIndexKeySerializationState(@NotNull DataOutput out, @NotNull Set<StubIndexKey> set) throws IOException {
            if (out == null) {
                FileLocalStubForwardIndexExternalizer.$$$reportNull$$$0(0);
            }
            if (set == null) {
                FileLocalStubForwardIndexExternalizer.$$$reportNull$$$0(1);
            }
            FileLocalStringEnumerator enumerator = new FileLocalStringEnumerator(true);
            for (StubIndexKey key : set) {
                enumerator.enumerate(key.getName());
            }
            enumerator.write(out);
            return enumerator;
        }

        @Override
        protected void writeStubIndexKey(@NotNull DataOutput out, @NotNull StubIndexKey key, FileLocalStringEnumerator enumerator) throws IOException {
            if (out == null) {
                FileLocalStubForwardIndexExternalizer.$$$reportNull$$$0(2);
            }
            if (key == null) {
                FileLocalStubForwardIndexExternalizer.$$$reportNull$$$0(3);
            }
            DataInputOutputUtil.writeINT(out, enumerator.enumerate(key.getName()));
        }

        @Override
        protected FileLocalStringEnumerator createStubIndexKeySerializationState(@NotNull DataInput input, int stubIndexKeyCount) throws IOException {
            if (input == null) {
                FileLocalStubForwardIndexExternalizer.$$$reportNull$$$0(4);
            }
            FileLocalStringEnumerator enumerator = new FileLocalStringEnumerator(false);
            enumerator.read(input, UnaryOperator.identity());
            return enumerator;
        }

        @Override
        protected ID<?, ?> readStubIndexKey(@NotNull DataInput input, FileLocalStringEnumerator enumerator) throws IOException {
            int idx;
            String name;
            if (input == null) {
                FileLocalStubForwardIndexExternalizer.$$$reportNull$$$0(5);
            }
            if ((name = enumerator.valueOf(idx = DataInputOutputUtil.readINT(input))) == null) {
                throw new IOException("corrupted data: no value for idx = " + idx + " in local enumerator");
            }
            return ID.findByName(name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/stubs/StubForwardIndexExternalizer$FileLocalStubForwardIndexExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createStubIndexKeySerializationState";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeStubIndexKey";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readStubIndexKey";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class IdeStubForwardIndexesExternalizer
    extends StubForwardIndexExternalizer<Void> {
        private IdeStubForwardIndexesExternalizer(@NotNull SerializationManagerEx managerToInitialize) {
            if (managerToInitialize == null) {
                IdeStubForwardIndexesExternalizer.$$$reportNull$$$0(0);
            }
            super(managerToInitialize);
        }

        @Override
        protected void writeStubIndexKey(@NotNull DataOutput out, @NotNull StubIndexKey key, Void aVoid) throws IOException {
            if (out == null) {
                IdeStubForwardIndexesExternalizer.$$$reportNull$$$0(1);
            }
            if (key == null) {
                IdeStubForwardIndexesExternalizer.$$$reportNull$$$0(2);
            }
            DataInputOutputUtil.writeINT(out, key.getUniqueId());
        }

        @Override
        protected Void createStubIndexKeySerializationState(@NotNull DataOutput out, @NotNull Set<StubIndexKey> set) {
            if (out == null) {
                IdeStubForwardIndexesExternalizer.$$$reportNull$$$0(3);
            }
            if (set == null) {
                IdeStubForwardIndexesExternalizer.$$$reportNull$$$0(4);
            }
            return null;
        }

        @Override
        protected ID<?, ?> readStubIndexKey(@NotNull DataInput input, Void aVoid) throws IOException {
            if (input == null) {
                IdeStubForwardIndexesExternalizer.$$$reportNull$$$0(5);
            }
            return ID.findById(DataInputOutputUtil.readINT(input));
        }

        @Override
        protected Void createStubIndexKeySerializationState(@NotNull DataInput input, int stubIndexKeyCount) {
            if (input == null) {
                IdeStubForwardIndexesExternalizer.$$$reportNull$$$0(6);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "managerToInitialize";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/stubs/StubForwardIndexExternalizer$IdeStubForwardIndexesExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeStubIndexKey";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createStubIndexKeySerializationState";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readStubIndexKey";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

