/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.psi.stubs.ByteArrayInterner;
import com.intellij.psi.stubs.FileLocalStringEnumerator;
import com.intellij.psi.stubs.IntEnumerator;
import com.intellij.psi.stubs.LazyStubData;
import com.intellij.psi.stubs.LazyStubList;
import com.intellij.psi.stubs.MostlyUShortIntList;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubList;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.RecentStringInterner;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataEnumeratorEx;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StubSerializationHelper {
    private static final Logger LOG = Logger.getInstance(StubSerializationHelper.class);
    private final DataEnumeratorEx<String> myNameStorage;
    private final TIntObjectHashMap<String> myIdToName;
    private final TObjectIntHashMap<String> myNameToId;
    private final THashMap<String, Computable<ObjectStubSerializer>> myNameToLazySerializer;
    private final ConcurrentIntObjectMap<ObjectStubSerializer> myIdToSerializer;
    private final Map<ObjectStubSerializer, Integer> mySerializerToId;
    private final boolean myUnmodifiable;
    private final RecentStringInterner myStringInterner;
    private static final ThreadLocal<ObjectStubSerializer> ourRootStubSerializer = new ThreadLocal();

    void dropRegisteredSerializers() {
        this.myIdToName.clear();
        this.myNameToId.clear();
        this.myNameToLazySerializer.clear();
        this.myIdToSerializer.clear();
        this.mySerializerToId.clear();
    }

    StubSerializationHelper(@NotNull DataEnumeratorEx<String> nameStorage, boolean unmodifiable, @NotNull Disposable parentDisposable) {
        if (nameStorage == null) {
            StubSerializationHelper.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            StubSerializationHelper.$$$reportNull$$$0(1);
        }
        this.myIdToName = new TIntObjectHashMap();
        this.myNameToId = new TObjectIntHashMap();
        this.myNameToLazySerializer = new THashMap();
        this.myIdToSerializer = ContainerUtil.createConcurrentIntObjectMap();
        this.mySerializerToId = ContainerUtil.newConcurrentMap();
        this.myNameStorage = nameStorage;
        this.myUnmodifiable = unmodifiable;
        this.myStringInterner = new RecentStringInterner(parentDisposable);
    }

    void assignId(@NotNull Computable<ObjectStubSerializer> serializer, String name) throws IOException {
        int id2;
        Computable<ObjectStubSerializer> old;
        if (serializer == null) {
            StubSerializationHelper.$$$reportNull$$$0(2);
        }
        if ((old = this.myNameToLazySerializer.put(name, serializer)) != null) {
            ObjectStubSerializer computed;
            ObjectStubSerializer existing = old.compute();
            if (existing != (computed = serializer.compute())) {
                throw new AssertionError((Object)("ID: " + name + " is not unique, but found in both " + existing.getClass().getName() + " and " + computed.getClass().getName()));
            }
            return;
        }
        if (this.myUnmodifiable) {
            id2 = this.myNameStorage.tryEnumerate(name);
            if (id2 == 0) {
                LOG.debug("serialized " + name + " is ignored in unmodifiable stub serialization manager");
                return;
            }
        } else {
            id2 = this.myNameStorage.enumerate(name);
        }
        this.myIdToName.put(id2, name);
        this.myNameToId.put(name, id2);
    }

    void copyFrom(@Nullable StubSerializationHelper helper) throws IOException {
        if (helper == null) {
            return;
        }
        for (String name : helper.myNameToLazySerializer.keySet()) {
            this.assignId(helper.myNameToLazySerializer.get(name), name);
        }
    }

    private ObjectStubSerializer<Stub, Stub> writeSerializerId(Stub stub, @NotNull DataOutput stream, IntEnumerator serializerLocalEnumerator) throws IOException {
        ObjectStubSerializer<Stub, Stub> serializer;
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(3);
        }
        if ((serializer = StubSerializationUtil.getSerializer(stub)) == null) {
            throw new Error("No serializer was returned for " + stub);
        }
        DataInputOutputUtil.writeINT(stream, serializerLocalEnumerator.enumerate(this.getClassId(serializer)));
        return serializer;
    }

    private void serializeSelf(Stub stub, @NotNull StubOutputStream stream, IntEnumerator serializerLocalEnumerator) throws IOException {
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(4);
        }
        if (((ObjectStubBase)stub).isDangling()) {
            stream.writeByte(0);
        }
        this.writeSerializerId(stub, stream, serializerLocalEnumerator).serialize(stub, stream);
    }

    private void serializeChildren(@NotNull Stub parent, @NotNull StubOutputStream stream, IntEnumerator serializerLocalEnumerator) throws IOException {
        if (parent == null) {
            StubSerializationHelper.$$$reportNull$$$0(5);
        }
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(6);
        }
        List<? extends Stub> children2 = parent.getChildrenStubs();
        DataInputOutputUtil.writeINT(stream, children2.size());
        for (Stub stub : children2) {
            this.serializeSelf(stub, stream, serializerLocalEnumerator);
            this.serializeChildren(stub, stream, serializerLocalEnumerator);
        }
    }

    void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) throws IOException {
        if (rootStub == null) {
            StubSerializationHelper.$$$reportNull$$$0(7);
        }
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(8);
        }
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        FileLocalStringEnumerator storage = new FileLocalStringEnumerator(true);
        IntEnumerator selializerIdLocalEnumerator = new IntEnumerator();
        StubOutputStream stubOutputStream = new StubOutputStream(out, storage);
        boolean doDefaultSerialization = true;
        if (rootStub instanceof PsiFileStubImpl) {
            PsiFileStub[] roots = ((PsiFileStubImpl)rootStub).getStubRoots();
            if (roots.length == 0) {
                Logger.getInstance(this.getClass()).error("Incorrect stub files count during serialization:" + rootStub + "," + rootStub.getStubType());
            } else {
                doDefaultSerialization = false;
                DataInputOutputUtil.writeINT(stubOutputStream, roots.length);
                for (PsiFileStub root : roots) {
                    this.serializeRoot(stubOutputStream, root, storage, selializerIdLocalEnumerator);
                }
            }
        }
        if (doDefaultSerialization) {
            DataInputOutputUtil.writeINT(stubOutputStream, 1);
            this.serializeRoot(stubOutputStream, rootStub, storage, selializerIdLocalEnumerator);
        }
        DataOutputStream resultStream = new DataOutputStream(stream);
        selializerIdLocalEnumerator.dump(resultStream);
        storage.write(resultStream);
        resultStream.write(out.getInternalBuffer(), 0, out.size());
    }

    private int getClassId(@NotNull ObjectStubSerializer<Stub, Stub> serializer) {
        Integer idValue;
        if (serializer == null) {
            StubSerializationHelper.$$$reportNull$$$0(9);
        }
        if ((idValue = this.mySerializerToId.get(serializer)) == null) {
            String name = serializer.getExternalId();
            idValue = this.myNameToId.get(name);
            assert (idValue > 0) : "No ID found for serializer " + LogUtil.objectAndClass(serializer) + ", external id:" + name + (serializer instanceof IElementType ? ", language:" + ((IElementType)((Object)serializer)).getLanguage() + ", " + serializer : "");
            this.mySerializerToId.put(serializer, idValue);
        }
        return idValue;
    }

    @NotNull
    Stub deserialize(@NotNull InputStream stream) throws IOException, SerializerNotFoundException {
        PsiFileStub[] stubsArray;
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(10);
        }
        FileLocalStringEnumerator storage = new FileLocalStringEnumerator(false);
        StubInputStream inputStream = new StubInputStream(stream, storage);
        IntEnumerator serializerLocalEnumerator = IntEnumerator.read(inputStream);
        storage.read(inputStream, this::intern);
        int stubFilesCount = DataInputOutputUtil.readINT(inputStream);
        if (stubFilesCount <= 0) {
            Logger.getInstance(this.getClass()).error("Incorrect stub files count during deserialization:" + stubFilesCount);
        }
        Stub baseStub = this.deserializeRoot(inputStream, storage, serializerLocalEnumerator);
        ArrayList<PsiFileStub> stubs = new ArrayList<PsiFileStub>(stubFilesCount);
        if (baseStub instanceof PsiFileStub) {
            stubs.add((PsiFileStub)baseStub);
        }
        for (int j = 1; j < stubFilesCount; ++j) {
            Stub deserialize = this.deserializeRoot(inputStream, storage, serializerLocalEnumerator);
            if (deserialize instanceof PsiFileStub) {
                PsiFileStub fileStub = (PsiFileStub)deserialize;
                stubs.add(fileStub);
                continue;
            }
            Logger.getInstance(this.getClass()).error("Stub root must be PsiFileStub for files with several stub roots");
        }
        for (PsiFileStub stub : stubsArray = stubs.toArray(PsiFileStub.EMPTY_ARRAY)) {
            if (!(stub instanceof PsiFileStubImpl)) continue;
            ((PsiFileStubImpl)stub).setStubRoots(stubsArray);
        }
        Stub stub = baseStub;
        if (stub == null) {
            StubSerializationHelper.$$$reportNull$$$0(11);
        }
        return stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stub deserializeRoot(StubInputStream inputStream, FileLocalStringEnumerator storage, IntEnumerator serializerLocalEnumerator) throws IOException, SerializerNotFoundException {
        ObjectStubSerializer<?, Stub> serializer = this.getClassById(DataInputOutputUtil.readINT(inputStream), null, serializerLocalEnumerator);
        ourRootStubSerializer.set(serializer);
        try {
            Object stub = serializer.deserialize(inputStream, null);
            if (stub instanceof StubBase) {
                this.deserializeStubList((StubBase)stub, serializer, inputStream, storage, serializerLocalEnumerator);
            } else {
                this.deserializeChildren(inputStream, (Stub)stub, serializerLocalEnumerator);
            }
            Object obj = stub;
            return obj;
        }
        finally {
            ourRootStubSerializer.set(null);
        }
    }

    private void serializeRoot(StubOutputStream out, Stub root, AbstractStringEnumerator storage, IntEnumerator serializerLocalEnumerator) throws IOException {
        this.serializeSelf(root, out, serializerLocalEnumerator);
        if (root instanceof StubBase) {
            StubList stubList = ((StubBase)root).myStubList;
            if (root != stubList.get(0)) {
                throw new IllegalArgumentException("Serialization is supported only for root stubs");
            }
            this.serializeStubList(stubList, out, storage, serializerLocalEnumerator);
        } else {
            this.serializeChildren(root, out, serializerLocalEnumerator);
        }
    }

    private void deserializeStubList(StubBase<?> root, final ObjectStubSerializer rootType, final StubInputStream inputStream, FileLocalStringEnumerator storage, final IntEnumerator serializerLocalEnumerator) throws IOException, SerializerNotFoundException {
        int stubCount = DataInputOutputUtil.readINT(inputStream);
        final LazyStubList stubList = new LazyStubList(stubCount, root, rootType);
        final MostlyUShortIntList parentsAndStarts = new MostlyUShortIntList(stubCount * 2);
        final BitSet allStarts = new BitSet();
        new Object(){
            int currentIndex = 1;

            private void deserializeStub(int parentIndex) throws IOException, SerializerNotFoundException {
                int index = this.currentIndex++;
                int serializerId = DataInputOutputUtil.readINT(inputStream);
                int start2 = DataInputOutputUtil.readINT(inputStream);
                allStarts.set(start2);
                this.addStub(parentIndex, index, start2, (IElementType)((Object)StubSerializationHelper.this.getClassById(serializerId, null, serializerLocalEnumerator)));
                this.deserializeChildren(index);
            }

            private void addStub(int parentIndex, int index, int start2, IElementType type) {
                parentsAndStarts.add(parentIndex);
                parentsAndStarts.add(start2);
                stubList.addLazyStub(type, index, parentIndex);
            }

            private void deserializeChildren(int parentIndex) throws IOException, SerializerNotFoundException {
                int childrenCount = DataInputOutputUtil.readINT(inputStream);
                stubList.prepareForChildren(parentIndex, childrenCount);
                for (int i = 0; i < childrenCount; ++i) {
                    this.deserializeStub(parentIndex);
                }
            }

            void deserializeRoot() throws IOException, SerializerNotFoundException {
                this.addStub(0, 0, 0, (IElementType)((Object)rootType));
                this.deserializeChildren(0);
            }
        }.deserializeRoot();
        byte[] serializedStubs = this.readByteArray(inputStream);
        stubList.setStubData(new LazyStubData(storage, parentsAndStarts, serializedStubs, allStarts));
    }

    private void serializeStubList(StubList stubList, DataOutput out, AbstractStringEnumerator storage, IntEnumerator serializerLocalEnumerator) throws IOException {
        if (!stubList.isChildrenLayoutOptimal()) {
            throw new IllegalArgumentException("Manually assembled stubs should be normalized before serialization, consider wrapping them into StubTree");
        }
        DataInputOutputUtil.writeINT(out, stubList.size());
        DataInputOutputUtil.writeINT(out, stubList.getChildrenCount(0));
        BufferExposingByteArrayOutputStream tempBuffer = new BufferExposingByteArrayOutputStream();
        ByteArrayInterner interner = new ByteArrayInterner();
        for (int i = 1; i < stubList.size(); ++i) {
            StubBase stub = (StubBase)stubList.get(i);
            ObjectStubSerializer<Stub, Stub> serializer = this.writeSerializerId(stub, out, serializerLocalEnumerator);
            DataInputOutputUtil.writeINT(out, interner.internBytes(StubSerializationHelper.serializeStub(serializer, storage, stub, tempBuffer)));
            DataInputOutputUtil.writeINT(out, stubList.getChildrenCount(stub.id));
        }
        StubSerializationHelper.writeByteArray(out, interner.joinedBuffer.getInternalBuffer(), interner.joinedBuffer.size());
    }

    private static byte[] serializeStub(ObjectStubSerializer<Stub, Stub> serializer, AbstractStringEnumerator storage, StubBase<?> stub, BufferExposingByteArrayOutputStream tempBuffer) throws IOException {
        tempBuffer.reset();
        StubOutputStream stubOut = new StubOutputStream(tempBuffer, storage);
        serializer.serialize(stub, stubOut);
        if (stub.isDangling()) {
            stubOut.writeByte(0);
        }
        return tempBuffer.size() == 0 ? ArrayUtilRt.EMPTY_BYTE_ARRAY : tempBuffer.toByteArray();
    }

    private byte[] readByteArray(StubInputStream inputStream) throws IOException {
        int length = DataInputOutputUtil.readINT(inputStream);
        if (length == 0) {
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        byte[] array = new byte[length];
        int read2 = inputStream.read(array);
        if (read2 != array.length) {
            Logger.getInstance(this.getClass()).error("Serialized array length mismatch");
        }
        return array;
    }

    private static void writeByteArray(DataOutput out, byte[] array, int len) throws IOException {
        DataInputOutputUtil.writeINT(out, len);
        out.write(array, 0, len);
    }

    @Nullable
    @Contract(value="null -> null")
    String intern(@Nullable String str) {
        return this.myStringInterner.get(str);
    }

    void reSerializeStub(@NotNull DataInputStream inStub, @NotNull DataOutputStream outStub, @NotNull StubSerializationHelper newSerializationHelper) throws IOException {
        if (inStub == null) {
            StubSerializationHelper.$$$reportNull$$$0(12);
        }
        if (outStub == null) {
            StubSerializationHelper.$$$reportNull$$$0(13);
        }
        if (newSerializationHelper == null) {
            StubSerializationHelper.$$$reportNull$$$0(14);
        }
        IntEnumerator currentSerializerEnumerator = IntEnumerator.read(inStub);
        currentSerializerEnumerator.dump(outStub, id2 -> {
            String name = this.myIdToName.get(id2);
            return name == null ? 0 : newSerializationHelper.myNameToId.get(name);
        });
        StreamUtil.copyStreamContent(inStub, outStub);
    }

    private ObjectStubSerializer<?, Stub> getClassById(int localId, @Nullable Stub parentStub, IntEnumerator enumerator) throws SerializerNotFoundException {
        int id2 = enumerator.valueOf(localId);
        ObjectStubSerializer serializer = (ObjectStubSerializer)this.myIdToSerializer.get(id2);
        if (serializer == null) {
            serializer = this.instantiateSerializer(id2, parentStub);
            this.myIdToSerializer.put(id2, serializer);
        }
        return serializer;
    }

    @NotNull
    private ObjectStubSerializer instantiateSerializer(int id2, @Nullable Stub parentStub) throws SerializerNotFoundException {
        ObjectStubSerializer serializer;
        String name = this.myIdToName.get(id2);
        Computable<ObjectStubSerializer> lazy = name == null ? null : this.myNameToLazySerializer.get(name);
        ObjectStubSerializer objectStubSerializer = serializer = lazy == null ? null : lazy.compute();
        if (serializer == null) {
            throw this.reportMissingSerializer(id2, parentStub);
        }
        ObjectStubSerializer objectStubSerializer2 = serializer;
        if (objectStubSerializer2 == null) {
            StubSerializationHelper.$$$reportNull$$$0(15);
        }
        return objectStubSerializer2;
    }

    private SerializerNotFoundException reportMissingSerializer(int id2, @Nullable Stub parentStub) {
        String externalId = null;
        try {
            externalId = (String)this.myNameStorage.valueOf(id2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new SerializerNotFoundException(StubSerializationUtil.brokenStubFormat(ourRootStubSerializer.get()) + "Internal details, no serializer registered for stub: ID=" + id2 + ", externalId:" + externalId + "; parent stub class=" + (parentStub != null ? parentStub.getClass().getName() + ", parent stub type:" + parentStub.getStubType() : "null"));
    }

    private void deserializeChildren(StubInputStream stream, Stub parent, IntEnumerator serializerLocalEnumerator) throws IOException, SerializerNotFoundException {
        int childCount = DataInputOutputUtil.readINT(stream);
        for (int i = 0; i < childCount; ++i) {
            boolean dangling = false;
            int id2 = DataInputOutputUtil.readINT(stream);
            if (id2 == 0) {
                dangling = true;
                id2 = DataInputOutputUtil.readINT(stream);
            }
            Object child2 = this.getClassById(id2, parent, serializerLocalEnumerator).deserialize(stream, parent);
            if (dangling) {
                ((ObjectStubBase)child2).markDangling();
            }
            this.deserializeChildren(stream, (Stub)child2, serializerLocalEnumerator);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameStorage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubSerializationHelper";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inStub";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outStub";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSerializationHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubSerializationHelper";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assignId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSerializerId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serializeSelf";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serializeChildren";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getClassId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 11: 
            case 15: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reSerializeStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

