/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.index.PrebuiltIndexProviderBase;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.CompositeBinaryBuilderMap;
import com.intellij.psi.stubs.IndexingStampInfo;
import com.intellij.psi.stubs.PrebuiltStubsKt;
import com.intellij.psi.stubs.PrebuiltStubsProvider;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializedStubTreeDataExternalizer;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBuilderType;
import com.intellij.psi.stubs.StubCumulativeInputDiffBuilder;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubUpdatingForwardIndexAccessor;
import com.intellij.psi.stubs.StubVersionMap;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.BitUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.SingleEntryCompositeIndexer;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.forward.EmptyForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubUpdatingIndex
extends SingleEntryFileBasedIndexExtension<SerializedStubTree>
implements CustomImplementationFileBasedIndexExtension<Integer, SerializedStubTree> {
    static final Logger LOG = Logger.getInstance(StubUpdatingIndex.class);
    private static final int VERSION = 43 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 1 : 0) + (InvertedIndex.ARE_COMPOSITE_INDEXERS_ENABLED ? 2 : 0);
    private static final FileAttribute INDEXED_STAMP = new FileAttribute("stubIndexStamp", 3, true);
    public static final ID<Integer, SerializedStubTree> INDEX_ID = ID.create("Stubs");
    private static final FileBasedIndex.InputFilter INPUT_FILTER = file2 -> StubUpdatingIndex.canHaveStub(file2);
    @NotNull
    private final StubForwardIndexExternalizer<?> myStubIndexesExternalizer;
    @NotNull
    private final SerializationManagerEx mySerializationManager;
    private static final byte IS_BINARY_MASK = 1;
    private static final byte BYTE_AND_CHAR_LENGTHS_ARE_THE_SAME_MASK = 2;

    public StubUpdatingIndex() {
        this(StubForwardIndexExternalizer.getIdeUsedExternalizer(SerializationManagerEx.getInstanceEx()), SerializationManagerEx.getInstanceEx());
    }

    public StubUpdatingIndex(@NotNull StubForwardIndexExternalizer<?> stubIndexesExternalizer, @NotNull SerializationManagerEx serializationManager) {
        if (stubIndexesExternalizer == null) {
            StubUpdatingIndex.$$$reportNull$$$0(0);
        }
        if (serializationManager == null) {
            StubUpdatingIndex.$$$reportNull$$$0(1);
        }
        this.myStubIndexesExternalizer = stubIndexesExternalizer;
        this.mySerializationManager = serializationManager;
    }

    public static boolean canHaveStub(@NotNull VirtualFile file2) {
        BinaryFileStubBuilder builder2;
        if (file2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(2);
        }
        Project project2 = ProjectUtil.guessProjectForFile(file2);
        FileType fileType = SubstitutedFileType.substituteFileType(file2, file2.getFileType(), project2);
        if (fileType instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
            if (parserDefinition == null) {
                return false;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            if (elementType instanceof IStubFileElementType && ((IStubFileElementType)elementType).shouldBuildStubFor(file2)) {
                return true;
            }
        }
        return (builder2 = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType)) != null && builder2.acceptsFile(file2);
    }

    @Override
    @NotNull
    public ID<Integer, SerializedStubTree> getName() {
        ID<Integer, SerializedStubTree> iD = INDEX_ID;
        if (iD == null) {
            StubUpdatingIndex.$$$reportNull$$$0(3);
        }
        return iD;
    }

    @Override
    @NotNull
    public SingleEntryIndexer<SerializedStubTree> getIndexer() {
        return new SingleEntryCompositeIndexer<SerializedStubTree, StubBuilderType, String>(false){

            @Override
            public boolean requiresContentForSubIndexerEvaluation(@NotNull IndexedFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return StubTreeBuilder.requiresContentToFindBuilder(file2.getFileType());
            }

            @Override
            @Nullable
            public StubBuilderType calculateSubIndexer(@NotNull IndexedFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return StubTreeBuilder.getStubBuilderType(file2, true);
            }

            @Override
            @NotNull
            public String getSubIndexerVersion(@NotNull StubBuilderType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(2);
                }
                String string = type.getVersion();
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            @Override
            @NotNull
            public KeyDescriptor<String> getSubIndexerVersionDescriptor() {
                EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
                if (enumeratorStringDescriptor == null) {
                    1.$$$reportNull$$$0(4);
                }
                return enumeratorStringDescriptor;
            }

            @Override
            @Nullable
            public SerializedStubTree computeValue(@NotNull FileContent inputData, @NotNull StubBuilderType type) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(6);
                }
                return ReadAction.compute(() -> {
                    SerializedStubTree serializedStubTree = null;
                    try {
                        Stub rootStub;
                        PrebuiltStubsProvider prebuiltStubsProvider;
                        if (Registry.is("use.prebuilt.indices") && (prebuiltStubsProvider = PrebuiltStubsKt.getPrebuiltStubsProvider().forFileType(inputData.getFileType())) != null) {
                            serializedStubTree = prebuiltStubsProvider.findStub(inputData);
                            if (PrebuiltIndexProviderBase.DEBUG_PREBUILT_INDICES) {
                                Stub stub = StubTreeBuilder.buildStubTree(inputData);
                                if (serializedStubTree != null && stub != null) {
                                    StubUpdatingIndex.check(serializedStubTree.getStub(), stub);
                                    StubUpdatingIndex.checkStubIndexes(serializedStubTree, stub);
                                }
                            }
                        }
                        if (serializedStubTree == null && (rootStub = StubTreeBuilder.buildStubTree(inputData, type)) != null) {
                            serializedStubTree = SerializedStubTree.serializeStub(rootStub, StubUpdatingIndex.this.mySerializationManager, StubUpdatingIndex.this.myStubIndexesExternalizer);
                            if (DebugAssertions.DEBUG) {
                                Stub deserialized = serializedStubTree.getStub(StubUpdatingIndex.this.mySerializationManager);
                                StubUpdatingIndex.check(deserialized, rootStub);
                            }
                        }
                    }
                    catch (ProcessCanceledException pce) {
                        throw pce;
                    }
                    catch (SerializerNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable t) {
                        LOG.error("Error indexing:" + inputData.getFile(), t);
                    }
                    if (serializedStubTree == null) {
                        return null;
                    }
                    VirtualFile file2 = inputData.getFile();
                    boolean isBinary = file2.getFileType().isBinary();
                    int contentLength = isBinary ? -1 : inputData.getPsiFile().getTextLength();
                    long byteLength = file2.getLength();
                    StubUpdatingIndex.rememberIndexingStamp(file2, isBinary, byteLength, contentLength);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Indexing " + file2 + "; " + IndexingStampInfo.dumpSize(byteLength, contentLength));
                    }
                    return serializedStubTree;
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex$1";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubIndexerVersion";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubIndexerVersionDescriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "requiresContentForSubIndexerEvaluation";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "calculateSubIndexer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getSubIndexerVersion";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "computeValue";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static void checkStubIndexes(@NotNull SerializedStubTree prebuiltSerializedTree, @NotNull Stub calculatedStub) {
        if (prebuiltSerializedTree == null) {
            StubUpdatingIndex.$$$reportNull$$$0(4);
        }
        if (calculatedStub == null) {
            StubUpdatingIndex.$$$reportNull$$$0(5);
        }
        Map<StubIndexKey, Map<Object, StubIdList>> calculatedStubIndexes = SerializedStubTree.indexTree(calculatedStub);
        assert (calculatedStubIndexes.equals(prebuiltSerializedTree.getStubIndicesValueMap()));
    }

    private static void check(@NotNull Stub stub, @NotNull Stub stub2) {
        if (stub == null) {
            StubUpdatingIndex.$$$reportNull$$$0(6);
        }
        if (stub2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(7);
        }
        assert (stub.getStubType() == stub2.getStubType());
        List<? extends Stub> stubs = stub.getChildrenStubs();
        List<? extends Stub> stubs2 = stub2.getChildrenStubs();
        assert (stubs.size() == stubs2.size());
        int len = stubs.size();
        for (int i = 0; i < len; ++i) {
            StubUpdatingIndex.check(stubs.get(i), stubs2.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void rememberIndexingStamp(@NotNull VirtualFile file2, boolean isBinary, long contentByteLength, int n) {
        if (file2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(8);
        }
        try (DataOutputStream stream = INDEXED_STAMP.writeAttribute(file2);){
            void contentCharLength;
            DataInputOutputUtil.writeTIME(stream, file2.getTimeStamp());
            DataInputOutputUtil.writeLONG(stream, contentByteLength);
            boolean lengthsAreTheSame = contentByteLength == (long)contentCharLength;
            byte flags = 0;
            flags = BitUtil.set(flags, (byte)1, isBinary);
            flags = BitUtil.set(flags, (byte)2, lengthsAreTheSame);
            stream.writeByte(flags);
            if (!lengthsAreTheSame && !isBinary) {
                DataInputOutputUtil.writeINT(stream, (int)contentCharLength);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static IndexingStampInfo getIndexingStampInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(9);
        }
        try (DataInputStream stream = INDEXED_STAMP.readAttribute(file2);){
            if (stream == null) {
                IndexingStampInfo indexingStampInfo2 = null;
                return indexingStampInfo2;
            }
            long stamp = DataInputOutputUtil.readTIME(stream);
            long byteLength = DataInputOutputUtil.readLONG(stream);
            byte flags = stream.readByte();
            boolean isBinary = BitUtil.isSet(flags, (byte)1);
            boolean readOnlyOneLength = BitUtil.isSet(flags, (byte)2);
            int charLength = isBinary ? -1 : (readOnlyOneLength ? (int)byteLength : DataInputOutputUtil.readINT(stream));
            IndexingStampInfo indexingStampInfo = new IndexingStampInfo(stamp, byteLength, charLength);
            return indexingStampInfo;
        }
        catch (IOException e) {
            LOG.error(e);
            return null;
        }
    }

    @Override
    @NotNull
    public DataExternalizer<SerializedStubTree> getValueExternalizer() {
        return new SerializedStubTreeDataExternalizer(true, this.mySerializationManager, this.myStubIndexesExternalizer);
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = INPUT_FILTER;
        if (inputFilter == null) {
            StubUpdatingIndex.$$$reportNull$$$0(10);
        }
        return inputFilter;
    }

    @Override
    public int getVersion() {
        return VERSION;
    }

    @Override
    @NotNull
    public UpdatableIndex<Integer, SerializedStubTree, FileContent> createIndexImplementation(@NotNull FileBasedIndexExtension<Integer, SerializedStubTree> extension, @NotNull IndexStorage<Integer, SerializedStubTree> storage) throws StorageException, IOException {
        if (extension == null) {
            StubUpdatingIndex.$$$reportNull$$$0(11);
        }
        if (storage == null) {
            StubUpdatingIndex.$$$reportNull$$$0(12);
        }
        ((StubIndexImpl)StubIndex.getInstance()).initializeStubIndexes();
        if (storage instanceof MemoryIndexStorage) {
            MemoryIndexStorage memStorage = (MemoryIndexStorage)storage;
            memStorage.addBufferingStateListener(new MemoryIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState2) {
                    ((StubIndexImpl)StubIndex.getInstance()).setDataBufferingEnabled(newState2);
                }

                @Override
                public void memoryStorageCleared() {
                    ((StubIndexImpl)StubIndex.getInstance()).cleanupMemoryStorage();
                }
            });
        }
        this.checkNameStorage();
        return new MyIndex(extension, storage);
    }

    private void checkNameStorage() throws StorageException {
        if (this.mySerializationManager.isNameStorageCorrupted()) {
            this.mySerializationManager.repairNameStorage();
            throw new StorageException("NameStorage for stubs serialization has been corrupted");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexesExternalizer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializationManager";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prebuiltSerializedTree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calculatedStub";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canHaveStub";
                break;
            }
            case 3: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkStubIndexes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "rememberIndexingStamp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingStampInfo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createIndexImplementation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyIndex
    extends VfsAwareMapReduceIndex<Integer, SerializedStubTree> {
        private StubIndexImpl myStubIndex;
        @Nullable
        private final StubVersionMap myStubVersionMap;
        @Nullable
        private final CompositeBinaryBuilderMap myCompositeBinaryBuilderMap;

        MyIndex(@NotNull FileBasedIndexExtension<Integer, SerializedStubTree> extension, @NotNull IndexStorage<Integer, SerializedStubTree> storage) throws IOException {
            if (extension == null) {
                MyIndex.$$$reportNull$$$0(0);
            }
            if (storage == null) {
                MyIndex.$$$reportNull$$$0(1);
            }
            super(extension, storage, new EmptyForwardIndex(), new StubUpdatingForwardIndexAccessor(), null, null);
            this.myStubVersionMap = InvertedIndex.ARE_COMPOSITE_INDEXERS_ENABLED ? null : new StubVersionMap();
            this.myCompositeBinaryBuilderMap = InvertedIndex.ARE_COMPOSITE_INDEXERS_ENABLED ? new CompositeBinaryBuilderMap() : null;
            ((StubUpdatingForwardIndexAccessor)this.getForwardIndexAccessor()).setIndex(this);
            if (InvertedIndex.ARE_COMPOSITE_INDEXERS_ENABLED) {
                FileTypeRegistry.getInstance().getRegisteredFileTypes();
                MyIndex.getExtensions(BinaryFileStubBuilders.INSTANCE).forEach(builder2 -> {});
            }
            MyIndex.getExtensions(LanguageParserDefinitions.INSTANCE).forEach(ParserDefinition::getFileNodeType);
        }

        private static <T> Stream<T> getExtensions(KeyedExtensionCollector<T, ?> ex) {
            ExtensionPoint<KeyedLazyInstance<T>> point = ex.getPoint();
            return point == null ? Stream.empty() : point.extensions().map(KeyedLazyInstance::getInstance);
        }

        @Override
        protected void doFlush() throws IOException, StorageException {
            StubIndexImpl stubIndex = this.getStubIndex();
            try {
                stubIndex.flush();
            }
            finally {
                super.doFlush();
            }
        }

        @NotNull
        private StubIndexImpl getStubIndex() {
            StubIndexImpl index = this.myStubIndex;
            if (index == null) {
                this.myStubIndex = index = (StubIndexImpl)StubIndex.getInstance();
            }
            StubIndexImpl stubIndexImpl = index;
            if (stubIndexImpl == null) {
                MyIndex.$$$reportNull$$$0(2);
            }
            return stubIndexImpl;
        }

        @Override
        protected void removeTransientDataForInMemoryKeys(int inputId, @NotNull Map<? extends Integer, ? extends SerializedStubTree> map2) {
            if (map2 == null) {
                MyIndex.$$$reportNull$$$0(3);
            }
            super.removeTransientDataForInMemoryKeys(inputId, map2);
            MyIndex.removeStubIndexKeys(inputId, MyIndex.getStubIndexMaps(map2));
        }

        @Override
        public void removeTransientDataForKeys(int inputId, @NotNull Collection<? extends Integer> keys2) {
            Map<StubIndexKey, Map<Object, StubIdList>> maps;
            if (keys2 == null) {
                MyIndex.$$$reportNull$$$0(4);
            }
            try {
                Map data2 = this.getIndexedFileData(inputId);
                maps = MyIndex.getStubIndexMaps(data2);
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
            super.removeTransientDataForKeys(inputId, keys2);
            MyIndex.removeStubIndexKeys(inputId, maps);
        }

        private static void removeStubIndexKeys(int inputId, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> indexedStubs) {
            if (indexedStubs == null) {
                MyIndex.$$$reportNull$$$0(5);
            }
            StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
            for (StubIndexKey key : indexedStubs.keySet()) {
                stubIndex.removeTransientDataForFile(key, inputId, indexedStubs.get(key).keySet());
            }
        }

        @NotNull
        private static Map<StubIndexKey, Map<Object, StubIdList>> getStubIndexMaps(@NotNull Map<? extends Integer, ? extends SerializedStubTree> data2) {
            if (data2 == null) {
                MyIndex.$$$reportNull$$$0(6);
            }
            if (data2.isEmpty()) {
                Map<StubIndexKey, Map<Object, StubIdList>> map2 = Collections.emptyMap();
                if (map2 == null) {
                    MyIndex.$$$reportNull$$$0(7);
                }
                return map2;
            }
            SerializedStubTree tree = data2.values().iterator().next();
            Map<Object, Object> map3 = tree == null ? Collections.emptyMap() : tree.getStubIndicesValueMap();
            if (map3 == null) {
                MyIndex.$$$reportNull$$$0(8);
            }
            return map3;
        }

        @Override
        protected void doClear() throws StorageException, IOException {
            StubIndexImpl stubIndex = StubIndexImpl.getInstanceOrInvalidate();
            if (stubIndex != null) {
                stubIndex.clearAllIndices();
            }
            if (this.myStubVersionMap != null) {
                this.myStubVersionMap.clear();
            }
            super.doClear();
        }

        @Override
        protected void doDispose() throws StorageException {
            try {
                super.doDispose();
            }
            finally {
                this.getStubIndex().dispose();
            }
        }

        @Override
        @NotNull
        protected InputDataDiffBuilder<Integer, SerializedStubTree> getKeysDiffBuilderInMemoryMode(int inputId, @NotNull Map<Integer, SerializedStubTree> keysAndValues) {
            if (keysAndValues == null) {
                MyIndex.$$$reportNull$$$0(9);
            }
            return new StubCumulativeInputDiffBuilder(inputId, keysAndValues.isEmpty() ? null : keysAndValues.values().iterator().next());
        }

        @Override
        public void setIndexedStateForFile(int fileId, @NotNull IndexedFile file2) {
            if (file2 == null) {
                MyIndex.$$$reportNull$$$0(10);
            }
            super.setIndexedStateForFile(fileId, file2);
            if (this.myStubVersionMap != null) {
                try {
                    this.myStubVersionMap.persistIndexedState(fileId, file2.getFile());
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
            if (this.myCompositeBinaryBuilderMap != null) {
                try {
                    this.myCompositeBinaryBuilderMap.persistState(fileId, file2.getFile());
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
        }

        @Override
        public boolean isIndexedStateForFile(int fileId, @NotNull IndexedFile file2) {
            boolean indexedStateForFile;
            if (file2 == null) {
                MyIndex.$$$reportNull$$$0(11);
            }
            if (!(indexedStateForFile = super.isIndexedStateForFile(fileId, file2))) {
                return false;
            }
            if (this.myStubVersionMap == null) {
                return true;
            }
            try {
                return this.myStubVersionMap.isIndexed(fileId, file2.getFile());
            }
            catch (IOException e) {
                LOG.error(e);
                return false;
            }
        }

        @Override
        protected boolean isIndexConfigurationUpToDate(int fileId, @NotNull IndexedFile file2) {
            if (file2 == null) {
                MyIndex.$$$reportNull$$$0(12);
            }
            if (this.myCompositeBinaryBuilderMap != null) {
                try {
                    return this.myCompositeBinaryBuilderMap.isUpToDateState(fileId, file2.getFile());
                }
                catch (IOException e) {
                    LOG.error(e);
                    return false;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keys";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexedStubs";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keysAndValues";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStubIndex";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStubIndexMaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeTransientDataForInMemoryKeys";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "removeTransientDataForKeys";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeStubIndexKeys";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getStubIndexMaps";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getKeysDiffBuilderInMemoryMode";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setIndexedStateForFile";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "isIndexedStateForFile";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "isIndexConfigurationUpToDate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

