/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.diagnostic.PluginException;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TObjectLongHashMap;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StubVersionMap {
    private static final String INDEXED_FILETYPES = "indexed_filetypes";
    private static final String RECORD_SEPARATOR = "\uffff";
    private static final String LINE_SEPARATOR = "\n";
    private static final Charset ourEncoding = StandardCharsets.UTF_8;
    private static final Logger LOG = Logger.getInstance(StubVersionMap.class);
    private final Map<FileType, Object> fileTypeToVersionOwner = new THashMap<FileType, Object>();
    private final TObjectLongHashMap<FileType> fileTypeToVersion = new TObjectLongHashMap();
    private final TLongObjectHashMap<FileType> versionToFileType = new TLongObjectHashMap();
    private long myStubIndexStamp;
    private static final FileAttribute VERSION_STAMP = new FileAttribute("stubIndex.versionStamp", 2, true);

    StubVersionMap() throws IOException {
        for (FileType fileType : FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
            Object owner = StubVersionMap.getVersionOwner(fileType);
            if (owner == null) continue;
            this.fileTypeToVersionOwner.put(fileType, owner);
        }
        this.updateState();
    }

    private void updateState() throws IOException {
        long currentStubIndexStamp = IndexingStamp.getIndexCreationStamp(StubUpdatingIndex.INDEX_ID);
        File allIndexedFiles = StubVersionMap.allIndexedFilesRegistryFile();
        ArrayList<String> removedFileTypes = new ArrayList<String>();
        ArrayList<FileType> updatedFileTypes = new ArrayList<FileType>();
        ArrayList<FileType> addedFileTypes = new ArrayList<FileType>();
        long lastUsedCounter = currentStubIndexStamp;
        boolean canUsePreviousMappings = allIndexedFiles.exists();
        FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
        THashSet<FileType> loadedFileTypes = new THashSet<FileType>();
        if (canUsePreviousMappings) {
            List<String> stringList = StringUtil.split(FileUtil.loadFile(allIndexedFiles, ourEncoding), LINE_SEPARATOR);
            long allIndexedFilesVersion = Long.parseLong((String)stringList.get(0));
            if (allIndexedFilesVersion == currentStubIndexStamp) {
                int size = stringList.size();
                for (int i = 1; i < size; ++i) {
                    List<String> strings = StringUtil.split((String)stringList.get(i), RECORD_SEPARATOR);
                    String fileTypeName = strings.get(0);
                    long usedTimeStamp = Long.parseLong(strings.get(2));
                    lastUsedCounter = Math.min(lastUsedCounter, usedTimeStamp);
                    FileType fileType = fileTypeRegistry.findFileTypeByName(fileTypeName);
                    if (fileType == null) {
                        removedFileTypes.add(fileTypeName);
                        continue;
                    }
                    loadedFileTypes.add(fileType);
                    Object owner = StubVersionMap.getVersionOwner(fileType);
                    if (owner == null) {
                        removedFileTypes.add(fileTypeName);
                        continue;
                    }
                    if (!Comparing.equal(strings.get(1), StubVersionMap.typeAndVersion(owner))) {
                        updatedFileTypes.add(fileType);
                        continue;
                    }
                    this.registerStamp(fileType, usedTimeStamp);
                }
            } else {
                canUsePreviousMappings = false;
            }
        }
        for (FileType fileType : this.fileTypeToVersionOwner.keySet()) {
            if (loadedFileTypes.contains(fileType)) continue;
            addedFileTypes.add(fileType);
        }
        if (!(!canUsePreviousMappings || addedFileTypes.isEmpty() && removedFileTypes.isEmpty())) {
            StubUpdatingIndex.LOG.info("requesting complete stub index rebuild due to changes: " + (addedFileTypes.isEmpty() ? "" : "added file types:" + StringUtil.join(addedFileTypes, FileType::getName, ",") + ";") + (removedFileTypes.isEmpty() ? "" : "removed file types:" + StringUtil.join(removedFileTypes, ",")));
            throw new IOException();
        }
        long counter = lastUsedCounter - 1L;
        for (FileType fileType : ContainerUtil.concat(updatedFileTypes, addedFileTypes)) {
            while (this.versionToFileType.containsKey(counter)) {
                --counter;
            }
            this.registerStamp(fileType, counter);
        }
        if (!(addedFileTypes.isEmpty() && updatedFileTypes.isEmpty() && removedFileTypes.isEmpty())) {
            if (!addedFileTypes.isEmpty()) {
                StubUpdatingIndex.LOG.info("Following new file types will be indexed:" + StringUtil.join(addedFileTypes, FileType::getName, ","));
            }
            if (!updatedFileTypes.isEmpty()) {
                StubUpdatingIndex.LOG.info("Stub version was changed for " + StringUtil.join(updatedFileTypes, FileType::getName, ","));
            }
            if (!removedFileTypes.isEmpty()) {
                StubUpdatingIndex.LOG.info("Following file types will not be indexed:" + StringUtil.join(removedFileTypes, ","));
            }
            StringBuilder allFileTypes = new StringBuilder();
            allFileTypes.append(currentStubIndexStamp).append(LINE_SEPARATOR);
            for (FileType fileType : this.fileTypeToVersionOwner.keySet()) {
                Object owner = this.fileTypeToVersionOwner.get(fileType);
                long timestamp = this.fileTypeToVersion.get(fileType);
                allFileTypes.append(fileType.getName()).append(RECORD_SEPARATOR).append(StubVersionMap.typeAndVersion(owner)).append(RECORD_SEPARATOR).append(timestamp).append(LINE_SEPARATOR);
            }
            FileUtil.writeToFile(allIndexedFiles, allFileTypes.toString().getBytes(ourEncoding));
        }
        this.myStubIndexStamp = currentStubIndexStamp;
    }

    private void registerStamp(FileType fileTypeByName, long stamp) {
        this.fileTypeToVersion.put(fileTypeByName, stamp);
        FileType previousType = this.versionToFileType.put(stamp, fileTypeByName);
        if (previousType != null) assert (false);
    }

    static Object getVersionOwner(FileType fileType) {
        BinaryFileStubBuilder builder2;
        IFileElementType type;
        Language l;
        ParserDefinition parserDefinition;
        Object owner = null;
        if (fileType instanceof LanguageFileType && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l = ((LanguageFileType)fileType).getLanguage())) != null && (type = parserDefinition.getFileNodeType()) instanceof IStubFileElementType) {
            owner = type;
        }
        if ((builder2 = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType)) != null) {
            owner = builder2;
        }
        return owner;
    }

    public long getStamp(FileType type) {
        return this.fileTypeToVersion.get(type);
    }

    void clear() {
        this.fileTypeToVersion.clear();
        this.versionToFileType.clear();
        try {
            this.updateState();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    private static File allIndexedFilesRegistryFile() {
        return new File(new File(IndexInfrastructure.getIndexRootDir(StubUpdatingIndex.INDEX_ID), ".fileTypes"), INDEXED_FILETYPES);
    }

    @NotNull
    private static String typeAndVersion(Object owner) {
        String string = StubVersionMap.info(owner) + "," + StubVersionMap.version(owner);
        if (string == null) {
            StubVersionMap.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static String info(Object owner) {
        if (owner instanceof IStubFileElementType) {
            return "stub:" + owner.getClass().getName();
        }
        return "binary stub builder:" + owner.getClass().getName();
    }

    private static int version(Object owner) {
        if (owner instanceof IStubFileElementType) {
            IStubFileElementType elementType = (IStubFileElementType)owner;
            if (elementType.getLanguage() instanceof TemplateLanguage && elementType.getStubVersion() < IStubFileElementType.getTemplateStubVersion()) {
                PluginException.logPluginError(LOG, elementType.getLanguage() + " stub version should call super.getStubVersion()", null, elementType.getClass());
            }
            return elementType.getStubVersion();
        }
        return ((BinaryFileStubBuilder)owner).getStubVersion();
    }

    private int getIndexingTimestampDiffForFileType(FileType type) {
        return (int)(this.myStubIndexStamp - this.fileTypeToVersion.get(type));
    }

    @Nullable
    private FileType getFileTypeByIndexingTimestampDiff(int diff) {
        return this.versionToFileType.get(this.myStubIndexStamp - (long)diff);
    }

    public void persistIndexedState(int fileId, @NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            StubVersionMap.$$$reportNull$$$0(1);
        }
        try (DataOutputStream stream = FSRecords.writeAttribute(fileId, VERSION_STAMP);){
            FileType type = ProgressManager.getInstance().computeInNonCancelableSection(() -> file2.getFileType());
            DataInputOutputUtil.writeINT(stream, this.getIndexingTimestampDiffForFileType(type));
        }
    }

    public boolean isIndexed(int fileId, @NotNull VirtualFile file2) throws IOException {
        DataInputStream stream;
        int diff;
        if (file2 == null) {
            StubVersionMap.$$$reportNull$$$0(2);
        }
        int n = diff = (stream = FSRecords.readAttributeWithLock(fileId, VERSION_STAMP)) != null ? DataInputOutputUtil.readINT(stream) : 0;
        if (diff == 0) {
            return false;
        }
        FileType fileType = this.getFileTypeByIndexingTimestampDiff(diff);
        return fileType != null && this.getStamp(file2.getFileType()) == this.getStamp(fileType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubVersionMap";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "typeAndVersion";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubVersionMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "persistIndexedState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isIndexed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

