/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.ITemplateDataElementType;
import com.intellij.psi.templateLanguages.OuterLanguageElementImpl;
import com.intellij.psi.templateLanguages.SimpleTreePatcher;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TreePatcher;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataElementType
extends IFileElementType
implements ITemplateDataElementType {
    public static final LanguageExtension<TreePatcher> TREE_PATCHER = new LanguageExtension<SimpleTreePatcher>("com.intellij.lang.treePatcher", new SimpleTreePatcher());
    @NotNull
    private final IElementType myTemplateElementType;
    @NotNull
    private final IElementType myOuterElementType;

    public TemplateDataElementType(@NonNls String debugName, Language language2, @NotNull IElementType templateElementType, @NotNull IElementType outerElementType) {
        if (templateElementType == null) {
            TemplateDataElementType.$$$reportNull$$$0(0);
        }
        if (outerElementType == null) {
            TemplateDataElementType.$$$reportNull$$$0(1);
        }
        super(debugName, language2);
        this.myTemplateElementType = templateElementType;
        this.myOuterElementType = outerElementType;
    }

    protected Lexer createBaseLexer(TemplateLanguageFileViewProvider viewProvider) {
        return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(viewProvider.getBaseLanguage())).createLexer(viewProvider.getManager().getProject());
    }

    protected LanguageFileType createTemplateFakeFileType(Language language2) {
        return new TemplateFileType(language2);
    }

    @Override
    public ASTNode parseContents(@NotNull ASTNode chameleon) {
        if (chameleon == null) {
            TemplateDataElementType.$$$reportNull$$$0(2);
        }
        CharTable charTable = SharedImplUtil.findCharTableByTree(chameleon);
        FileElement fileElement = TreeUtil.getFileElement((TreeElement)chameleon);
        PsiFile psiFile = (PsiFile)fileElement.getPsi();
        PsiFile originalPsiFile = psiFile.getOriginalFile();
        TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)originalPsiFile.getViewProvider();
        Language templateLanguage = this.getTemplateFileLanguage(viewProvider);
        CharSequence sourceCode = chameleon.getChars();
        RangeCollector collector = new RangeCollector();
        PsiFile templatePsiFile = this.createTemplateFile(psiFile, templateLanguage, sourceCode, viewProvider, collector);
        FileElement templateFileElement = ((PsiFileImpl)templatePsiFile).calcTreeElement();
        return DebugUtil.performPsiModification("template language parsing", () -> {
            this.prepareParsedTemplateFile(templateFileElement);
            this.insertOuterElementsAndRemoveRanges(templateFileElement, sourceCode, collector, charTable);
            TreeElement childNode = templateFileElement.getFirstChildNode();
            DebugUtil.checkTreeStructure(templateFileElement);
            DebugUtil.checkTreeStructure(chameleon);
            if (fileElement != chameleon) {
                DebugUtil.checkTreeStructure(psiFile.getNode());
                DebugUtil.checkTreeStructure(originalPsiFile.getNode());
            }
            return childNode;
        });
    }

    protected void prepareParsedTemplateFile(@NotNull FileElement root) {
        if (root == null) {
            TemplateDataElementType.$$$reportNull$$$0(3);
        }
    }

    protected Language getTemplateFileLanguage(TemplateLanguageFileViewProvider viewProvider) {
        return viewProvider.getTemplateDataLanguage();
    }

    protected PsiFile createTemplateFile(PsiFile psiFile, Language templateLanguage, CharSequence sourceCode, TemplateLanguageFileViewProvider viewProvider, @NotNull RangeCollector rangeCollector) {
        if (rangeCollector == null) {
            TemplateDataElementType.$$$reportNull$$$0(4);
        }
        CharSequence templateSourceCode = this.createTemplateText(sourceCode, this.createBaseLexer(viewProvider), rangeCollector);
        return this.createPsiFileFromSource(templateLanguage, templateSourceCode, psiFile.getManager());
    }

    protected CharSequence createTemplateText(@NotNull CharSequence sourceCode, @NotNull Lexer baseLexer, @NotNull RangeCollector rangeCollector) {
        if (sourceCode == null) {
            TemplateDataElementType.$$$reportNull$$$0(5);
        }
        if (baseLexer == null) {
            TemplateDataElementType.$$$reportNull$$$0(6);
        }
        if (rangeCollector == null) {
            TemplateDataElementType.$$$reportNull$$$0(7);
        }
        StringBuilder result2 = new StringBuilder(sourceCode.length());
        baseLexer.start(sourceCode);
        TextRange currentRange = TextRange.EMPTY_RANGE;
        while (baseLexer.getTokenType() != null) {
            TextRange newRange = TextRange.create(baseLexer.getTokenStart(), baseLexer.getTokenEnd());
            assert (currentRange.getEndOffset() == newRange.getStartOffset()) : "Inconsistent tokens stream from " + baseLexer + ": " + TemplateDataElementType.getRangeDump(currentRange, sourceCode) + " followed by " + TemplateDataElementType.getRangeDump(newRange, sourceCode);
            currentRange = newRange;
            if (baseLexer.getTokenType() == this.myTemplateElementType) {
                this.appendCurrentTemplateToken(result2, sourceCode, baseLexer, rangeCollector);
            } else {
                rangeCollector.addOuterRange(currentRange);
            }
            baseLexer.advance();
        }
        return result2;
    }

    @NotNull
    private static String getRangeDump(@NotNull TextRange range2, @NotNull CharSequence sequence) {
        if (range2 == null) {
            TemplateDataElementType.$$$reportNull$$$0(8);
        }
        if (sequence == null) {
            TemplateDataElementType.$$$reportNull$$$0(9);
        }
        String string = "'" + StringUtil.escapeLineBreak(range2.subSequence(sequence).toString()) + "' " + range2;
        if (string == null) {
            TemplateDataElementType.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected void appendCurrentTemplateToken(@NotNull StringBuilder result2, @NotNull CharSequence buf, @NotNull Lexer lexer, @NotNull RangeCollector collector) {
        if (result2 == null) {
            TemplateDataElementType.$$$reportNull$$$0(11);
        }
        if (buf == null) {
            TemplateDataElementType.$$$reportNull$$$0(12);
        }
        if (lexer == null) {
            TemplateDataElementType.$$$reportNull$$$0(13);
        }
        if (collector == null) {
            TemplateDataElementType.$$$reportNull$$$0(14);
        }
        result2.append(buf, lexer.getTokenStart(), lexer.getTokenEnd());
    }

    private void insertOuterElementsAndRemoveRanges(@NotNull TreeElement templateFileElement, @NotNull CharSequence sourceCode, @NotNull RangeCollector rangeCollector, @NotNull CharTable charTable) {
        if (templateFileElement == null) {
            TemplateDataElementType.$$$reportNull$$$0(15);
        }
        if (sourceCode == null) {
            TemplateDataElementType.$$$reportNull$$$0(16);
        }
        if (rangeCollector == null) {
            TemplateDataElementType.$$$reportNull$$$0(17);
        }
        if (charTable == null) {
            TemplateDataElementType.$$$reportNull$$$0(18);
        }
        TreePatcher templateTreePatcher = TREE_PATCHER.forLanguage(templateFileElement.getPsi().getLanguage());
        LeafElement currentLeaf = TreeUtil.findFirstLeaf(templateFileElement);
        int currentLeafOffset = 0;
        for (TextRange rangeToProcess : rangeCollector.myOuterAndRemoveRanges) {
            int rangeStartOffset = rangeToProcess.getStartOffset();
            while (currentLeaf != null && currentLeafOffset < rangeStartOffset && !TemplateDataElementType.shouldRemoveRangeInsideLeaf(currentLeaf, currentLeafOffset, rangeToProcess)) {
                if ((currentLeafOffset += currentLeaf.getTextLength()) > rangeStartOffset) {
                    int splitOffset = currentLeaf.getTextLength() - (currentLeafOffset - rangeStartOffset);
                    currentLeaf = templateTreePatcher.split(currentLeaf, splitOffset, charTable);
                    currentLeafOffset = rangeStartOffset;
                }
                currentLeaf = TreeUtil.nextLeaf(currentLeaf);
            }
            if (rangeToProcess instanceof RangeToRemove) {
                assert (currentLeaf != null);
                currentLeaf = TemplateDataElementType.removeElementsForRange(currentLeaf, currentLeafOffset, rangeToProcess, templateTreePatcher, charTable);
                continue;
            }
            if (currentLeaf == null) {
                this.insertLastOuterElementForRange((CompositeElement)templateFileElement, rangeToProcess, sourceCode, rangeCollector, charTable);
                continue;
            }
            currentLeaf = this.insertOuterElementFromRange(currentLeaf, rangeToProcess, sourceCode, templateTreePatcher, charTable);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String after2 = templateFileElement.getText();
            assert (after2.contentEquals(sourceCode)) : "Text presentation for the new tree must be the same: \nbefore: " + sourceCode + "\nafter: " + after2;
        }
    }

    private static boolean shouldRemoveRangeInsideLeaf(LeafElement currentLeaf, int currentLeafOffset, TextRange rangeToProcess) {
        return rangeToProcess instanceof RangeToRemove && currentLeafOffset + currentLeaf.getTextLength() > rangeToProcess.getEndOffset();
    }

    private void insertLastOuterElementForRange(@NotNull CompositeElement templateFileElement, @NotNull TextRange outerElementRange, @NotNull CharSequence sourceCode, @NotNull RangeCollector collector, @NotNull CharTable charTable) {
        if (templateFileElement == null) {
            TemplateDataElementType.$$$reportNull$$$0(19);
        }
        if (outerElementRange == null) {
            TemplateDataElementType.$$$reportNull$$$0(20);
        }
        if (sourceCode == null) {
            TemplateDataElementType.$$$reportNull$$$0(21);
        }
        if (collector == null) {
            TemplateDataElementType.$$$reportNull$$$0(22);
        }
        if (charTable == null) {
            TemplateDataElementType.$$$reportNull$$$0(23);
        }
        assert (TemplateDataElementType.isLastRange(collector.myOuterAndRemoveRanges, outerElementRange)) : "This should only happen for the last inserted range. Got " + RangeCollector.access$000(collector).lastIndexOf(outerElementRange) + " of " + (RangeCollector.access$000(collector).size() - 1);
        templateFileElement.rawAddChildren(this.createOuterLanguageElement(charTable.intern(outerElementRange.subSequence(sourceCode)), this.myOuterElementType));
    }

    @NotNull
    private LeafElement insertOuterElementFromRange(@NotNull LeafElement currentLeaf, @NotNull TextRange outerElementRange, @NotNull CharSequence sourceCode, @NotNull TreePatcher templateTreePatcher, @NotNull CharTable charTable) {
        if (currentLeaf == null) {
            TemplateDataElementType.$$$reportNull$$$0(24);
        }
        if (outerElementRange == null) {
            TemplateDataElementType.$$$reportNull$$$0(25);
        }
        if (sourceCode == null) {
            TemplateDataElementType.$$$reportNull$$$0(26);
        }
        if (templateTreePatcher == null) {
            TemplateDataElementType.$$$reportNull$$$0(27);
        }
        if (charTable == null) {
            TemplateDataElementType.$$$reportNull$$$0(28);
        }
        OuterLanguageElementImpl newLeaf = this.createOuterLanguageElement(charTable.intern(outerElementRange.subSequence(sourceCode)), this.myOuterElementType);
        CompositeElement parent = currentLeaf.getTreeParent();
        templateTreePatcher.insert(parent, currentLeaf, newLeaf);
        OuterLanguageElementImpl outerLanguageElementImpl = newLeaf;
        if (outerLanguageElementImpl == null) {
            TemplateDataElementType.$$$reportNull$$$0(29);
        }
        return outerLanguageElementImpl;
    }

    @Nullable
    private static LeafElement removeElementsForRange(@NotNull LeafElement startLeaf, int startLeafOffset, @NotNull TextRange rangeToRemove, @NotNull TreePatcher templateTreePatcher, @NotNull CharTable charTable) {
        if (startLeaf == null) {
            TemplateDataElementType.$$$reportNull$$$0(30);
        }
        if (rangeToRemove == null) {
            TemplateDataElementType.$$$reportNull$$$0(31);
        }
        if (templateTreePatcher == null) {
            TemplateDataElementType.$$$reportNull$$$0(32);
        }
        if (charTable == null) {
            TemplateDataElementType.$$$reportNull$$$0(33);
        }
        LeafElement nextLeaf = startLeaf;
        int nextLeafStartOffset = startLeafOffset;
        ArrayList<LeafElement> leavesToRemove = new ArrayList<LeafElement>();
        while (nextLeaf != null && rangeToRemove.containsRange(nextLeafStartOffset, nextLeafStartOffset + nextLeaf.getTextLength())) {
            leavesToRemove.add(nextLeaf);
            nextLeafStartOffset += nextLeaf.getTextLength();
            nextLeaf = TreeUtil.nextLeaf(nextLeaf);
        }
        nextLeaf = TemplateDataElementType.splitOrRemoveRangeInsideLeafIfOverlap(nextLeaf, nextLeafStartOffset, rangeToRemove, templateTreePatcher, charTable);
        for (TreeElement treeElement : leavesToRemove) {
            treeElement.rawRemove();
        }
        return nextLeaf;
    }

    @Nullable
    private static LeafElement splitOrRemoveRangeInsideLeafIfOverlap(@Nullable LeafElement nextLeaf, int nextLeafStartOffset, @NotNull TextRange rangeToRemove, @NotNull TreePatcher templateTreePatcher, @NotNull CharTable charTable) {
        if (rangeToRemove == null) {
            TemplateDataElementType.$$$reportNull$$$0(34);
        }
        if (templateTreePatcher == null) {
            TemplateDataElementType.$$$reportNull$$$0(35);
        }
        if (charTable == null) {
            TemplateDataElementType.$$$reportNull$$$0(36);
        }
        if (nextLeaf == null) {
            return null;
        }
        if (nextLeafStartOffset >= rangeToRemove.getEndOffset()) {
            return nextLeaf;
        }
        if (rangeToRemove.getStartOffset() > nextLeafStartOffset) {
            return templateTreePatcher.removeRange(nextLeaf, rangeToRemove.shiftLeft(nextLeafStartOffset), charTable);
        }
        int offsetToSplit = rangeToRemove.getEndOffset() - nextLeafStartOffset;
        return TemplateDataElementType.removeLeftPartOfLeaf(nextLeaf, offsetToSplit, templateTreePatcher, charTable);
    }

    @NotNull
    private static LeafElement removeLeftPartOfLeaf(@NotNull LeafElement nextLeaf, int offsetToSplit, @NotNull TreePatcher templateTreePatcher, @NotNull CharTable charTable) {
        if (nextLeaf == null) {
            TemplateDataElementType.$$$reportNull$$$0(37);
        }
        if (templateTreePatcher == null) {
            TemplateDataElementType.$$$reportNull$$$0(38);
        }
        if (charTable == null) {
            TemplateDataElementType.$$$reportNull$$$0(39);
        }
        LeafElement lLeaf = templateTreePatcher.split(nextLeaf, offsetToSplit, charTable);
        LeafElement rLeaf = TreeUtil.nextLeaf(lLeaf);
        assert (rLeaf != null);
        lLeaf.rawRemove();
        LeafElement leafElement = rLeaf;
        if (leafElement == null) {
            TemplateDataElementType.$$$reportNull$$$0(40);
        }
        return leafElement;
    }

    private static boolean isLastRange(@NotNull List<TextRange> outerElementsRanges, @NotNull TextRange outerElementRange) {
        if (outerElementsRanges == null) {
            TemplateDataElementType.$$$reportNull$$$0(41);
        }
        if (outerElementRange == null) {
            TemplateDataElementType.$$$reportNull$$$0(42);
        }
        return outerElementsRanges.get(outerElementsRanges.size() - 1) == outerElementRange;
    }

    protected OuterLanguageElementImpl createOuterLanguageElement(@NotNull CharSequence internedTokenText, @NotNull IElementType outerElementType) {
        if (internedTokenText == null) {
            TemplateDataElementType.$$$reportNull$$$0(43);
        }
        if (outerElementType == null) {
            TemplateDataElementType.$$$reportNull$$$0(44);
        }
        return new OuterLanguageElementImpl(outerElementType, internedTokenText);
    }

    protected PsiFile createPsiFileFromSource(final Language language2, CharSequence sourceCode, PsiManager manager) {
        LightVirtualFile virtualFile2 = new LightVirtualFile("foo", this.createTemplateFakeFileType(language2), sourceCode, LocalTimeCounter.currentTime());
        SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(manager, virtualFile2, false){

            @Override
            @NotNull
            public Language getBaseLanguage() {
                Language language22 = language2;
                if (language22 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return language22;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataElementType$1", "getBaseLanguage"));
            }
        };
        SingleRootFileViewProvider.doNotCheckFileSizeLimit(virtualFile2);
        return viewProvider.getPsi(language2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 29: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 29: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateElementType";
                break;
            }
            case 1: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerElementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeCollector";
                break;
            }
            case 5: 
            case 16: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceCode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLexer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 10: 
            case 29: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/templateLanguages/TemplateDataElementType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFileElement";
                break;
            }
            case 18: 
            case 23: 
            case 28: 
            case 33: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charTable";
                break;
            }
            case 20: 
            case 25: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerElementRange";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLeaf";
                break;
            }
            case 27: 
            case 32: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateTreePatcher";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startLeaf";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToRemove";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextLeaf";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerElementsRanges";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internedTokenText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/templateLanguages/TemplateDataElementType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeDump";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "insertOuterElementFromRange";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLeftPartOfLeaf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseContents";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareParsedTemplateFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRangeDump";
                break;
            }
            case 10: 
            case 29: 
            case 40: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendCurrentTemplateToken";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "insertOuterElementsAndRemoveRanges";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "insertLastOuterElementForRange";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "insertOuterElementFromRange";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "removeElementsForRange";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "splitOrRemoveRangeInsideLeafIfOverlap";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "removeLeftPartOfLeaf";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isLastRange";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createOuterLanguageElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 29: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RangeToRemove
    extends TextRange {
        private RangeToRemove(int startOffset, int endOffset) {
            super(startOffset, endOffset);
        }
    }

    protected static class RangeCollector {
        private final List<TextRange> myOuterAndRemoveRanges = new ArrayList<TextRange>();

        protected RangeCollector() {
        }

        public void addOuterRange(@NotNull TextRange newRange) {
            int lastItemIndex;
            TextRange lastRange;
            if (newRange == null) {
                RangeCollector.$$$reportNull$$$0(0);
            }
            if (newRange.isEmpty()) {
                return;
            }
            this.assertRangeOrder(newRange);
            if (!this.myOuterAndRemoveRanges.isEmpty() && (lastRange = this.myOuterAndRemoveRanges.get(lastItemIndex = this.myOuterAndRemoveRanges.size() - 1)).getEndOffset() == newRange.getStartOffset() && !(lastRange instanceof RangeToRemove)) {
                this.myOuterAndRemoveRanges.set(lastItemIndex, TextRange.create(lastRange.getStartOffset(), newRange.getEndOffset()));
                return;
            }
            this.myOuterAndRemoveRanges.add(newRange);
        }

        public void addRangeToRemove(@NotNull TextRange rangeToRemove) {
            if (rangeToRemove == null) {
                RangeCollector.$$$reportNull$$$0(1);
            }
            if (rangeToRemove.isEmpty()) {
                return;
            }
            this.assertRangeOrder(rangeToRemove);
            this.myOuterAndRemoveRanges.add(new RangeToRemove(rangeToRemove.getStartOffset(), rangeToRemove.getEndOffset()));
        }

        private void assertRangeOrder(@NotNull TextRange newRange) {
            if (newRange == null) {
                RangeCollector.$$$reportNull$$$0(2);
            }
            TextRange range2 = ContainerUtil.getLastItem(this.myOuterAndRemoveRanges);
            assert (range2 == null || newRange.getStartOffset() >= range2.getStartOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeToRemove";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/templateLanguages/TemplateDataElementType$RangeCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addOuterRange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRangeToRemove";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "assertRangeOrder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class TemplateFileType
    extends LanguageFileType {
        private final Language myLanguage;

        protected TemplateFileType(Language language2) {
            super(language2);
            this.myLanguage = language2;
        }

        @Override
        @NotNull
        public String getDefaultExtension() {
            return "";
        }

        @Override
        @NotNull
        @NonNls
        public String getDescription() {
            String string = "fake for language" + this.myLanguage.getID();
            if (string == null) {
                TemplateFileType.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return null;
        }

        @Override
        @NotNull
        @NonNls
        public String getName() {
            String string = this.myLanguage.getID();
            if (string == null) {
                TemplateFileType.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/psi/templateLanguages/TemplateDataElementType$TemplateFileType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

