/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.DependentLanguage;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguagePerFileMappings;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateDataLanguagePatterns;
import com.intellij.psi.templateLanguages.TemplateDataLanguagePusher;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TemplateDataLanguageMappings", storages={@Storage(value="templateLanguages.xml")})
public class TemplateDataLanguageMappings
extends LanguagePerFileMappings<Language> {
    private final FilePropertyPusher<Language> myPropertyPusher = new TemplateDataLanguagePusher();

    public static TemplateDataLanguageMappings getInstance(Project project2) {
        return ServiceManager.getService(project2, TemplateDataLanguageMappings.class);
    }

    public TemplateDataLanguageMappings(Project project2) {
        super(project2);
    }

    @Override
    protected String serialize(Language language2) {
        return language2.getID();
    }

    @Override
    public List<Language> getAvailableValues() {
        return TemplateDataLanguageMappings.getTemplateableLanguages();
    }

    @Override
    @Nullable
    public Language getMapping(@Nullable VirtualFile file2) {
        Language t = (Language)this.getConfiguredMapping(file2);
        return t == null || t == Language.ANY ? this.getDefaultMapping(file2) : t;
    }

    @Override
    public Language getDefaultMapping(@Nullable VirtualFile file2) {
        return TemplateDataLanguageMappings.getDefaultMappingForFile(file2);
    }

    @Nullable
    public static Language getDefaultMappingForFile(@Nullable VirtualFile file2) {
        return file2 == null ? null : TemplateDataLanguagePatterns.getInstance().getTemplateDataLanguageByFileName(file2);
    }

    public static List<Language> getTemplateableLanguages() {
        return ContainerUtil.findAll(Language.getRegisteredLanguages(), new Condition<Language>(){

            @Override
            public boolean value(Language language2) {
                if (language2 == Language.ANY) {
                    return false;
                }
                if (language2 instanceof TemplateLanguage || language2 instanceof DependentLanguage || language2 instanceof InjectableLanguage) {
                    return false;
                }
                if (language2.getBaseLanguage() != null) {
                    return this.value(language2.getBaseLanguage());
                }
                return true;
            }
        });
    }

    @Override
    @NotNull
    protected FilePropertyPusher<Language> getFilePropertyPusher() {
        FilePropertyPusher<Language> filePropertyPusher = this.myPropertyPusher;
        if (filePropertyPusher == null) {
            TemplateDataLanguageMappings.$$$reportNull$$$0(0);
        }
        return filePropertyPusher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataLanguageMappings", "getFilePropertyPusher"));
    }
}

