/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataLanguagePusher
implements FilePropertyPusher<Language> {
    public static final Key<Language> KEY = Key.create("TEMPLATE_DATA_LANGUAGE");
    private static final VfsDependentEnum<String> ourLanguagesEnumerator = new VfsDependentEnum<String>("languages", EnumeratorStringDescriptor.INSTANCE, 1);
    private static final FileAttribute PERSISTENCE = new FileAttribute("template_language", 2, true);

    @Override
    @NotNull
    public Key<Language> getFileDataKey() {
        Key<Language> key = KEY;
        if (key == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Override
    public boolean pushDirectoriesOnly() {
        return false;
    }

    @Override
    @NotNull
    public Language getDefaultValue() {
        Language language2 = Language.ANY;
        if (language2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(1);
        }
        return language2;
    }

    @Override
    @Nullable
    public Language getImmediateValue(@NotNull Project project2, @Nullable VirtualFile file2) {
        if (project2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(2);
        }
        return (Language)TemplateDataLanguageMappings.getInstance(project2).getImmediateMapping(file2);
    }

    @Override
    @Nullable
    public Language getImmediateValue(@NotNull Module module2) {
        if (module2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Override
    public boolean acceptsFile(@NotNull VirtualFile file2) {
        FileType type;
        if (file2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(4);
        }
        return (type = file2.getFileType()) instanceof LanguageFileType && ((LanguageFileType)type).getLanguage() instanceof TemplateLanguage;
    }

    @Override
    public boolean acceptsDirectory(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(6);
        }
        return true;
    }

    @Override
    public void persistAttribute(@NotNull Project project2, @NotNull VirtualFile fileOrDir, @NotNull Language value2) throws IOException {
        if (project2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(7);
        }
        if (fileOrDir == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(8);
        }
        if (value2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(9);
        }
        boolean read2 = false;
        try (DataInputStream iStream = PERSISTENCE.readAttribute(fileOrDir);){
            if (iStream != null) {
                read2 = true;
                int oldLanguage = DataInputOutputUtil.readINT(iStream);
                String oldLanguageId = ourLanguagesEnumerator.getById(oldLanguage);
                if (value2.getID().equals(oldLanguageId)) {
                    return;
                }
            }
        }
        if (value2 != Language.ANY || read2) {
            var6_6 = null;
            try (DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);){
                DataInputOutputUtil.writeINT(oStream, ourLanguagesEnumerator.getId(value2.getID()));
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            PushedFilePropertiesUpdater.getInstance(project2).filePropertiesChanged(fileOrDir, this::acceptsFile);
        }
    }

    @Override
    public void afterRootsChanged(@NotNull Project project2) {
        if (project2 == null) {
            TemplateDataLanguagePusher.$$$reportNull$$$0(10);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDataKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/templateLanguages/TemplateDataLanguagePusher";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "persistAttribute";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "afterRootsChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

