/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.diagnostic.LoadingState;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IElementType {
    private static final Logger LOG = Logger.getInstance(IElementType.class);
    public static final IElementType[] EMPTY_ARRAY = new IElementType[0];
    public static final ArrayFactory<IElementType> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new IElementType[count];
    public static final Predicate TRUE = type -> true;
    public static final short FIRST_TOKEN_INDEX = 1;
    private static final short MAX_INDEXED_TYPES = 15000;
    private static short size;
    private static volatile IElementType @NotNull [] ourRegistry;
    @NonNls
    private static final Object lock;
    private final short myIndex;
    @NonNls
    @NotNull
    private final String myDebugName;
    @NotNull
    private final Language myLanguage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static IElementType @NotNull [] push(IElementType @NotNull [] types) {
        if (types == null) {
            IElementType.$$$reportNull$$$0(0);
        }
        Object object = lock;
        // MONITORENTER : object
        IElementType[] oldRegistry = ourRegistry;
        ourRegistry = types;
        size = (short)ContainerUtil.skipNulls(Arrays.asList(ourRegistry)).size();
        // MONITOREXIT : object
        if (oldRegistry != null) return oldRegistry;
        IElementType.$$$reportNull$$$0(1);
        return oldRegistry;
    }

    public static void unregisterElementTypes(@NotNull ClassLoader loader) {
        if (loader == null) {
            IElementType.$$$reportNull$$$0(2);
        }
        for (int i = 0; i < ourRegistry.length; ++i) {
            IElementType type = ourRegistry[i];
            if (type == null || type.getClass().getClassLoader() != loader) continue;
            IElementType.ourRegistry[i] = null;
        }
    }

    public static void unregisterElementTypes(@NotNull Language language2) {
        if (language2 == null) {
            IElementType.$$$reportNull$$$0(3);
        }
        for (int i = 0; i < ourRegistry.length; ++i) {
            IElementType type = ourRegistry[i];
            if (type == null || !type.getLanguage().equals(language2)) continue;
            IElementType.ourRegistry[i] = null;
        }
    }

    public IElementType(@NonNls @NotNull String debugName, @Nullable Language language2) {
        if (debugName == null) {
            IElementType.$$$reportNull$$$0(4);
        }
        this(debugName, language2, true);
        if (!(this instanceof IFileElementType)) {
            LoadingState.COMPONENTS_LOADED.checkOccurred();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IElementType(@NonNls @NotNull String debugName, @Nullable Language language2, boolean register2) {
        if (debugName == null) {
            IElementType.$$$reportNull$$$0(5);
        }
        this.myDebugName = debugName;
        Language language3 = this.myLanguage = language2 == null ? Language.ANY : language2;
        if (register2) {
            Object object = lock;
            synchronized (object) {
                short s = size;
                size = (short)(s + 1);
                this.myIndex = s;
                if (this.myIndex >= 15000) {
                    Map<Language, List<IElementType>> byLang = Stream.of(ourRegistry).filter(Objects::nonNull).collect(Collectors.groupingBy(ie -> ie.myLanguage));
                    Map.Entry max = byLang.entrySet().stream().max(Comparator.comparingInt(e -> ((List)e.getValue()).size())).get();
                    List types = (List)max.getValue();
                    LOG.error("Too many element types registered. Out of (short) range. Most of element types (" + types.size() + ") were registered for '" + max.getKey() + "': " + StringUtil.first(StringUtil.join(types, ", "), 300, true));
                }
                IElementType[] newRegistry = this.myIndex >= ourRegistry.length ? ArrayUtil.realloc(ourRegistry, ourRegistry.length * 3 / 2 + 1, ARRAY_FACTORY) : ourRegistry;
                newRegistry[this.myIndex] = this;
                ourRegistry = newRegistry;
            }
        } else {
            this.myIndex = (short)-1;
        }
    }

    @NotNull
    public Language getLanguage() {
        Language language2 = this.myLanguage;
        if (language2 == null) {
            IElementType.$$$reportNull$$$0(6);
        }
        return language2;
    }

    public final short getIndex() {
        return this.myIndex;
    }

    public int hashCode() {
        return this.myIndex >= 0 ? this.myIndex : super.hashCode();
    }

    public String toString() {
        return this.myDebugName;
    }

    public boolean isLeftBound() {
        return false;
    }

    public static IElementType find(short idx) {
        return ourRegistry[idx];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static short getAllocatedTypesCount() {
        Object object = lock;
        synchronized (object) {
            return size;
        }
    }

    public static IElementType @NotNull [] enumerate(@NotNull Predicate p) {
        if (p == null) {
            IElementType.$$$reportNull$$$0(7);
        }
        ArrayList<IElementType> matches = new ArrayList<IElementType>();
        for (IElementType value2 : ourRegistry) {
            if (value2 == null || !p.matches(value2)) continue;
            matches.add(value2);
        }
        IElementType[] iElementTypeArray = matches.toArray(new IElementType[0]);
        if (iElementTypeArray == null) {
            IElementType.$$$reportNull$$$0(8);
        }
        return iElementTypeArray;
    }

    static {
        ourRegistry = EMPTY_ARRAY;
        lock = new String("registry lock");
        IElementType[] init2 = new IElementType[137];
        init2[0] = new IElementType("NULL", Language.ANY, false);
        IElementType.push(init2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/tree/IElementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/tree/IElementType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "push";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "enumerate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unregisterElementTypes";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface Predicate {
        public boolean matches(@NotNull IElementType var1);
    }
}

