/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;

public interface PsiModificationTracker
extends ModificationTracker {
    public static final Key MODIFICATION_COUNT = Key.create("MODIFICATION_COUNT");
    @Deprecated
    public static final Key OUT_OF_CODE_BLOCK_MODIFICATION_COUNT = Key.create("OUT_OF_CODE_BLOCK_MODIFICATION_COUNT");
    @Deprecated
    public static final Key JAVA_STRUCTURE_MODIFICATION_COUNT = Key.create("JAVA_STRUCTURE_MODIFICATION_COUNT");
    public static final Topic<Listener> TOPIC = new Topic<Listener>("modification tracker", Listener.class, Topic.BroadcastDirection.TO_PARENT);

    @Override
    public long getModificationCount();

    @Deprecated
    public long getOutOfCodeBlockModificationCount();

    @Deprecated
    @NotNull
    public ModificationTracker getOutOfCodeBlockModificationTracker();

    @Deprecated
    public long getJavaStructureModificationCount();

    @Deprecated
    @NotNull
    public ModificationTracker getJavaStructureModificationTracker();

    @FunctionalInterface
    public static interface Listener {
        public void modificationCountChanged();
    }

    public static class SERVICE {
        private SERVICE() {
        }

        public static PsiModificationTracker getInstance(Project project2) {
            return ServiceManager.getService(project2, PsiModificationTracker.class);
        }
    }
}

