/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiUtilBase
extends PsiUtilCore
implements PsiEditorUtil {
    private static final Logger LOG = Logger.getInstance(PsiUtilBase.class);
    public static final Comparator<Language> LANGUAGE_COMPARATOR = Comparator.comparing(Language::getID);

    public static boolean isUnderPsiRoot(@NotNull PsiFile root, @NotNull PsiElement element2) {
        PsiFile containingFile;
        if (root == null) {
            PsiUtilBase.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            PsiUtilBase.$$$reportNull$$$0(1);
        }
        if ((containingFile = element2.getContainingFile()) == root) {
            return true;
        }
        for (PsiFile psiRoot : root.getViewProvider().getAllFiles()) {
            if (containingFile != psiRoot) continue;
            return true;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance(root.getProject()).getInjectionHost(element2);
        return host != null && PsiUtilBase.isUnderPsiRoot(root, host);
    }

    @Nullable
    public static Language getLanguageInEditor(@NotNull Editor editor, @NotNull Project project2) {
        if (editor == null) {
            PsiUtilBase.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            PsiUtilBase.$$$reportNull$$$0(3);
        }
        return PsiUtilBase.getLanguageInEditor(editor.getCaretModel().getCurrentCaret(), project2);
    }

    @Nullable
    public static Language getLanguageInEditor(@NotNull Caret caret, @NotNull Project project2) {
        if (caret == null) {
            PsiUtilBase.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            PsiUtilBase.$$$reportNull$$$0(5);
        }
        Editor editor = caret.getEditor();
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        int caretOffset = caret.getOffset();
        int mostProbablyCorrectLanguageOffset = caretOffset == caret.getSelectionEnd() ? caret.getSelectionStart() : caretOffset;
        PsiElement elt = PsiUtilBase.getElementAtOffset(file2, mostProbablyCorrectLanguageOffset);
        Language lang2 = PsiUtilBase.findLanguageFromElement(elt);
        if (caret.hasSelection()) {
            lang2 = PsiUtilBase.evaluateLanguageInRange(caret.getSelectionStart(), caret.getSelectionEnd(), file2);
        }
        return PsiUtilBase.narrowLanguage(lang2, file2.getLanguage());
    }

    @Nullable
    public static PsiElement getElementAtCaret(@NotNull Editor editor) {
        Project project2;
        if (editor == null) {
            PsiUtilBase.$$$reportNull$$$0(6);
        }
        if ((project2 = editor.getProject()) == null) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument());
        return file2 == null ? null : file2.findElementAt(editor.getCaretModel().getOffset());
    }

    @Nullable
    public static PsiFile getPsiFileInEditor(@NotNull Editor editor, @NotNull Project project2) {
        if (editor == null) {
            PsiUtilBase.$$$reportNull$$$0(7);
        }
        if (project2 == null) {
            PsiUtilBase.$$$reportNull$$$0(8);
        }
        return PsiUtilBase.getPsiFileInEditor(editor.getCaretModel().getCurrentCaret(), project2);
    }

    @Nullable
    public static PsiFile getPsiFileInEditor(@NotNull Caret caret, @NotNull Project project2) {
        if (caret == null) {
            PsiUtilBase.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            PsiUtilBase.$$$reportNull$$$0(10);
        }
        Editor editor = caret.getEditor();
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        PsiUtilCore.ensureValid(file2);
        Language language2 = PsiUtilBase.getLanguageInEditor(caret, project2);
        if (language2 == file2.getLanguage()) {
            return file2;
        }
        int caretOffset = caret.getOffset();
        int mostProbablyCorrectLanguageOffset = caretOffset == caret.getSelectionEnd() ? caret.getSelectionStart() : caretOffset;
        return PsiUtilBase.getPsiFileAtOffset(file2, mostProbablyCorrectLanguageOffset);
    }

    public static PsiFile getPsiFileAtOffset(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            PsiUtilBase.$$$reportNull$$$0(11);
        }
        PsiElement elt = PsiUtilBase.getElementAtOffset(file2, offset);
        PsiUtilBase.ensureValid(elt);
        return elt.getContainingFile();
    }

    @Nullable
    public static Language reallyEvaluateLanguageInRange(int start2, int end, @NotNull PsiFile file2) {
        TextRange range2;
        int endOffset;
        if (file2 == null) {
            PsiUtilBase.$$$reportNull$$$0(12);
        }
        if (file2 instanceof PsiBinaryFile) {
            return file2.getLanguage();
        }
        Language lang2 = null;
        int curOffset = start2;
        do {
            PsiElement elt;
            if (!((elt = PsiUtilBase.getElementAtOffset(file2, curOffset)) instanceof PsiWhiteSpace)) {
                Language language2 = PsiUtilBase.findLanguageFromElement(elt);
                if (lang2 == null) {
                    lang2 = language2;
                } else if (lang2 != language2) {
                    return null;
                }
            }
            if ((range2 = elt.getTextRange()) != null) continue;
            LOG.error("Null range for element " + elt + " of " + elt.getClass() + " in file " + file2 + " at offset " + curOffset);
            return file2.getLanguage();
        } while ((curOffset = (endOffset = range2.getEndOffset()) <= curOffset ? curOffset + 1 : endOffset) < end);
        return PsiUtilBase.narrowLanguage(lang2, file2.getLanguage());
    }

    @NotNull
    private static Language evaluateLanguageInRange(int start2, int end, @NotNull PsiFile file2) {
        if (file2 == null) {
            PsiUtilBase.$$$reportNull$$$0(13);
        }
        PsiElement elt = PsiUtilBase.getElementAtOffset(file2, start2);
        TextRange selectionRange = new TextRange(start2, end);
        while (true) {
            if (elt instanceof PsiFile) {
                Language language2 = elt.getLanguage();
                if (language2 == null) {
                    PsiUtilBase.$$$reportNull$$$0(14);
                }
                return language2;
            }
            PsiElement parent = elt.getParent();
            TextRange range2 = elt.getTextRange();
            if (range2 == null) {
                LOG.error("Range is null for " + elt + "; " + elt.getClass());
                Language language3 = file2.getLanguage();
                if (language3 == null) {
                    PsiUtilBase.$$$reportNull$$$0(15);
                }
                return language3;
            }
            if (range2.contains(selectionRange) || parent == null) {
                Language language4 = elt.getLanguage();
                if (language4 == null) {
                    PsiUtilBase.$$$reportNull$$$0(16);
                }
                return language4;
            }
            elt = parent;
        }
    }

    @NotNull
    public static ASTNode getRoot(@NotNull ASTNode node) {
        if (node == null) {
            PsiUtilBase.$$$reportNull$$$0(17);
        }
        ASTNode child2 = node;
        while (true) {
            ASTNode parent;
            if ((parent = child2.getTreeParent()) == null) {
                ASTNode aSTNode = child2;
                if (aSTNode == null) {
                    PsiUtilBase.$$$reportNull$$$0(18);
                }
                return aSTNode;
            }
            child2 = parent;
        }
    }

    @Override
    @Deprecated
    @Nullable
    public Editor findEditorByPsiElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiUtilBase.$$$reportNull$$$0(19);
        }
        return PsiUtilBase.findEditor(element2);
    }

    @Deprecated
    @Nullable
    public static Editor findEditor(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiUtilBase.$$$reportNull$$$0(20);
        }
        return PsiEditorUtil.findEditor(element2);
    }

    public static boolean isSymLink(@NotNull PsiFileSystemItem element2) {
        VirtualFile virtualFile2;
        if (element2 == null) {
            PsiUtilBase.$$$reportNull$$$0(21);
        }
        return (virtualFile2 = element2.getVirtualFile()) != null && virtualFile2.is(VFileProperty.SYMLINK);
    }

    @Nullable
    public static VirtualFile asVirtualFile(@Nullable PsiElement element2) {
        if (element2 instanceof PsiFileSystemItem) {
            PsiFileSystemItem psiFileSystemItem = (PsiFileSystemItem)element2;
            return psiFileSystemItem.isValid() ? psiFileSystemItem.getVirtualFile() : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiUtilBase";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiUtilBase";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateLanguageInRange";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUnderPsiRoot";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageInEditor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementAtCaret";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileInEditor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileAtOffset";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reallyEvaluateLanguageInRange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "evaluateLanguageInRange";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRoot";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findEditorByPsiElement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findEditor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

