/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootsManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SameLogicalRootWeigher
extends ProximityWeigher {
    private static final NullableLazyKey<LogicalRoot, ProximityLocation> LOGICAL_ROOT_KEY = NullableLazyKey.create("logicalRoot", proximityLocation -> SameLogicalRootWeigher.findLogicalRoot(proximityLocation.getPosition()));

    @Override
    public Comparable weigh(@NotNull PsiElement element2, @NotNull ProximityLocation location2) {
        if (element2 == null) {
            SameLogicalRootWeigher.$$$reportNull$$$0(0);
        }
        if (location2 == null) {
            SameLogicalRootWeigher.$$$reportNull$$$0(1);
        }
        if (location2.getPosition() == null) {
            return null;
        }
        LogicalRoot contextRoot = LOGICAL_ROOT_KEY.getValue(location2);
        if (contextRoot == null) {
            return Boolean.valueOf(false);
        }
        return Boolean.valueOf(contextRoot.equals(SameLogicalRootWeigher.findLogicalRoot(element2)));
    }

    @Nullable
    private static LogicalRoot findLogicalRoot(PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        PsiFile psiFile = element2.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile file2 = psiFile.getOriginalFile().getVirtualFile();
        if (file2 == null) {
            return null;
        }
        return LogicalRootsManager.getLogicalRootsManager(element2.getProject()).findLogicalRoot(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/util/proximity/SameLogicalRootWeigher";
        objectArray[2] = "weigh";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

