/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.listeners.RefactoringListenerManager;
import com.intellij.refactoring.listeners.impl.RefactoringListenerManagerImpl;
import com.intellij.refactoring.listeners.impl.RefactoringTransaction;
import com.intellij.refactoring.suggested.SuggestedRefactoringProvider;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UnknownUsagesInUnloadedModules;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRefactoringProcessor
implements Runnable {
    private static final Logger LOG = Logger.getInstance(BaseRefactoringProcessor.class);
    private static boolean PREVIEW_IN_TESTS = true;
    protected final Project myProject;
    @NotNull
    protected final SearchScope myRefactoringScope;
    private RefactoringTransaction myTransaction;
    private boolean myIsPreviewUsages;
    protected Runnable myPrepareSuccessfulSwingThreadCallback;
    private UsageView myUsageView;

    protected BaseRefactoringProcessor(@NotNull Project project2) {
        if (project2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(0);
        }
        this(project2, null);
    }

    protected BaseRefactoringProcessor(@NotNull Project project2, @Nullable Runnable prepareSuccessfulCallback) {
        if (project2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(1);
        }
        this(project2, GlobalSearchScope.projectScope(project2), prepareSuccessfulCallback);
    }

    protected BaseRefactoringProcessor(@NotNull Project project2, @NotNull SearchScope refactoringScope, @Nullable Runnable prepareSuccessfulCallback) {
        if (project2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(2);
        }
        if (refactoringScope == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(3);
        }
        this.myProject = project2;
        this.myPrepareSuccessfulSwingThreadCallback = prepareSuccessfulCallback;
        this.myRefactoringScope = refactoringScope;
    }

    @NotNull
    protected abstract UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] var1);

    protected abstract UsageInfo @NotNull [] findUsages();

    protected void refreshElements(PsiElement @NotNull [] elements2) {
        if (elements2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(4);
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(5);
        }
        this.prepareSuccessful();
        return true;
    }

    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(6);
        }
        return this.myIsPreviewUsages;
    }

    protected boolean isPreviewUsages() {
        return this.myIsPreviewUsages;
    }

    private Set<UnloadedModuleDescription> computeUnloadedModulesFromUseScope(UsageViewDescriptor descriptor2) {
        if (ModuleManager.getInstance(this.myProject).getUnloadedModuleDescriptions().isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<UnloadedModuleDescription> unloadedModulesInUseScope = new LinkedHashSet<UnloadedModuleDescription>();
        for (PsiElement element2 : descriptor2.getElements()) {
            SearchScope useScope = element2.getUseScope();
            if (!(useScope instanceof GlobalSearchScope)) continue;
            unloadedModulesInUseScope.addAll(((GlobalSearchScope)useScope).getUnloadedModulesBelongingToScope());
        }
        return unloadedModulesInUseScope;
    }

    public void setPreviewUsages(boolean isPreviewUsages) {
        this.myIsPreviewUsages = isPreviewUsages;
    }

    public void setPrepareSuccessfulSwingThreadCallback(Runnable prepareSuccessfulSwingThreadCallback) {
        this.myPrepareSuccessfulSwingThreadCallback = prepareSuccessfulSwingThreadCallback;
    }

    protected RefactoringTransaction getTransaction() {
        return this.myTransaction;
    }

    protected abstract void performRefactoring(UsageInfo @NotNull [] var1);

    @NotNull
    protected abstract String getCommandName();

    protected void doRun() {
        boolean isPreview;
        if (!PsiDocumentManager.getInstance(this.myProject).commitAllDocumentsUnderProgress()) {
            return;
        }
        Ref<UsageInfo[]> refUsages = new Ref<UsageInfo[]>();
        Ref refErrorLanguage = new Ref();
        Ref refProcessCanceled = new Ref();
        Ref anyException = new Ref();
        DumbService.getInstance(this.myProject).completeJustSubmittedTasks();
        Runnable findUsagesRunnable = () -> {
            try {
                refUsages.set(ReadAction.compute(this::findUsages));
            }
            catch (UnknownReferenceTypeException e) {
                refErrorLanguage.set(e.getElementLanguage());
            }
            catch (ProcessCanceledException e) {
                refProcessCanceled.set(Boolean.TRUE);
            }
            catch (Throwable e) {
                anyException.set(Boolean.TRUE);
                LOG.error(e);
            }
        };
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(findUsagesRunnable, RefactoringBundle.message("progress.text"), true, this.myProject)) {
            return;
        }
        if (!refErrorLanguage.isNull()) {
            Messages.showErrorDialog(this.myProject, RefactoringBundle.message("unsupported.refs.found", ((Language)refErrorLanguage.get()).getDisplayName()), RefactoringBundle.message("error.title"));
            return;
        }
        if (DumbService.isDumb(this.myProject)) {
            DumbService.getInstance(this.myProject).showDumbModeNotification(RefactoringBundle.message("refactoring.dumb.mode.notification"));
            return;
        }
        if (!refProcessCanceled.isNull()) {
            Messages.showErrorDialog(this.myProject, RefactoringBundle.message("refactoring.index.corruption.notifiction"), RefactoringBundle.message("error.title"));
            return;
        }
        if (!anyException.isNull()) {
            return;
        }
        assert (!refUsages.isNull()) : "Null usages from processor " + this;
        if (!this.preprocessUsages(refUsages)) {
            return;
        }
        UsageInfo[] usages = refUsages.get();
        assert (usages != null);
        UsageViewDescriptor descriptor2 = this.createUsageViewDescriptor(usages);
        boolean bl = isPreview = this.isPreviewUsages(usages) || !this.computeUnloadedModulesFromUseScope(descriptor2).isEmpty();
        if (!isPreview) {
            boolean bl2 = isPreview = !this.ensureElementsWritable(usages, descriptor2) || UsageViewUtil.hasReadOnlyUsages(usages);
            if (isPreview) {
                StatusBarUtil.setStatusBarInfo(this.myProject, RefactoringBundle.message("readonly.occurences.found"));
            }
        }
        if (isPreview) {
            for (UsageInfo usage : usages) {
                LOG.assertTrue(usage != null, this.getClass());
            }
            this.previewRefactoring(usages);
        } else {
            this.execute(usages);
        }
    }

    public static <T extends Throwable> void runWithDisabledPreview(ThrowableRunnable<T> runnable2) throws T {
        PREVIEW_IN_TESTS = false;
        try {
            runnable2.run();
        }
        finally {
            PREVIEW_IN_TESTS = true;
        }
    }

    protected void previewRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(7);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (!PREVIEW_IN_TESTS) {
                throw new RuntimeException("Unexpected preview in tests: " + StringUtil.join(usages, UsageInfo::toString, ", "));
            }
            this.ensureElementsWritable(usages, this.createUsageViewDescriptor(usages));
            this.execute(usages);
            return;
        }
        UsageViewDescriptor viewDescriptor = this.createUsageViewDescriptor(usages);
        final PsiElement[] elements2 = viewDescriptor.getElements();
        final PsiElement2UsageTargetAdapter[] targets2 = PsiElement2UsageTargetAdapter.convert(elements2);
        Factory<UsageSearcher> factory = () -> new UsageInfoSearcherAdapter(){

            @Override
            public void generate(@NotNull Processor<? super Usage> processor2) {
                if (processor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    for (int i = 0; i < elements2.length; ++i) {
                        elements22[i] = targets2[i].getElement();
                    }
                    BaseRefactoringProcessor.this.refreshElements(elements2);
                });
                this.processUsages(processor2, BaseRefactoringProcessor.this.myProject);
            }

            @Override
            protected UsageInfo @NotNull [] findUsages() {
                UsageInfo[] usageInfoArray = BaseRefactoringProcessor.this.findUsages();
                if (usageInfoArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return usageInfoArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/refactoring/BaseRefactoringProcessor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/refactoring/BaseRefactoringProcessor$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findUsages";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "generate";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.showUsageView(viewDescriptor, factory, usages);
    }

    protected boolean skipNonCodeUsages() {
        return false;
    }

    private boolean ensureElementsWritable(UsageInfo @NotNull [] usages, @NotNull UsageViewDescriptor descriptor2) {
        if (descriptor2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(8);
        }
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(9);
        }
        THashSet elements2 = ContainerUtil.newIdentityTroveSet();
        for (UsageInfo usage : usages) {
            PsiElement element2;
            assert (usage != null) : "Found null element in usages array";
            if (this.skipNonCodeUsages() && usage.isNonCodeUsage() || (element2 = usage.getElement()) == null) continue;
            elements2.add(element2);
        }
        elements2.addAll(this.getElementsToWrite(descriptor2));
        return BaseRefactoringProcessor.ensureFilesWritable(this.myProject, elements2);
    }

    private static boolean ensureFilesWritable(@NotNull Project project2, @NotNull Collection<? extends PsiElement> elements2) {
        if (project2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(10);
        }
        if (elements2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(11);
        }
        PsiElement[] psiElements = PsiUtilCore.toPsiElementArray(elements2);
        return CommonRefactoringUtil.checkReadOnlyStatus(project2, psiElements);
    }

    protected void execute(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(12);
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            LinkedHashSet<UsageInfo> usageInfos = new LinkedHashSet<UsageInfo>(Arrays.asList(usages));
            this.doRefactoring(usageInfos);
            if (this.isGlobalUndoAction()) {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.myProject);
            }
            SuggestedRefactoringProvider.getInstance(this.myProject).reset();
        }, this.getCommandName(), null, this.getUndoConfirmationPolicy());
    }

    protected boolean isGlobalUndoAction() {
        return CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext()) == null;
    }

    @NotNull
    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        UndoConfirmationPolicy undoConfirmationPolicy = UndoConfirmationPolicy.DEFAULT;
        if (undoConfirmationPolicy == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(13);
        }
        return undoConfirmationPolicy;
    }

    @NotNull
    private static UsageViewPresentation createPresentation(@NotNull UsageViewDescriptor descriptor2, Usage @NotNull [] usages) {
        if (descriptor2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(14);
        }
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(15);
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabText(RefactoringBundle.message("usageView.tabText"));
        presentation.setTargetsNodeText(descriptor2.getProcessedElementsHeader());
        presentation.setShowReadOnlyStatusAsRed(true);
        presentation.setShowCancelButton(true);
        presentation.setUsagesString(RefactoringBundle.message("usageView.usagesText"));
        int codeUsageCount = 0;
        int nonCodeUsageCount = 0;
        int dynamicUsagesCount = 0;
        HashSet<PsiFile> codeFiles = new HashSet<PsiFile>();
        HashSet<PsiFile> nonCodeFiles = new HashSet<PsiFile>();
        HashSet<PsiFile> dynamicUsagesCodeFiles = new HashSet<PsiFile>();
        for (Usage usage : usages) {
            PsiElementUsage elementUsage;
            PsiElement element2;
            if (!(usage instanceof PsiElementUsage) || (element2 = (elementUsage = (PsiElementUsage)usage).getElement()) == null) continue;
            PsiFile containingFile = element2.getContainingFile();
            if (usage instanceof UsageInfo2UsageAdapter && ((UsageInfo2UsageAdapter)usage).getUsageInfo().isDynamicUsage()) {
                ++dynamicUsagesCount;
                dynamicUsagesCodeFiles.add(containingFile);
                continue;
            }
            if (elementUsage.isNonCodeUsage()) {
                ++nonCodeUsageCount;
                nonCodeFiles.add(containingFile);
                continue;
            }
            ++codeUsageCount;
            codeFiles.add(containingFile);
        }
        codeFiles.remove(null);
        nonCodeFiles.remove(null);
        dynamicUsagesCodeFiles.remove(null);
        String codeReferencesText = descriptor2.getCodeReferencesText(codeUsageCount, codeFiles.size());
        presentation.setCodeUsagesString(codeReferencesText);
        String commentReferencesText = descriptor2.getCommentReferencesText(nonCodeUsageCount, nonCodeFiles.size());
        if (commentReferencesText != null) {
            presentation.setNonCodeUsagesString(commentReferencesText);
        }
        presentation.setDynamicUsagesString("Dynamic " + StringUtil.decapitalize(descriptor2.getCodeReferencesText(dynamicUsagesCount, dynamicUsagesCodeFiles.size())));
        String generatedCodeString = codeReferencesText.contains("in code") ? StringUtil.replace(codeReferencesText, "in code", "in generated code") : codeReferencesText + " in generated code";
        presentation.setUsagesInGeneratedCodeString(generatedCodeString);
        UsageViewPresentation usageViewPresentation = presentation;
        if (usageViewPresentation == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(16);
        }
        return usageViewPresentation;
    }

    public static boolean processConflicts(@NotNull Project project2, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (project2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(17);
        }
        if (conflicts == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(18);
        }
        if (conflicts.isEmpty()) {
            return true;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (ConflictsInTestsException.isTestIgnore()) {
                return true;
            }
            throw new ConflictsInTestsException(conflicts.values());
        }
        ConflictsDialog conflictsDialog = new ConflictsDialog(project2, conflicts);
        return conflictsDialog.showAndGet();
    }

    private void showUsageView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull Factory<UsageSearcher> factory, UsageInfo @NotNull [] usageInfos) {
        if (viewDescriptor == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(19);
        }
        if (factory == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(20);
        }
        if (usageInfos == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(21);
        }
        UsageViewManager viewManager = UsageViewManager.getInstance(this.myProject);
        PsiElement[] initialElements = viewDescriptor.getElements();
        UsageTarget[] targets2 = PsiElement2UsageTargetAdapter.convert(initialElements);
        Ref convertUsagesRef = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> convertUsagesRef.set(UsageInfo2UsageAdapter.convert(usageInfos))), RefactoringBundle.message("refactoring.preprocess.usages.progress"), true, this.myProject)) {
            return;
        }
        if (convertUsagesRef.isNull()) {
            return;
        }
        Usage[] usages = (Usage[])convertUsagesRef.get();
        UsageViewPresentation presentation = BaseRefactoringProcessor.createPresentation(viewDescriptor, usages);
        if (this.myUsageView == null) {
            this.myUsageView = viewManager.showUsages(targets2, usages, presentation, factory);
            this.customizeUsagesView(viewDescriptor, this.myUsageView);
        } else {
            this.myUsageView.removeUsagesBulk(this.myUsageView.getUsages());
            ((UsageViewImpl)this.myUsageView).appendUsagesInBulk(Arrays.asList(usages));
        }
        Set<UnloadedModuleDescription> unloadedModules = this.computeUnloadedModulesFromUseScope(viewDescriptor);
        if (!unloadedModules.isEmpty()) {
            this.myUsageView.appendUsage(new UnknownUsagesInUnloadedModules(unloadedModules));
        }
    }

    protected void customizeUsagesView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull UsageView usageView) {
        if (viewDescriptor == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(22);
        }
        if (usageView == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(23);
        }
        Runnable refactoringRunnable = () -> {
            Set<UsageInfo> usagesToRefactor = UsageViewUtil.getNotExcludedUsageInfos(usageView);
            UsageInfo[] infos = usagesToRefactor.toArray(UsageInfo.EMPTY_ARRAY);
            if (this.ensureElementsWritable(infos, viewDescriptor)) {
                this.execute(infos);
            }
        };
        String canNotMakeString = RefactoringBundle.message("usageView.need.reRun");
        this.addDoRefactoringAction(usageView, refactoringRunnable, canNotMakeString);
        usageView.setRerunAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseRefactoringProcessor.this.doRun();
            }
        });
    }

    private void addDoRefactoringAction(@NotNull UsageView usageView, @NotNull Runnable refactoringRunnable, @NotNull String canNotMakeString) {
        if (usageView == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(24);
        }
        if (refactoringRunnable == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(25);
        }
        if (canNotMakeString == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(26);
        }
        usageView.addPerformOperationAction(refactoringRunnable, this.getCommandName(), canNotMakeString, RefactoringBundle.message("usageView.doAction"), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefactoring(@NotNull Collection<UsageInfo> usageInfoSet) {
        if (usageInfoSet == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(27);
        }
        Iterator<UsageInfo> iterator2 = usageInfoSet.iterator();
        while (iterator2.hasNext()) {
            UsageInfo usageInfo = iterator2.next();
            PsiElement element2 = usageInfo.getElement();
            if (element2 != null && this.isToBeChanged(usageInfo)) continue;
            iterator2.remove();
        }
        String commandName = this.getCommandName();
        LocalHistoryAction action2 = LocalHistory.getInstance().startAction(commandName);
        UsageInfo[] writableUsageInfos = usageInfoSet.toArray(UsageInfo.EMPTY_ARRAY);
        try {
            PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
            RefactoringListenerManagerImpl listenerManager = (RefactoringListenerManagerImpl)RefactoringListenerManager.getInstance(this.myProject);
            this.myTransaction = listenerManager.startTransaction();
            LinkedHashMap preparedData = new LinkedHashMap();
            Runnable prepareHelpersRunnable = () -> {
                for (RefactoringHelper helper : RefactoringHelper.EP_NAME.getExtensionList()) {
                    Object operation = ReadAction.compute(() -> helper.prepareOperation(writableUsageInfos));
                    preparedData.put(helper, operation);
                }
            };
            ProgressManager.getInstance().runProcessWithProgressSynchronously(prepareHelpersRunnable, RefactoringBundle.message("refactoring.prepare.progress"), false, this.myProject);
            Runnable performRefactoringRunnable = () -> {
                String refactoringId = this.getRefactoringId();
                if (refactoringId != null) {
                    RefactoringEventData data2 = this.getBeforeData();
                    if (data2 != null) {
                        data2.addUsages(usageInfoSet);
                    }
                    this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC).refactoringStarted(refactoringId, data2);
                }
                try {
                    if (refactoringId != null) {
                        UndoRefactoringAction action1 = new UndoRefactoringAction(this.myProject, refactoringId);
                        UndoManager.getInstance(this.myProject).undoableActionPerformed(action1);
                    }
                    this.performRefactoring(writableUsageInfos);
                }
                finally {
                    if (refactoringId != null) {
                        this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC).refactoringDone(refactoringId, this.getAfterData(writableUsageInfos));
                    }
                }
            };
            ApplicationEx app = ApplicationManagerEx.getApplicationEx();
            if (Registry.is("run.refactorings.under.progress")) {
                app.runWriteActionWithNonCancellableProgressInDispatchThread(commandName, this.myProject, null, indicator -> performRefactoringRunnable.run());
            } else {
                app.runWriteAction(performRefactoringRunnable);
            }
            DumbService.getInstance(this.myProject).completeJustSubmittedTasks();
            for (Map.Entry e : preparedData.entrySet()) {
                ((RefactoringHelper)e.getKey()).performOperation(this.myProject, e.getValue());
            }
            this.myTransaction.commit();
            if (Registry.is("run.refactorings.under.progress")) {
                app.runWriteActionWithNonCancellableProgressInDispatchThread(commandName, this.myProject, null, indicator -> this.performPsiSpoilingRefactoring());
            } else {
                app.runWriteAction(this::performPsiSpoilingRefactoring);
            }
        }
        finally {
            action2.finish();
        }
        int count = writableUsageInfos.length;
        if (count > 0) {
            StatusBarUtil.setStatusBarInfo(this.myProject, RefactoringBundle.message("statusBar.refactoring.result", count));
        } else if (!this.isPreviewUsages(writableUsageInfos)) {
            StatusBarUtil.setStatusBarInfo(this.myProject, RefactoringBundle.message("statusBar.noUsages"));
        }
    }

    protected boolean isToBeChanged(@NotNull UsageInfo usageInfo) {
        if (usageInfo == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(28);
        }
        return usageInfo.isWritable();
    }

    protected void performPsiSpoilingRefactoring() {
    }

    protected void prepareSuccessful() {
        if (this.myPrepareSuccessfulSwingThreadCallback != null) {
            try {
                GuiUtils.runOrInvokeAndWait(this.myPrepareSuccessfulSwingThreadCallback);
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOG.error(e);
            }
        }
    }

    @Override
    public final void run() {
        Runnable runnable2 = this::doRun;
        if (this.shouldDisableAccessChecks()) {
            runnable2 = () -> NonProjectFileWritingAccessProvider.disableChecksDuring(this::doRun);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsWriteThread();
            runnable2.run();
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            LOG.error("Refactorings should not be started inside write action\n because they start progress inside and any read action from the progress task would cause the deadlock", new Exception());
            DumbService.getInstance(this.myProject).smartInvokeLater(runnable2);
        } else {
            runnable2.run();
        }
    }

    protected boolean shouldDisableAccessChecks() {
        return false;
    }

    @Deprecated
    protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts) {
        if (conflicts == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(29);
        }
        return this.showConflicts(conflicts, null);
    }

    protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo @Nullable [] usages) {
        if (conflicts == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(30);
        }
        if (!conflicts.isEmpty() && ApplicationManager.getApplication().isUnitTestMode()) {
            if (!ConflictsInTestsException.isTestIgnore()) {
                throw new ConflictsInTestsException(conflicts.values());
            }
            return true;
        }
        if (this.myPrepareSuccessfulSwingThreadCallback != null && !conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog;
            String refactoringId = this.getRefactoringId();
            if (refactoringId != null) {
                RefactoringEventData conflictUsages = new RefactoringEventData();
                conflictUsages.putUserData(RefactoringEventData.CONFLICTS_KEY, conflicts.values());
                this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC).conflictsDetected(refactoringId, conflictUsages);
            }
            if (!(conflictsDialog = this.prepareConflictsDialog(conflicts, usages)).showAndGet()) {
                if (conflictsDialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        this.prepareSuccessful();
        return true;
    }

    @NotNull
    protected ConflictsDialog prepareConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo @Nullable [] usages) {
        if (conflicts == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(31);
        }
        ConflictsDialog conflictsDialog = this.createConflictsDialog(conflicts, usages);
        conflictsDialog.setCommandName(this.getCommandName());
        ConflictsDialog conflictsDialog2 = conflictsDialog;
        if (conflictsDialog2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(32);
        }
        return conflictsDialog2;
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        return null;
    }

    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(33);
        }
        return null;
    }

    @NonNls
    @Nullable
    protected String getRefactoringId() {
        return null;
    }

    @NotNull
    protected ConflictsDialog createConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo @Nullable [] usages) {
        if (conflicts == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(34);
        }
        return new ConflictsDialog(this.myProject, conflicts, usages == null ? null : () -> this.execute(usages), false, true);
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor2) {
        if (descriptor2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(35);
        }
        List<PsiElement> list2 = Arrays.asList(descriptor2.getElements());
        if (list2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(36);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 16: 
            case 32: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 16: 
            case 32: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoringScope";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 8: 
            case 14: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 13: 
            case 16: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/BaseRefactoringProcessor";
                break;
            }
            case 18: 
            case 29: 
            case 30: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewDescriptor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoringRunnable";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canNotMakeString";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfoSet";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/BaseRefactoringProcessor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoConfirmationPolicy";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareConflictsDialog";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "previewRefactoring";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "ensureElementsWritable";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesWritable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 13: 
            case 16: 
            case 32: 
            case 36: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processConflicts";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showUsageView";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "customizeUsagesView";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addDoRefactoringAction";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isToBeChanged";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "showConflicts";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "prepareConflictsDialog";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createConflictsDialog";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 16: 
            case 32: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UndoRefactoringAction
    extends BasicUndoableAction {
        private final Project myProject;
        private final String myRefactoringId;

        UndoRefactoringAction(@NotNull Project project2, @NotNull String refactoringId) {
            if (project2 == null) {
                UndoRefactoringAction.$$$reportNull$$$0(0);
            }
            if (refactoringId == null) {
                UndoRefactoringAction.$$$reportNull$$$0(1);
            }
            this.myProject = project2;
            this.myRefactoringId = refactoringId;
        }

        @Override
        public void undo() {
            this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC).undoRefactoring(this.myRefactoringId);
        }

        @Override
        public void redo() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "refactoringId";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/BaseRefactoringProcessor$UndoRefactoringAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UnknownReferenceTypeException
    extends RuntimeException {
        private final Language myElementLanguage;

        public UnknownReferenceTypeException(@NotNull Language elementLanguage) {
            if (elementLanguage == null) {
                UnknownReferenceTypeException.$$$reportNull$$$0(0);
            }
            this.myElementLanguage = elementLanguage;
        }

        @NotNull
        Language getElementLanguage() {
            Language language2 = this.myElementLanguage;
            if (language2 == null) {
                UnknownReferenceTypeException.$$$reportNull$$$0(1);
            }
            return language2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementLanguage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/BaseRefactoringProcessor$UnknownReferenceTypeException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/BaseRefactoringProcessor$UnknownReferenceTypeException";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ConflictsInTestsException
    extends RuntimeException {
        private final Collection<? extends String> messages;
        private static boolean myTestIgnore;

        public ConflictsInTestsException(@NotNull Collection<? extends String> messages) {
            if (messages == null) {
                ConflictsInTestsException.$$$reportNull$$$0(0);
            }
            this.messages = messages;
        }

        public static boolean isTestIgnore() {
            return myTestIgnore;
        }

        public static <T extends Throwable> void withIgnoredConflicts(@NotNull ThrowableRunnable<T> r) throws T {
            if (r == null) {
                ConflictsInTestsException.$$$reportNull$$$0(1);
            }
            try {
                myTestIgnore = true;
                r.run();
            }
            finally {
                myTestIgnore = false;
            }
        }

        @NotNull
        public Collection<String> getMessages() {
            ArrayList<String> result2 = new ArrayList<String>(this.messages);
            for (int i = 0; i < this.messages.size(); ++i) {
                result2.set(i, ((String)result2.get(i)).replaceAll("<[^>]+>", ""));
            }
            ArrayList<String> arrayList = result2;
            if (arrayList == null) {
                ConflictsInTestsException.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @Override
        public String getMessage() {
            ArrayList<String> result2 = new ArrayList<String>(this.messages);
            Collections.sort(result2);
            return StringUtil.join(result2, "\n");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messages";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/BaseRefactoringProcessor$ConflictsInTestsException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/BaseRefactoringProcessor$ConflictsInTestsException";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "withIgnoredConflicts";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

