/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.CodeFragmentTableCellEditorBase;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.DelegationPanel;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.JBListTable;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeSignatureDialogBase<ParamInfo extends ParameterInfo, Method extends PsiElement, Visibility, Descriptor extends MethodDescriptor<ParamInfo, Visibility>, ParameterTableModelItem extends ParameterTableModelItemBase<ParamInfo>, ParameterTableModel extends ParameterTableModelBase<ParamInfo, ParameterTableModelItem>>
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance(ChangeSignatureDialogBase.class);
    protected static final String EXIT_SILENTLY = "";
    protected final Descriptor myMethod;
    private final boolean myAllowDelegation;
    protected JPanel myNamePanel;
    protected EditorTextField myNameField;
    protected EditorTextField myReturnTypeField;
    protected JBListTable myParametersList;
    protected TableView<ParameterTableModelItem> myParametersTable;
    protected final ParameterTableModel myParametersTableModel;
    protected final UpdateSignatureListener mySignatureUpdater;
    private MethodSignatureComponent mySignatureArea;
    private final Alarm myUpdateSignatureAlarm;
    protected VisibilityPanelBase<Visibility> myVisibilityPanel;
    @Nullable
    protected PsiCodeFragment myReturnTypeCodeFragment;
    private DelegationPanel myDelegationPanel;
    protected AnActionButton myPropagateParamChangesButton;
    protected Set<Method> myMethodsToPropagateParameters;
    private boolean myDisposed;
    private Tree myParameterPropagationTreeToReuse;
    protected final PsiElement myDefaultValueContext;

    protected abstract LanguageFileType getFileType();

    @NotNull
    protected abstract ParameterTableModel createParametersInfoModel(@NotNull Descriptor var1);

    protected abstract BaseRefactoringProcessor createRefactoringProcessor();

    protected abstract PsiCodeFragment createReturnTypeCodeFragment();

    @Nullable
    protected abstract CallerChooserBase<Method> createCallerChooser(String var1, Tree var2, Consumer<Set<Method>> var3);

    @Nullable
    protected abstract String validateAndCommitData();

    protected abstract String calculateSignature();

    protected abstract VisibilityPanelBase<Visibility> createVisibilityControl();

    public ChangeSignatureDialogBase(@NotNull Project project2, @NotNull Descriptor method2, boolean allowDelegation, PsiElement defaultValueContext) {
        if (project2 == null) {
            ChangeSignatureDialogBase.$$$reportNull$$$0(0);
        }
        if (method2 == null) {
            ChangeSignatureDialogBase.$$$reportNull$$$0(1);
        }
        super(project2, true);
        this.mySignatureUpdater = new UpdateSignatureListener();
        this.myUpdateSignatureAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myMethodsToPropagateParameters = null;
        this.myMethod = method2;
        this.myDefaultValueContext = defaultValueContext;
        this.myParametersTableModel = this.createParametersInfoModel(method2);
        this.myAllowDelegation = allowDelegation;
        this.setParameterInfos(method2.getParameters());
        this.setTitle(ChangeSignatureHandler.REFACTORING_NAME);
        this.init();
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        this.doUpdateSignature();
        Disposer.register(this.myDisposable, new Disposable(){

            @Override
            public void dispose() {
                ChangeSignatureDialogBase.this.myUpdateSignatureAlarm.cancelAllRequests();
                ChangeSignatureDialogBase.this.myDisposed = true;
            }
        });
    }

    public void setParameterInfos(List<? extends ParamInfo> parameterInfos) {
        ((ParameterTableModelBase)this.myParametersTableModel).setParameterInfos(parameterInfos);
        this.updateSignature();
    }

    protected String getMethodName() {
        if (this.myNameField != null) {
            return this.myNameField.getText().trim();
        }
        return this.myMethod.getName();
    }

    @Nullable
    protected Visibility getVisibility() {
        if (this.myVisibilityPanel != null) {
            return this.myVisibilityPanel.getVisibility();
        }
        return (Visibility)this.myMethod.getVisibility();
    }

    public List<ParamInfo> getParameters() {
        ArrayList result2 = new ArrayList(((ListTableModel)this.myParametersTableModel).getRowCount());
        for (ParameterTableModelItemBase item : ((ListTableModel)this.myParametersTableModel).getItems()) {
            result2.add(item.parameter);
        }
        return result2;
    }

    public boolean isGenerateDelegate() {
        return this.myAllowDelegation && this.myDelegationPanel.isGenerateDelegate();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        JBTable table = this.getTableComponent();
        if (table != null && table.getRowCount() > 0) {
            if (table.getColumnModel().getSelectedColumnCount() == 0) {
                int selectedIdx = this.getSelectedIdx();
                table.getSelectionModel().setSelectionInterval(selectedIdx, selectedIdx);
                table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
            }
            return table;
        }
        if (UIUtil.isFocusable(this.myNameField)) {
            return this.myNameField;
        }
        if (UIUtil.isFocusable(this.myReturnTypeField)) {
            return this.myReturnTypeField;
        }
        return super.getPreferredFocusedComponent();
    }

    protected int getSelectedIdx() {
        return 0;
    }

    protected JBTable getTableComponent() {
        return this.myParametersList == null ? this.myParametersTable : this.myParametersList.getTable();
    }

    public boolean placeReturnTypeBeforeName() {
        return true;
    }

    @Override
    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.myNamePanel = new JPanel(new BorderLayout(0, 2));
        this.myNameField = new EditorTextField(this.myMethod.getName());
        JLabel nameLabel = new JLabel(RefactoringBundle.message("changeSignature.name.prompt"));
        nameLabel.setLabelFor(this.myNameField);
        this.myNameField.setEnabled(this.myMethod.canChangeName());
        if (this.myMethod.canChangeName()) {
            this.myNameField.addDocumentListener(this.mySignatureUpdater);
            this.myNameField.setPreferredWidth(200);
        }
        this.myNamePanel.add((Component)nameLabel, "North");
        this.myNamePanel.add((Component)this.myNameField, "South");
        JPanel visibilityPanel = this.createVisibilityPanel();
        if (this.myMethod.canChangeVisibility() && this.myVisibilityPanel instanceof ComboBoxVisibilityPanel) {
            ((ComboBoxVisibilityPanel)this.myVisibilityPanel).registerUpDownActionsFor(this.myNameField);
            visibilityPanel.setBorder(new EmptyBorder(0, 0, 0, 8));
            panel2.add((Component)visibilityPanel, gbc);
            ++gbc.gridx;
        }
        gbc.weightx = 1.0;
        if (this.myMethod.canChangeReturnType() != MethodDescriptor.ReadWriteOption.None) {
            JPanel typePanel = new JPanel(new BorderLayout(0, 2));
            typePanel.setBorder(new EmptyBorder(0, 0, 0, 8));
            JLabel typeLabel = new JLabel(RefactoringBundle.message("changeSignature.return.type.prompt"));
            this.myReturnTypeCodeFragment = this.createReturnTypeCodeFragment();
            Document document = PsiDocumentManager.getInstance(this.myProject).getDocument(this.myReturnTypeCodeFragment);
            this.myReturnTypeField = this.createReturnTypeTextField(document);
            ((ComboBoxVisibilityPanel)this.myVisibilityPanel).registerUpDownActionsFor(this.myReturnTypeField);
            typeLabel.setLabelFor(this.myReturnTypeField);
            if (this.myMethod.canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite) {
                this.myReturnTypeField.setPreferredWidth(200);
                this.myReturnTypeField.addDocumentListener(this.mySignatureUpdater);
            } else {
                this.myReturnTypeField.setEnabled(false);
            }
            typePanel.add((Component)typeLabel, "North");
            typePanel.add((Component)this.myReturnTypeField, "South");
            if (this.placeReturnTypeBeforeName()) {
                panel2.add((Component)typePanel, gbc);
                ++gbc.gridx;
                panel2.add((Component)this.myNamePanel, gbc);
            } else {
                panel2.add((Component)this.myNamePanel, gbc);
                ++gbc.gridx;
                panel2.add((Component)typePanel, gbc);
            }
        } else {
            panel2.add((Component)this.myNamePanel, gbc);
        }
        return panel2;
    }

    protected EditorTextField createReturnTypeTextField(Document document) {
        return new EditorTextField(document, this.myProject, (FileType)this.getFileType());
    }

    private DelegationPanel createDelegationPanel() {
        return new DelegationPanel(){

            @Override
            protected void stateModified() {
                ((AbstractTableModel)ChangeSignatureDialogBase.this.myParametersTableModel).fireTableDataChanged();
                ChangeSignatureDialogBase.this.myParametersTable.repaint();
            }
        };
    }

    @Override
    protected JComponent createCenterPanel() {
        JPanel main2;
        JPanel panel2 = new JPanel(new BorderLayout());
        JComponent optionsPanel = this.createOptionsPanel();
        JPanel subPanel = new JPanel(new BorderLayout());
        List<Pair<String, JPanel>> panels = this.createAdditionalPanels();
        if (this.myMethod.canChangeParameters()) {
            JPanel parametersPanel = this.createParametersPanel(!panels.isEmpty());
            if (!panels.isEmpty()) {
                parametersPanel.setBorder(JBUI.Borders.empty());
            }
            subPanel.add((Component)parametersPanel, "Center");
        }
        if (this.myMethod.canChangeVisibility() && !(this.myVisibilityPanel instanceof ComboBoxVisibilityPanel)) {
            subPanel.add(this.myVisibilityPanel, this.myMethod.canChangeParameters() ? "East" : "Center");
        }
        panel2.add((Component)subPanel, "Center");
        if (panels.isEmpty()) {
            main2 = panel2;
        } else {
            TabbedPaneWrapper tabbedPane = new TabbedPaneWrapper(this.getDisposable());
            tabbedPane.addTab(RefactoringBundle.message("parameters.border.title"), panel2);
            for (Pair<String, JPanel> extraPanel : panels) {
                tabbedPane.addTab((String)extraPanel.first, (JComponent)extraPanel.second);
            }
            main2 = new JPanel(new BorderLayout());
            JComponent tabs = tabbedPane.getComponent();
            main2.add((Component)tabs, "Center");
            for (JComponent c : UIUtil.findComponentsOfType(tabs, JComponent.class)) {
                c.setFocusCycleRoot(false);
                c.setFocusTraversalPolicy(null);
            }
        }
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.add((Component)optionsPanel, "North");
        bottom.add((Component)this.createSignaturePanel(), "South");
        main2.add((Component)bottom, "South");
        main2.setBorder(JBUI.Borders.emptyTop(5));
        return main2;
    }

    protected JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        if (this.myAllowDelegation) {
            this.myDelegationPanel = this.createDelegationPanel();
            panel2.add((Component)this.myDelegationPanel, "West");
        }
        this.myPropagateParamChangesButton = new AnActionButton(RefactoringBundle.message("changeSignature.propagate.parameters.title"), null, AllIcons.Hierarchy.Supertypes){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                Ref chooser = new Ref();
                Consumer callback2 = callers -> {
                    ChangeSignatureDialogBase.this.myMethodsToPropagateParameters = callers;
                    ChangeSignatureDialogBase.this.myParameterPropagationTreeToReuse = ((CallerChooserBase)chooser.get()).getTree();
                };
                try {
                    String message = RefactoringBundle.message("changeSignature.parameter.caller.chooser");
                    chooser.set(ChangeSignatureDialogBase.this.createCallerChooser(message, ChangeSignatureDialogBase.this.myParameterPropagationTreeToReuse, callback2));
                }
                catch (ProcessCanceledException ex) {
                    return;
                }
                ((CallerChooserBase)chooser.get()).show();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/changeSignature/ChangeSignatureDialogBase$3", "actionPerformed"));
            }
        };
        JPanel result2 = new JPanel(new VerticalFlowLayout(0));
        result2.add(panel2);
        return result2;
    }

    protected JPanel createVisibilityPanel() {
        this.myVisibilityPanel = this.createVisibilityControl();
        this.myVisibilityPanel.setVisibility(this.myMethod.getVisibility());
        this.myVisibilityPanel.addListener(this.mySignatureUpdater);
        return this.myVisibilityPanel;
    }

    @NotNull
    protected List<Pair<String, JPanel>> createAdditionalPanels() {
        List<Pair<String, JPanel>> list2 = Collections.emptyList();
        if (list2 == null) {
            ChangeSignatureDialogBase.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    protected String getDimensionServiceKey() {
        return "refactoring.ChangeSignatureDialog";
    }

    protected boolean isListTableViewSupported() {
        return false;
    }

    protected JPanel createParametersPanel(boolean hasTabsInDialog) {
        this.myParametersTable = new TableView<ParameterTableModelItem>((ListTableModel)this.myParametersTableModel){

            @Override
            public void removeEditor() {
                this.clearEditorListeners();
                super.removeEditor();
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                super.editingStopped(e);
                this.repaint();
            }

            private void clearEditorListeners() {
                TableCellEditor editor = this.getCellEditor();
                if (editor instanceof StringTableCellEditor) {
                    StringTableCellEditor ed = (StringTableCellEditor)editor;
                    ed.clearListeners();
                } else if (editor instanceof CodeFragmentTableCellEditorBase) {
                    ((CodeFragmentTableCellEditorBase)editor).clearListeners();
                }
            }

            @Override
            public Component prepareEditor(TableCellEditor editor, final int row, final int column) {
                DocumentListener listener2 = new DocumentListener(){

                    @Override
                    public void documentChanged(@NotNull DocumentEvent e) {
                        TableCellEditor ed;
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((ed = ChangeSignatureDialogBase.this.myParametersTable.getCellEditor()) != null) {
                            Object editorValue = ed.getCellEditorValue();
                            ((ParameterTableModelBase)ChangeSignatureDialogBase.this.myParametersTableModel).setValueAtWithoutUpdate(editorValue, row, column);
                            ChangeSignatureDialogBase.this.updateSignature();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/changeSignature/ChangeSignatureDialogBase$4$1", "documentChanged"));
                    }
                };
                if (editor instanceof StringTableCellEditor) {
                    StringTableCellEditor ed = (StringTableCellEditor)editor;
                    ed.addDocumentListener(listener2);
                } else if (editor instanceof CodeFragmentTableCellEditorBase) {
                    ((CodeFragmentTableCellEditorBase)editor).addDocumentListener(listener2);
                }
                return super.prepareEditor(editor, row, column);
            }
        };
        this.myParametersTable.setCellSelectionEnabled(true);
        this.myParametersTable.getSelectionModel().setSelectionMode(0);
        this.myParametersTable.getSelectionModel().setSelectionInterval(0, 0);
        this.myParametersTable.setSurrendersFocusOnKeystroke(true);
        this.myPropagateParamChangesButton.setShortcut(CustomShortcutSet.fromString("alt G"));
        if (this.isListTableViewSupported()) {
            this.myParametersList = this.createParametersListTable();
            JPanel buttonsPanel = ToolbarDecorator.createDecorator(this.myParametersList.getTable()).addExtraAction(this.myPropagateParamChangesButton).createPanel();
            this.myParametersList.getTable().getModel().addTableModelListener(this.mySignatureUpdater);
            return buttonsPanel;
        }
        JPanel buttonsPanel = ToolbarDecorator.createDecorator(this.getTableComponent()).addExtraAction(this.myPropagateParamChangesButton).createPanel();
        this.myPropagateParamChangesButton.setEnabled(false);
        this.myPropagateParamChangesButton.setVisible(false);
        this.myParametersTable.setStriped(true);
        ((AbstractTableModel)this.myParametersTableModel).addTableModelListener(this.mySignatureUpdater);
        this.customizeParametersTable(this.myParametersTable);
        return buttonsPanel;
    }

    protected ParametersListTable createParametersListTable() {
        return new ParametersListTable(){

            @Override
            protected JBTableRowRenderer getRowRenderer(int row) {
                return new JBTableRowRenderer(){

                    @Override
                    public JComponent getRowRendererComponent(JTable table, int row, boolean selected2, boolean focused) {
                        JComponent presentation = ChangeSignatureDialogBase.this.getRowPresentation(this.getRowItem(row), selected2, focused);
                        LOG.assertTrue(presentation != null);
                        return presentation;
                    }
                };
            }

            @Override
            @NotNull
            protected JBTableRowEditor getRowEditor(ParameterTableModelItemBase<ParamInfo> item) {
                JBTableRowEditor editor = ChangeSignatureDialogBase.this.getTableEditor(this.getTable(), item);
                LOG.assertTrue(editor != null);
                JBTableRowEditor jBTableRowEditor = editor;
                if (jBTableRowEditor == null) {
                    5.$$$reportNull$$$0(0);
                }
                return jBTableRowEditor;
            }

            @Override
            protected boolean isRowEmpty(int row) {
                return ChangeSignatureDialogBase.this.isEmptyRow(this.getRowItem(row));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/ChangeSignatureDialogBase$5", "getRowEditor"));
            }
        };
    }

    @Deprecated
    @Nullable
    protected JBTableRowEditor getTableEditor(JTable table, ParameterTableModelItemBase<ParamInfo> item) {
        return null;
    }

    @Deprecated
    protected boolean isEmptyRow(ParameterTableModelItemBase<ParamInfo> row) {
        return false;
    }

    @Deprecated
    @Nullable
    protected JComponent getRowPresentation(ParameterTableModelItemBase<ParamInfo> item, boolean selected2, boolean focused) {
        return null;
    }

    protected void customizeParametersTable(TableView<ParameterTableModelItem> table) {
    }

    private JComponent createSignaturePanel() {
        this.mySignatureArea = this.createSignaturePreviewComponent();
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)SeparatorFactory.createSeparator(RefactoringBundle.message("signature.preview.border.title"), null), "North");
        panel2.add((Component)this.mySignatureArea, "Center");
        this.mySignatureArea.setPreferredSize(new Dimension(-1, 130));
        this.mySignatureArea.setMinimumSize(new Dimension(-1, 130));
        this.mySignatureArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Component c;
                Container root = ChangeSignatureDialogBase.findTraversalRoot(ChangeSignatureDialogBase.this.getContentPane());
                if (root != null && (c = root.getFocusTraversalPolicy().getComponentAfter(root, ChangeSignatureDialogBase.this.mySignatureArea)) != null) {
                    IdeFocusManager.findInstance().requestFocus(c, true);
                }
            }
        });
        this.updateSignature();
        return panel2;
    }

    private static Container findTraversalRoot(Container container2) {
        Container root;
        Container current2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getCurrentFocusCycleRoot();
        if (current2 == container2) {
            root = container2;
        } else {
            root = container2.getFocusCycleRootAncestor();
            if (root == null) {
                root = container2;
            }
        }
        if (root != current2) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(root);
        }
        return root;
    }

    protected MethodSignatureComponent createSignaturePreviewComponent() {
        return new MethodSignatureComponent(this.calculateSignature(), this.getProject(), (FileType)this.getFileType());
    }

    protected void updateSignature() {
        if (this.mySignatureArea == null || this.myPropagateParamChangesButton == null) {
            return;
        }
        Runnable updateRunnable = () -> {
            if (this.myDisposed) {
                return;
            }
            this.myUpdateSignatureAlarm.cancelAllRequests();
            this.myUpdateSignatureAlarm.addRequest(() -> PsiDocumentManager.getInstance(this.myProject).performLaterWhenAllCommitted(() -> this.updateSignatureAlarmFired()), 100, ModalityState.stateForComponent(this.mySignatureArea));
        };
        SwingUtilities.invokeLater(updateRunnable);
    }

    protected void updateSignatureAlarmFired() {
        this.doUpdateSignature();
        this.updatePropagateButtons();
    }

    private void doUpdateSignature() {
        LOG.assertTrue(!PsiDocumentManager.getInstance(this.myProject).hasUncommitedDocuments());
        this.mySignatureArea.setSignature(this.calculateSignature());
    }

    protected void updatePropagateButtons() {
        if (this.myPropagateParamChangesButton != null) {
            this.myPropagateParamChangesButton.setEnabled(!this.isGenerateDelegate() && this.mayPropagateParameters());
        }
    }

    protected boolean mayPropagateParameters() {
        List<ParamInfo> infos = this.getParameters();
        if (infos.size() <= this.myMethod.getParametersCount()) {
            return false;
        }
        for (int i = 0; i < this.myMethod.getParametersCount(); ++i) {
            if (((ParameterInfo)infos.get(i)).getOldIndex() == i) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doAction() {
        String message;
        if (this.myParametersTable != null) {
            TableUtil.stopEditing(this.myParametersTable);
        }
        if ((message = this.validateAndCommitData()) != null) {
            if (message != EXIT_SILENTLY) {
                CommonRefactoringUtil.showErrorMessage(this.getTitle(), message, this.getHelpId(), this.myProject);
            }
            return;
        }
        if (this.myMethodsToPropagateParameters != null && !this.mayPropagateParameters()) {
            Messages.showWarningDialog(this.myProject, RefactoringBundle.message("changeSignature.parameters.wont.propagate"), ChangeSignatureHandler.REFACTORING_NAME);
            this.myMethodsToPropagateParameters = null;
        }
        this.myDisposed = true;
        this.invokeRefactoring(this.createRefactoringProcessor());
    }

    @Override
    protected String getHelpId() {
        return "refactoring.changeSignature";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeSignature/ChangeSignatureDialogBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeSignature/ChangeSignatureDialogBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalPanels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected abstract class ParametersListTable
    extends JBListTable {
        public ParametersListTable() {
            super(ChangeSignatureDialogBase.this.myParametersTable, ChangeSignatureDialogBase.this.getDisposable());
        }

        @Override
        protected final JBTableRowEditor getRowEditor(final int row) {
            JBTableRowEditor editor = this.getRowEditor((ParameterTableModelItemBase)this.getRowItem(row));
            editor.addDocumentListener(new JBTableRowEditor.RowDocumentListener(){

                @Override
                public void documentChanged(@NotNull DocumentEvent e, int column) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (String.class.equals(((ListTableModel)ChangeSignatureDialogBase.this.myParametersTableModel).getColumnClass(column))) {
                        ((ParameterTableModelBase)ChangeSignatureDialogBase.this.myParametersTableModel).setValueAtWithoutUpdate(e.getDocument().getText(), row, column);
                    }
                    ChangeSignatureDialogBase.this.updateSignature();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/changeSignature/ChangeSignatureDialogBase$ParametersListTable$1", "documentChanged"));
                }
            });
            return editor;
        }

        @NotNull
        protected abstract JBTableRowEditor getRowEditor(ParameterTableModelItemBase<ParamInfo> var1);

        @Override
        protected abstract boolean isRowEmpty(int var1);

        protected ParameterTableModelItem getRowItem(int row) {
            return (ParameterTableModelItemBase)ChangeSignatureDialogBase.this.myParametersTable.getItems().get(row);
        }
    }

    protected class UpdateSignatureListener
    implements ChangeListener,
    DocumentListener,
    TableModelListener {
        protected UpdateSignatureListener() {
        }

        private void update() {
            ChangeSignatureDialogBase.this.updateSignature();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.update();
        }

        @Override
        public void documentChanged(@NotNull DocumentEvent event) {
            if (event == null) {
                UpdateSignatureListener.$$$reportNull$$$0(0);
            }
            this.update();
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.update();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/changeSignature/ChangeSignatureDialogBase$UpdateSignatureListener", "documentChanged"));
        }
    }
}

