/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inplace;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.inplace.InplaceChangeSignature;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetectors;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyChangeSignatureAction
extends BaseRefactoringIntentionAction {
    public static final String CHANGE_SIGNATURE = "Apply signature change";
    private final String myMethodName;

    public ApplyChangeSignatureAction(String methodName) {
        this.myMethodName = methodName;
    }

    @Override
    @NotNull
    public String getText() {
        String string = RefactoringBundle.message("changing.signature.of.0", this.myMethodName);
        if (string == null) {
            ApplyChangeSignatureAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return CHANGE_SIGNATURE;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element2) {
        LanguageChangeSignatureDetector detector;
        if (project2 == null) {
            ApplyChangeSignatureAction.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            ApplyChangeSignatureAction.$$$reportNull$$$0(2);
        }
        if ((detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(element2.getLanguage())) != null) {
            ChangeInfo currentInfo;
            InplaceChangeSignature changeSignature = InplaceChangeSignature.getCurrentRefactoring(editor);
            ChangeInfo changeInfo = currentInfo = changeSignature != null ? changeSignature.getCurrentInfo() : null;
            if (currentInfo != null && detector.isChangeSignatureAvailableOnElement(element2, currentInfo)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        if (project2 == null) {
            ApplyChangeSignatureAction.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            ApplyChangeSignatureAction.$$$reportNull$$$0(4);
        }
        InplaceChangeSignature signatureGestureDetector = InplaceChangeSignature.getCurrentRefactoring(editor);
        String initialSignature = signatureGestureDetector.getInitialSignature();
        ChangeInfo currentInfo = signatureGestureDetector.getCurrentInfo();
        signatureGestureDetector.detach();
        LanguageChangeSignatureDetector detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(element2.getLanguage());
        detector.performChange(currentInfo, editor, initialSignature);
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            ApplyChangeSignatureAction.$$$reportNull$$$0(5);
        }
        return file2;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeSignature/inplace/ApplyChangeSignatureAction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeSignature/inplace/ApplyChangeSignatureAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

