/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inplace;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetectors;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.PositionTracker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InplaceChangeSignature
implements DocumentListener {
    public static final Key<InplaceChangeSignature> INPLACE_CHANGE_SIGNATURE = Key.create("EditorInplaceChangeSignature");
    private ChangeInfo myCurrentInfo;
    private ChangeInfo myStableChange;
    private String myInitialSignature;
    private String myInitialName;
    private Editor myEditor;
    private LanguageChangeSignatureDetector<ChangeInfo> myDetector;
    private final Project myProject;
    private final PsiDocumentManager myDocumentManager;
    private final ArrayList<RangeHighlighter> myHighlighters;
    private StartMarkAction myMarkAction;
    private Balloon myBalloon;
    private boolean myDelegate;
    private EditorEx myPreview;

    public InplaceChangeSignature(Project project2, Editor editor, @NotNull PsiElement element2) {
        if (element2 == null) {
            InplaceChangeSignature.$$$reportNull$$$0(0);
        }
        this.myHighlighters = new ArrayList();
        this.myDocumentManager = PsiDocumentManager.getInstance(project2);
        this.myProject = project2;
        try {
            this.myMarkAction = StartMarkAction.start(editor, project2, ChangeSignatureHandler.REFACTORING_NAME);
        }
        catch (StartMarkAction.AlreadyStartedException e) {
            int exitCode = Messages.showYesNoDialog(this.myProject, e.getMessage(), ChangeSignatureHandler.REFACTORING_NAME, RefactoringBundle.message("inplace.refactoring.navigate.to.started"), RefactoringBundle.message("inplace.refactoring.cancel.current"), Messages.getErrorIcon());
            if (exitCode == 2) {
                return;
            }
            PsiElement method2 = this.myStableChange.getMethod();
            VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(method2);
            PsiNavigationSupport.getInstance().createNavigatable(project2, virtualFile2, method2.getTextOffset()).navigate(true);
            return;
        }
        this.myEditor = editor;
        this.myDetector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(element2.getLanguage());
        this.myStableChange = this.myDetector.createInitialChangeInfo(element2);
        this.myInitialSignature = this.myDetector.extractSignature(this.myStableChange);
        this.myInitialName = DescriptiveNameUtil.getDescriptiveName(this.myStableChange.getMethod());
        TextRange highlightingRange = this.myDetector.getHighlightingRange(this.myStableChange);
        HighlightManager highlightManager = HighlightManager.getInstance(this.myProject);
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.LIVE_TEMPLATE_ATTRIBUTES);
        highlightManager.addRangeHighlight(editor, highlightingRange.getStartOffset(), highlightingRange.getEndOffset(), attributes, false, this.myHighlighters);
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.setGreedyToRight(true);
            highlighter.setGreedyToLeft(true);
        }
        this.myEditor.getDocument().addDocumentListener(this);
        this.myEditor.putUserData(INPLACE_CHANGE_SIGNATURE, this);
        this.myPreview = InplaceRefactoring.createPreviewComponent(project2, this.myDetector.getFileType());
        this.showBalloon();
    }

    @Nullable
    public static InplaceChangeSignature getCurrentRefactoring(@NotNull Editor editor) {
        if (editor == null) {
            InplaceChangeSignature.$$$reportNull$$$0(1);
        }
        return editor.getUserData(INPLACE_CHANGE_SIGNATURE);
    }

    public ChangeInfo getCurrentInfo() {
        return this.myCurrentInfo;
    }

    public String getInitialName() {
        return this.myInitialName;
    }

    public String getInitialSignature() {
        return this.myInitialSignature;
    }

    @NotNull
    public ChangeInfo getStableChange() {
        ChangeInfo changeInfo = this.myStableChange;
        if (changeInfo == null) {
            InplaceChangeSignature.$$$reportNull$$$0(2);
        }
        return changeInfo;
    }

    public void cancel() {
        TextRange highlightingRange = this.myDetector.getHighlightingRange(this.getStableChange());
        Document document = this.myEditor.getDocument();
        String initialSignature = this.myInitialSignature;
        this.detach();
        InplaceChangeSignature.temporallyRevertChanges(highlightingRange, document, initialSignature, this.myProject);
    }

    @Override
    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            InplaceChangeSignature.$$$reportNull$$$0(3);
        }
        RangeMarker marker = event.getDocument().createRangeMarker(event.getOffset(), event.getOffset());
        this.myDocumentManager.performWhenAllCommitted(() -> {
            if (this.myDetector == null) {
                return;
            }
            PsiFile file2 = this.myDocumentManager.getPsiFile(event.getDocument());
            if (file2 == null) {
                return;
            }
            PsiElement element2 = file2.findElementAt(marker.getStartOffset());
            marker.dispose();
            if (element2 == null || this.myDetector.ignoreChanges(element2)) {
                return;
            }
            if (element2 instanceof PsiWhiteSpace) {
                PsiElement method2 = this.myStableChange.getMethod();
                if (PsiTreeUtil.skipWhitespacesForward(element2) == method2) {
                    return;
                }
            }
            if (!this.myDetector.isChangeSignatureAvailableOnElement(element2, this.myStableChange)) {
                this.detach();
                return;
            }
            this.updateCurrentInfo();
        });
    }

    private void updateCurrentInfo() {
        String signature;
        ChangeInfo changeInfo;
        if (this.myCurrentInfo == null) {
            this.myCurrentInfo = this.myStableChange;
        }
        if ((changeInfo = this.myDetector.createNextChangeInfo(signature = this.myDetector.extractSignature(this.myCurrentInfo), this.myCurrentInfo, this.myDelegate)) == null && this.myCurrentInfo != null) {
            this.myStableChange = this.myCurrentInfo;
        }
        if (changeInfo != null) {
            this.updateMethodSignature(changeInfo);
        }
        this.myCurrentInfo = changeInfo;
    }

    private void updateMethodSignature(ChangeInfo changeInfo) {
        ArrayList deleteRanges = new ArrayList();
        ArrayList newRanges = new ArrayList();
        String methodSignature = this.myDetector.getMethodSignaturePreview(changeInfo, deleteRanges, newRanges);
        this.myPreview.getMarkupModel().removeAllHighlighters();
        WriteCommandAction.writeCommandAction(null).run(() -> this.myPreview.getDocument().replaceString(0, this.myPreview.getDocument().getTextLength(), methodSignature));
        TextAttributes deprecatedAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.DEPRECATED_ATTRIBUTES);
        for (TextRange range2 : deleteRanges) {
            this.myPreview.getMarkupModel().addRangeHighlighter(range2.getStartOffset(), range2.getEndOffset(), 3000, deprecatedAttributes, HighlighterTargetArea.EXACT_RANGE);
        }
        TextAttributes todoAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.TODO_DEFAULT_ATTRIBUTES);
        for (TextRange range3 : newRanges) {
            this.myPreview.getMarkupModel().addRangeHighlighter(range3.getStartOffset(), range3.getEndOffset(), 3000, todoAttributes, HighlighterTargetArea.EXACT_RANGE);
        }
    }

    protected void showBalloon() {
        NonFocusableCheckBox checkBox2 = new NonFocusableCheckBox(RefactoringBundle.message("delegation.panel.delegate.via.overloading.method"));
        checkBox2.addActionListener(e -> {
            this.myDelegate = checkBox2.isSelected();
            this.updateCurrentInfo();
        });
        JPanel content2 = new JPanel(new BorderLayout());
        content2.add((Component)new JBLabel(RefactoringBundle.message("inplace.change.signature.preview.label")), "North");
        content2.add((Component)this.myPreview.getComponent(), "Center");
        this.updateMethodSignature(this.myStableChange);
        content2.add((Component)checkBox2, "South");
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createDialogBalloonBuilder(content2, null).setSmallVariant(true);
        this.myBalloon = balloonBuilder.createBalloon();
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        this.myBalloon.show(new PositionTracker<Balloon>((Component)this.myEditor.getContentComponent()){

            @Override
            public RelativePoint recalculateLocation(Balloon object) {
                int offset = InplaceChangeSignature.this.myStableChange.getMethod().getTextOffset();
                VisualPosition visualPosition = InplaceChangeSignature.this.myEditor.offsetToVisualPosition(offset);
                Point point = InplaceChangeSignature.this.myEditor.visualPositionToXY(new VisualPosition(visualPosition.line, visualPosition.column));
                return new RelativePoint(InplaceChangeSignature.this.myEditor.getContentComponent(), point);
            }
        }, Balloon.Position.above);
        Disposer.register(this.myBalloon, () -> {
            EditorFactory.getInstance().releaseEditor(this.myPreview);
            this.myPreview = null;
        });
    }

    public void detach() {
        this.myEditor.getDocument().removeDocumentListener(this);
        HighlightManager highlightManager = HighlightManager.getInstance(this.myProject);
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlightManager.removeSegmentHighlighter(this.myEditor, highlighter);
        }
        this.myHighlighters.clear();
        this.myBalloon.hide();
        this.myDetector = null;
        FinishMarkAction.finish(this.myProject, this.myEditor, this.myMarkAction);
        this.myEditor.putUserData(INPLACE_CHANGE_SIGNATURE, null);
    }

    public static void temporallyRevertChanges(TextRange signatureRange, Document document, String initialSignature, Project project2) {
        WriteCommandAction.runWriteCommandAction(project2, () -> {
            document.replaceString(signatureRange.getStartOffset(), signatureRange.getEndOffset(), initialSignature);
            PsiDocumentManager.getInstance(project2).commitDocument(document);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeSignature/inplace/InplaceChangeSignature";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeSignature/inplace/InplaceChangeSignature";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStableChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRefactoring";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

