/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.classMembers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;

public abstract class MemberInfoBase<T extends PsiElement> {
    protected static final Logger LOG = Logger.getInstance(MemberInfoBase.class);
    private SmartPsiElementPointer<T> myMember;
    protected boolean isStatic;
    protected String displayName;
    private boolean isChecked = false;
    protected Boolean overrides;
    private boolean toAbstract = false;

    public MemberInfoBase(T member) {
        this.updateMember(member);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean checked) {
        this.isChecked = checked;
    }

    public Boolean getOverrides() {
        return this.overrides;
    }

    public T getMember() {
        T element2 = this.myMember.getElement();
        if (element2 != null) {
            PsiUtilCore.ensureValid(element2);
        }
        return element2;
    }

    public void updateMember(T element2) {
        this.myMember = SmartPointerManager.getInstance(element2.getProject()).createSmartPsiElementPointer(element2);
    }

    public boolean isToAbstract() {
        return this.toAbstract;
    }

    public void setToAbstract(boolean toAbstract) {
        this.toAbstract = toAbstract;
    }

    public static class EmptyFilter<T extends PsiElement>
    implements Filter<T> {
        @Override
        public boolean includeMember(T member) {
            return true;
        }
    }

    public static interface Filter<T extends PsiElement> {
        public boolean includeMember(T var1);
    }
}

