/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.DirectoryUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBLabelDecorator;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyFilesOrDirectoriesDialog
extends RefactoringDialog
implements DumbAware {
    public static final int MAX_PATH_LENGTH = 70;
    @NonNls
    private static final String COPY = "Copy";
    @NonNls
    private static final String COPY_OPEN_IN_EDITOR = "Copy.OpenInEditor";
    @NonNls
    private static final String RECENT_KEYS = "CopyFile.RECENT_KEYS";
    private JLabel myInformationLabel;
    private TextFieldWithHistoryWithBrowseButton myTargetDirectoryField;
    private boolean myUnknownFileType = false;
    private EditorTextField myNewNameField;
    private final PsiElement[] myElements;
    private final boolean myShowDirectoryField;
    private final boolean myShowNewNameField;
    private PsiDirectory myTargetDirectory;
    private boolean myFileCopy = false;

    public static String shortenPath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            CopyFilesOrDirectoriesDialog.$$$reportNull$$$0(0);
        }
        return StringUtil.shortenPathWithEllipsis(file2.getPresentableUrl(), 70);
    }

    @Deprecated
    public static JCheckBox createOpenInEditorCB() {
        JCheckBox checkBox2 = new JCheckBox(RefactoringBundle.message("open.copy.in.editor"), PropertiesComponent.getInstance().getBoolean(COPY_OPEN_IN_EDITOR, true));
        checkBox2.setMnemonic('o');
        return checkBox2;
    }

    @Deprecated
    public static void saveOpenInEditorState(boolean selected2) {
        PropertiesComponent.getInstance().setValue(COPY_OPEN_IN_EDITOR, String.valueOf(selected2));
    }

    public CopyFilesOrDirectoriesDialog(PsiElement[] elements2, @Nullable PsiDirectory defaultTargetDirectory, Project project2, boolean doClone) {
        super(project2, true, CopyFilesOrDirectoriesDialog.canBeOpenedInEditor(elements2));
        this.myElements = elements2;
        this.myShowDirectoryField = !doClone;
        boolean bl = this.myShowNewNameField = elements2.length == 1;
        if (doClone && elements2.length != 1) {
            throw new IllegalArgumentException("wrong number of elements to clone: " + elements2.length);
        }
        this.setTitle(RefactoringBundle.message(doClone ? "copy.files.clone.title" : "copy.files.copy.title"));
        this.init();
        for (int i = 0; i < elements2.length; ++i) {
            if (!(elements2[i] instanceof PsiFile)) continue;
            elements2[i] = ((PsiFile)elements2[i]).getOriginalFile();
        }
        if (elements2.length == 1) {
            String text2;
            if (elements2[0] instanceof PsiFile) {
                String fileName;
                PsiFile file2 = (PsiFile)elements2[0];
                VirtualFile vFile = file2.getVirtualFile();
                text2 = RefactoringBundle.message(doClone ? "copy.files.clone.file.0" : "copy.files.copy.file.0", CopyFilesOrDirectoriesDialog.shortenPath(vFile));
                String string = fileName = vFile.isInLocalFileSystem() ? vFile.getName() : PathUtil.suggestFileName(file2.getName(), true, true);
                if (StringUtil.isEmpty(vFile.getExtension()) && ScratchUtil.isScratch(vFile)) {
                    FileType type = ObjectUtils.notNull(file2.getLanguage().getAssociatedFileType(), file2.getFileType());
                    fileName = PathUtil.makeFileName(fileName, type.getDefaultExtension());
                }
                this.myNewNameField.setText(fileName);
                int dotIdx = fileName.lastIndexOf(46);
                if (dotIdx > 0) {
                    this.selectNameWithoutExtension(dotIdx);
                }
                this.myTargetDirectory = file2.getContainingDirectory();
                this.myFileCopy = true;
            } else {
                VirtualFile vFile = ((PsiDirectory)elements2[0]).getVirtualFile();
                text2 = RefactoringBundle.message(doClone ? "copy.files.clone.directory.0" : "copy.files.copy.directory.0", CopyFilesOrDirectoriesDialog.shortenPath(vFile));
                this.myNewNameField.setText(vFile.getName());
            }
            this.myInformationLabel.setText(text2);
        } else {
            this.setMultipleElementCopyLabel(elements2);
        }
        if (this.myShowDirectoryField) {
            String targetPath = defaultTargetDirectory == null ? "" : defaultTargetDirectory.getVirtualFile().getPresentableUrl();
            this.getTargetDirectoryComponent().setText(targetPath);
        }
        this.validateButtons();
    }

    private static boolean canBeOpenedInEditor(PsiElement[] elements2) {
        for (PsiElement element2 : elements2) {
            if (element2.getContainingFile() instanceof PsiBinaryFile) continue;
            return true;
        }
        return false;
    }

    private void selectNameWithoutExtension(int dotIdx) {
        Runnable selectRunnable = () -> {
            Editor editor = this.myNewNameField.getEditor();
            if (editor != null) {
                editor.getSelectionModel().setSelection(0, dotIdx);
                editor.getCaretModel().moveToOffset(dotIdx);
            } else {
                this.myNewNameField.selectAll();
            }
        };
        SwingUtilities.invokeLater(selectRunnable);
    }

    private void setMultipleElementCopyLabel(PsiElement[] elements2) {
        boolean allFiles = true;
        boolean allDirectories = true;
        for (PsiElement element2 : elements2) {
            if (element2 instanceof PsiDirectory) {
                allFiles = false;
                continue;
            }
            allDirectories = false;
        }
        if (allFiles) {
            this.myInformationLabel.setText(RefactoringBundle.message("copy.files.copy.specified.files.label"));
        } else if (allDirectories) {
            this.myInformationLabel.setText(RefactoringBundle.message("copy.files.copy.specified.directories.label"));
        } else {
            this.myInformationLabel.setText(RefactoringBundle.message("copy.files.copy.specified.mixed.label"));
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myShowNewNameField ? this.myNewNameField : this.getTargetDirectoryComponent();
    }

    protected TextFieldWithHistory getTargetDirectoryComponent() {
        return (TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent();
    }

    @Override
    protected JComponent createCenterPanel() {
        return new JPanel(new BorderLayout());
    }

    @Override
    protected JComponent createNorthPanel() {
        this.myInformationLabel = JBLabelDecorator.createJBLabelDecorator().setBold(true);
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addComponent(this.myInformationLabel).addVerticalGap(8);
        if (this.myShowNewNameField) {
            this.myNewNameField = new EditorTextField();
            this.myNewNameField.addDocumentListener(new DocumentListener(){

                @Override
                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    CopyFilesOrDirectoriesDialog.this.validateButtons();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesDialog$1", "documentChanged"));
                }
            });
            formBuilder.addLabeledComponent(RefactoringBundle.message("copy.files.new.name.label"), (JComponent)this.myNewNameField);
        }
        if (this.myShowDirectoryField) {
            this.myTargetDirectoryField = new TextFieldWithHistoryWithBrowseButton();
            this.myTargetDirectoryField.setTextFieldPreferredWidth(70);
            List<String> recentEntries = RecentsManager.getInstance(this.myProject).getRecentEntries(RECENT_KEYS);
            if (recentEntries != null) {
                this.getTargetDirectoryComponent().setHistory(recentEntries);
            }
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            this.myTargetDirectoryField.addBrowseFolderListener(RefactoringBundle.message("select.target.directory"), RefactoringBundle.message("the.file.will.be.copied.to.this.directory"), this.myProject, descriptor2, (TextComponentAccessor<? super TextFieldWithHistory>)TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
            this.getTargetDirectoryComponent().addDocumentListener(new DocumentAdapter(){

                @Override
                protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    CopyFilesOrDirectoriesDialog.this.validateButtons();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesDialog$2", "textChanged"));
                }
            });
            formBuilder.addLabeledComponent(RefactoringBundle.message("copy.files.to.directory.label"), (JComponent)this.myTargetDirectoryField);
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText(ActionManager.getInstance().getAction("CodeCompletion"));
            formBuilder.addTooltip(RefactoringBundle.message("path.completion.shortcut", shortcutText));
        }
        return formBuilder.getPanel();
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    public String getNewName() {
        return this.myNewNameField != null ? this.myNewNameField.getText().trim() : null;
    }

    @Deprecated
    public boolean openInEditor() {
        return this.isOpenInEditor();
    }

    @Override
    public boolean isOpenInEditor() {
        return !this.myUnknownFileType && super.isOpenInEditor();
    }

    @Override
    protected void doAction() {
        if (this.myShowNewNameField) {
            String newName = this.getNewName();
            if (newName.length() == 0) {
                Messages.showErrorDialog(this.myProject, RefactoringBundle.message("no.new.name.specified"), RefactoringBundle.message("error.title"));
                return;
            }
            if (this.myFileCopy && !PathUtilRt.isValidFileName(newName, false)) {
                Messages.showErrorDialog(this.myNewNameField, RefactoringBundle.message("name.is.not.a.valid.file.name"));
                return;
            }
            if (this.myFileCopy && this.myTargetDirectory != null && this.isOpenInEditor() && FileTypeChooser.getKnownFileTypeOrAssociate(this.myTargetDirectory.getVirtualFile(), newName, this.myProject) == null) {
                this.myUnknownFileType = true;
            }
        }
        if (this.myShowDirectoryField) {
            String targetDirectoryName = this.getTargetDirectoryComponent().getText();
            if (targetDirectoryName.length() == 0) {
                Messages.showErrorDialog(this.myProject, RefactoringBundle.message("no.target.directory.specified"), RefactoringBundle.message("error.title"));
                return;
            }
            RecentsManager.getInstance(this.myProject).registerRecentEntry(RECENT_KEYS, targetDirectoryName);
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    String path2 = FileUtil.toSystemIndependentName(targetDirectoryName);
                    this.myTargetDirectory = DirectoryUtil.mkdirs(PsiManager.getInstance(this.myProject), path2);
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }), RefactoringBundle.message("create.directory"), null);
            if (this.myTargetDirectory == null) {
                Messages.showErrorDialog(this.myProject, RefactoringBundle.message("cannot.create.directory"), RefactoringBundle.message("error.title"));
                return;
            }
            FileChooserUtil.setLastOpenedFile(this.myProject, this.myTargetDirectory.getVirtualFile());
            try {
                for (PsiElement element2 : this.myElements) {
                    MoveFilesOrDirectoriesUtil.checkIfMoveIntoSelf(element2, this.myTargetDirectory);
                }
            }
            catch (IncorrectOperationException e) {
                Messages.showErrorDialog(this.myProject, e.getMessage(), RefactoringBundle.message("error.title"));
                return;
            }
        }
        this.closeOKAction();
    }

    @Override
    protected boolean hasPreviewButton() {
        return false;
    }

    @Override
    protected boolean areButtonsValid() {
        String newName;
        if (this.myShowDirectoryField && this.getTargetDirectoryComponent().getText().length() == 0) {
            return false;
        }
        return !this.myShowNewNameField || (newName = this.getNewName()).length() != 0 && (!this.myFileCopy || PathUtilRt.isValidFileName(newName, false));
    }

    @Override
    @NotNull
    protected String getRefactoringId() {
        return COPY;
    }

    @Override
    protected String getHelpId() {
        return "refactoring.copyClass";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesDialog", "shortenPath"));
    }
}

