/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.CommonBundle;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.PsiDirectoryImpl;
import com.intellij.psi.impl.file.UpdateAddedFileProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyFilesOrDirectoriesHandler
extends CopyHandlerDelegateBase {
    private static final Logger LOG = Logger.getInstance(CopyFilesOrDirectoriesHandler.class);

    @Override
    public boolean canCopy(PsiElement[] elements2, boolean fromUpdate) {
        HashSet<String> names2 = new HashSet<String>();
        for (PsiElement element2 : elements2) {
            if (!(element2 instanceof PsiDirectory) && !(element2 instanceof PsiFile)) {
                return false;
            }
            if (!element2.isValid()) {
                return false;
            }
            if (element2 instanceof PsiCompiledFile) {
                return false;
            }
            String name = ((PsiFileSystemItem)element2).getName();
            if (names2.contains(name)) {
                return false;
            }
            names2.add(name);
        }
        if (fromUpdate) {
            return elements2.length > 0;
        }
        PsiElement[] filteredElements = PsiTreeUtil.filterAncestors(elements2);
        return filteredElements.length == elements2.length;
    }

    @Override
    public void doCopy(PsiElement[] elements2, PsiDirectory defaultTargetDirectory) {
        Project project2;
        PsiDirectory commonParent;
        if (defaultTargetDirectory == null && (commonParent = CopyFilesOrDirectoriesHandler.getCommonParentDirectory(elements2)) != null && !ScratchUtil.isScratch(commonParent.getVirtualFile())) {
            defaultTargetDirectory = commonParent;
        }
        Project project3 = project2 = defaultTargetDirectory != null ? defaultTargetDirectory.getProject() : elements2[0].getProject();
        if (defaultTargetDirectory != null && (defaultTargetDirectory = CopyFilesOrDirectoriesHandler.resolveDirectory(defaultTargetDirectory)) == null) {
            return;
        }
        defaultTargetDirectory = CopyFilesOrDirectoriesHandler.tryNotNullizeDirectory(project2, defaultTargetDirectory);
        CopyFilesOrDirectoriesHandler.copyAsFiles(elements2, defaultTargetDirectory, project2);
    }

    @Nullable
    private static PsiDirectory tryNotNullizeDirectory(@NotNull Project project2, @Nullable PsiDirectory defaultTargetDirectory) {
        if (project2 == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(0);
        }
        if (defaultTargetDirectory == null) {
            VirtualFile root = FileChooserUtil.getLastOpenedFile(project2);
            if (root == null) {
                VirtualFile virtualFile2 = root = project2.isDefault() ? null : ProjectUtil.guessProjectDir(project2);
            }
            if (root == null) {
                root = VfsUtil.getUserHomeDir();
            }
            PsiDirectory psiDirectory = root == null ? null : (defaultTargetDirectory = root.isDirectory() ? PsiManager.getInstance(project2).findDirectory(root) : PsiManager.getInstance(project2).findDirectory(root.getParent()));
            if (defaultTargetDirectory == null) {
                LOG.warn("No directory found for project: " + project2.getName() + ", root: " + root);
            }
        }
        return defaultTargetDirectory;
    }

    public static void copyAsFiles(PsiElement[] elements2, @Nullable PsiDirectory defaultTargetDirectory, Project project2) {
        CopyFilesOrDirectoriesHandler.doCopyAsFiles(elements2, defaultTargetDirectory, project2);
    }

    private static void doCopyAsFiles(PsiElement[] elements2, @Nullable PsiDirectory defaultTargetDirectory, Project project2) {
        boolean openInEditor;
        String newName;
        PsiDirectory targetDirectory;
        VirtualFile[] files2 = (VirtualFile[])Arrays.stream(elements2).map(el -> ((PsiFileSystemItem)el).getVirtualFile()).toArray(VirtualFile[]::new);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            targetDirectory = defaultTargetDirectory;
            newName = null;
            openInEditor = true;
        } else {
            CopyFilesOrDirectoriesDialog dialog2 = new CopyFilesOrDirectoriesDialog(elements2, defaultTargetDirectory, project2, false);
            if (dialog2.showAndGet()) {
                newName = elements2.length == 1 ? dialog2.getNewName() : null;
                targetDirectory = dialog2.getTargetDirectory();
                openInEditor = dialog2.isOpenInEditor();
            } else {
                return;
            }
        }
        if (targetDirectory != null) {
            PsiManager manager = PsiManager.getInstance(project2);
            try {
                for (VirtualFile file2 : files2) {
                    if (!file2.isDirectory()) continue;
                    PsiDirectory psiElement = manager.findDirectory(file2);
                    MoveFilesOrDirectoriesUtil.checkIfMoveIntoSelf(psiElement, targetDirectory);
                }
            }
            catch (IncorrectOperationException e) {
                CommonRefactoringUtil.showErrorHint(project2, null, e.getMessage(), CommonBundle.getErrorTitle(), null);
                return;
            }
            CommandProcessor.getInstance().executeCommand(project2, () -> CopyFilesOrDirectoriesHandler.copyImpl(files2, newName, targetDirectory, false, openInEditor), RefactoringBundle.message("copy.handler.copy.files.directories"), null);
        }
    }

    @Override
    public void doClone(PsiElement element2) {
        CopyFilesOrDirectoriesHandler.doCloneFile(element2);
    }

    public static void doCloneFile(PsiElement element2) {
        PsiDirectory targetDirectory = element2 instanceof PsiDirectory ? ((PsiDirectory)element2).getParentDirectory() : PlatformPackageUtil.getDirectory(element2);
        targetDirectory = CopyFilesOrDirectoriesHandler.tryNotNullizeDirectory(element2.getProject(), targetDirectory);
        if (targetDirectory == null) {
            return;
        }
        PsiElement[] elements2 = new PsiElement[]{element2};
        VirtualFile file2 = ((PsiFileSystemItem)element2).getVirtualFile();
        CopyFilesOrDirectoriesDialog dialog2 = new CopyFilesOrDirectoriesDialog(elements2, null, element2.getProject(), true);
        if (dialog2.showAndGet()) {
            String newName = dialog2.getNewName();
            CopyFilesOrDirectoriesHandler.copyImpl(new VirtualFile[]{file2}, newName, targetDirectory, true, true);
        }
    }

    @Nullable
    private static PsiDirectory getCommonParentDirectory(PsiElement[] elements2) {
        PsiDirectory result2 = null;
        for (PsiElement element2 : elements2) {
            PsiDirectory directory;
            if (element2 instanceof PsiDirectory) {
                directory = (PsiDirectory)element2;
                directory = directory.getParentDirectory();
            } else if (element2 instanceof PsiFile) {
                directory = PlatformPackageUtil.getDirectory(element2);
            } else {
                throw new IllegalArgumentException("unexpected element " + element2);
            }
            if (directory == null) continue;
            if (result2 == null) {
                result2 = directory;
                continue;
            }
            if (!PsiTreeUtil.isAncestor(directory, result2, true)) continue;
            result2 = directory;
        }
        return result2;
    }

    private static void copyImpl(VirtualFile @NotNull [] files2, @Nullable String newName, @NotNull PsiDirectory targetDirectory, boolean doClone, boolean openInEditor) {
        if (targetDirectory == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(2);
        }
        if (doClone && files2.length != 1) {
            throw new IllegalArgumentException("invalid number of elements to clone:" + files2.length);
        }
        if (newName != null && files2.length != 1) {
            throw new IllegalArgumentException("no new name should be set; number of elements is: " + files2.length);
        }
        Project project2 = targetDirectory.getProject();
        if (!CommonRefactoringUtil.checkReadOnlyStatus(project2, Collections.singleton(targetDirectory), true)) {
            return;
        }
        String title = RefactoringBundle.message(doClone ? "copy.handler.clone.files.directories" : "copy.handler.copy.files.directories");
        try {
            int[] nArray;
            if (files2.length > 1 || files2[0].isDirectory()) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = -1;
            } else {
                nArray = null;
            }
            int[] choice = nArray;
            ArrayList<PsiFile> added = new ArrayList<PsiFile>();
            PsiManager manager = PsiManager.getInstance(project2);
            for (VirtualFile file2 : files2) {
                PsiFileSystemItem item;
                PsiFileSystemItem psiFileSystemItem = item = file2.isDirectory() ? manager.findDirectory(file2) : manager.findFile(file2);
                if (item == null) {
                    LOG.info("invalid file: " + file2.getExtension());
                    continue;
                }
                CopyFilesOrDirectoriesHandler.copyToDirectory(item, newName, targetDirectory, choice, title, added);
            }
            if (!added.isEmpty()) {
                DumbService.getInstance(project2).completeJustSubmittedTasks();
                WriteAction.run(() -> UpdateAddedFileProcessor.updateAddedFiles(added));
                if (openInEditor) {
                    PsiFile firstFile = (PsiFile)added.get(0);
                    CopyHandler.updateSelectionInActiveProjectView(firstFile, project2, doClone);
                    if (!(firstFile instanceof PsiBinaryFile)) {
                        EditorHelper.openInEditor(firstFile);
                        ToolWindowManager.getInstance(project2).activateEditorComponent();
                    }
                }
            }
        }
        catch (IncorrectOperationException | IOException ex) {
            Messages.showErrorDialog(project2, ex.getMessage(), RefactoringBundle.message("error.title"));
        }
    }

    @Nullable
    public static PsiFile copyToDirectory(@NotNull PsiFileSystemItem elementToCopy, @Nullable String newName, @NotNull PsiDirectory targetDirectory) throws IncorrectOperationException, IOException {
        if (elementToCopy == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(3);
        }
        if (targetDirectory == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(4);
        }
        return CopyFilesOrDirectoriesHandler.copyToDirectory(elementToCopy, newName, targetDirectory, null, null);
    }

    @Nullable
    public static PsiFile copyToDirectory(@NotNull PsiFileSystemItem elementToCopy, @Nullable String newName, @NotNull PsiDirectory targetDirectory, int @Nullable [] choice, @Nullable String title) throws IncorrectOperationException, IOException {
        if (elementToCopy == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(5);
        }
        if (targetDirectory == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(6);
        }
        ArrayList<PsiFile> added = new ArrayList<PsiFile>();
        CopyFilesOrDirectoriesHandler.copyToDirectory(elementToCopy, newName, targetDirectory, choice, title, added);
        if (added.isEmpty()) {
            return null;
        }
        DumbService.getInstance(elementToCopy.getProject()).completeJustSubmittedTasks();
        WriteAction.run(() -> UpdateAddedFileProcessor.updateAddedFiles(added));
        return added.get(0);
    }

    private static void copyToDirectory(@NotNull PsiFileSystemItem elementToCopy, @Nullable String newName, @NotNull PsiDirectory targetDirectory, int @Nullable [] choice, @Nullable String title, @NotNull List<PsiFile> added) throws IncorrectOperationException, IOException {
        if (elementToCopy == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(7);
        }
        if (targetDirectory == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(8);
        }
        if (added == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(9);
        }
        if (elementToCopy instanceof PsiFile) {
            String name;
            PsiFile file2 = (PsiFile)elementToCopy;
            String string = name = newName == null ? file2.getName() : newName;
            if (CopyFilesOrDirectoriesHandler.checkFileExist(targetDirectory, choice, file2, name, "Copy")) {
                return;
            }
            ((PsiDirectoryImpl)targetDirectory).executeWithUpdatingAddedFilesDisabled(() -> ContainerUtil.addIfNotNull(added, WriteCommandAction.writeCommandAction(targetDirectory.getProject()).withName(title).compute(() -> targetDirectory.copyFileFrom(name, file2))));
        } else if (elementToCopy instanceof PsiDirectory) {
            PsiDirectory subdirectory;
            PsiDirectory existing;
            PsiDirectory directory = (PsiDirectory)elementToCopy;
            if (directory.equals(targetDirectory)) {
                return;
            }
            if (newName == null) {
                newName = directory.getName();
            }
            if ((existing = targetDirectory.findSubdirectory(newName)) == null) {
                String finalNewName = newName;
                subdirectory = WriteCommandAction.writeCommandAction(targetDirectory.getProject()).withName(title).compute(() -> targetDirectory.createSubdirectory(finalNewName));
            } else {
                subdirectory = existing;
            }
            EncodingRegistry.doActionAndRestoreEncoding(directory.getVirtualFile(), () -> subdirectory.getVirtualFile());
            VirtualFile[] children2 = directory.getVirtualFile().getChildren();
            Project project2 = subdirectory.getProject();
            PsiManager manager = PsiManager.getInstance(project2);
            for (VirtualFile file3 : children2) {
                PsiFileSystemItem item;
                PsiFileSystemItem psiFileSystemItem = item = file3.isDirectory() ? manager.findDirectory(file3) : manager.findFile(file3);
                if (item == null) {
                    LOG.info("invalid file: " + file3.getExtension());
                    continue;
                }
                CopyFilesOrDirectoriesHandler.copyToDirectory(item, null, subdirectory, choice, title, added);
            }
        } else {
            throw new IllegalArgumentException("unexpected elementToCopy: " + elementToCopy);
        }
    }

    public static boolean checkFileExist(@Nullable PsiDirectory targetDirectory, int[] choice, PsiFile file2, String name, String title) {
        if (targetDirectory == null) {
            return false;
        }
        PsiFile existing = targetDirectory.findFile(name);
        if (existing != null && !existing.equals(file2)) {
            int selection;
            if (choice == null || choice[0] == -1) {
                String[] stringArray;
                String message = String.format("File '%s' already exists in directory '%s'", name, targetDirectory.getVirtualFile().getPath());
                if (choice == null) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = "Overwrite";
                    stringArray = stringArray2;
                    stringArray2[1] = "Skip";
                } else {
                    String[] stringArray3 = new String[4];
                    stringArray3[0] = "Overwrite";
                    stringArray3[1] = "Skip";
                    stringArray3[2] = "Overwrite for all";
                    stringArray = stringArray3;
                    stringArray3[3] = "Skip for all";
                }
                String[] options = stringArray;
                selection = Messages.showDialog(targetDirectory.getProject(), message, title, options, 0, Messages.getQuestionIcon());
            } else {
                selection = choice[0];
            }
            if (choice != null && selection > 1) {
                choice[0] = selection % 2;
                selection = choice[0];
            }
            if (selection == 0) {
                WriteCommandAction.writeCommandAction(targetDirectory.getProject()).withName(title).run(() -> existing.delete());
            } else {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiDirectory resolveDirectory(@NotNull PsiDirectory defaultTargetDirectory) {
        if (defaultTargetDirectory == null) {
            CopyFilesOrDirectoriesHandler.$$$reportNull$$$0(10);
        }
        Project project2 = defaultTargetDirectory.getProject();
        Boolean showDirsChooser = defaultTargetDirectory.getCopyableUserData(CopyPasteDelegator.SHOW_CHOOSER_KEY);
        if (showDirsChooser != null && showDirsChooser.booleanValue()) {
            PsiDirectoryContainer directoryContainer = PsiDirectoryFactory.getInstance(project2).getDirectoryContainer(defaultTargetDirectory);
            if (directoryContainer == null) {
                return defaultTargetDirectory;
            }
            return MoveFilesOrDirectoriesUtil.resolveToDirectory(project2, directoryContainer);
        }
        return defaultTargetDirectory;
    }

    @Override
    @Nullable
    public String getActionName(PsiElement[] elements2) {
        int fileCount = 0;
        int directoryCount = 0;
        for (PsiElement element2 : elements2) {
            if (element2 instanceof PsiFile) {
                ++fileCount;
                continue;
            }
            if (!(element2 instanceof PsiDirectory)) continue;
            ++directoryCount;
        }
        if (directoryCount == 0) {
            return fileCount == 1 ? RefactoringBundle.message("copy.file") : RefactoringBundle.message("copy.files");
        }
        if (fileCount == 0) {
            return directoryCount == 1 ? RefactoringBundle.message("copy.directory") : RefactoringBundle.message("copy.directories");
        }
        return RefactoringBundle.message("copy.files.and.directories");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCopy";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultTargetDirectory";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryNotNullizeDirectory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "copyImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "copyToDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

