/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.inline.InlineOptions;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.ui.scale.JBUIScale;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.function.Predicate;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InlineOptionsDialog
extends RefactoringDialog
implements InlineOptions {
    protected JRadioButton myRbInlineAll;
    @Nullable
    protected JRadioButton myKeepTheDeclaration;
    protected JRadioButton myRbInlineThisOnly;
    protected boolean myInvokedOnReference;
    protected final PsiElement myElement;
    private final JLabel myNameLabel = new JLabel();

    protected InlineOptionsDialog(Project project2, boolean canBeParent, PsiElement element2) {
        super(project2, canBeParent);
        this.myElement = element2;
    }

    @Override
    protected JComponent createNorthPanel() {
        this.myNameLabel.setText(this.getNameLabelText());
        return this.myNameLabel;
    }

    @Override
    public boolean isInlineThisOnly() {
        return this.myRbInlineThisOnly.isSelected();
    }

    @Override
    public boolean isKeepTheDeclaration() {
        if (this.myKeepTheDeclaration != null) {
            return this.myKeepTheDeclaration.isSelected();
        }
        return false;
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        JRadioButton[] buttons;
        JRadioButton[] jRadioButtonArray;
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBorder(new EmptyBorder(JBUIScale.scale(10), 0, 0, 0));
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        this.myRbInlineAll = new JRadioButton();
        this.myRbInlineAll.setText(this.getInlineAllText());
        this.myRbInlineAll.setSelected(true);
        this.myRbInlineThisOnly = new JRadioButton();
        this.myRbInlineThisOnly.setText(this.getInlineThisText());
        boolean writable = this.allowInlineAll();
        optionsPanel.add(this.myRbInlineAll);
        String keepDeclarationText = this.getKeepTheDeclarationText();
        if (keepDeclarationText != null && writable) {
            this.myKeepTheDeclaration = new JRadioButton();
            this.myKeepTheDeclaration.setText(keepDeclarationText);
            optionsPanel.add(this.myKeepTheDeclaration);
        }
        optionsPanel.add(this.myRbInlineThisOnly);
        ButtonGroup bg = new ButtonGroup();
        if (this.myKeepTheDeclaration != null) {
            JRadioButton[] jRadioButtonArray2 = new JRadioButton[3];
            jRadioButtonArray2[0] = this.myRbInlineAll;
            jRadioButtonArray2[1] = this.myKeepTheDeclaration;
            jRadioButtonArray = jRadioButtonArray2;
            jRadioButtonArray2[2] = this.myRbInlineThisOnly;
        } else {
            JRadioButton[] jRadioButtonArray3 = new JRadioButton[2];
            jRadioButtonArray3[0] = this.myRbInlineAll;
            jRadioButtonArray = jRadioButtonArray3;
            jRadioButtonArray3[1] = this.myRbInlineThisOnly;
        }
        for (JRadioButton button2 : buttons = jRadioButtonArray) {
            bg.add(button2);
        }
        new RadioUpDownListener(buttons);
        this.myRbInlineThisOnly.setEnabled(this.myInvokedOnReference);
        this.myRbInlineAll.setEnabled(writable);
        if (this.myInvokedOnReference) {
            if (this.canInlineThisOnly()) {
                this.myRbInlineAll.setSelected(false);
                this.myRbInlineAll.setEnabled(false);
                if (this.myKeepTheDeclaration != null) {
                    this.myKeepTheDeclaration.setSelected(false);
                    this.myKeepTheDeclaration.setEnabled(false);
                }
                this.myRbInlineThisOnly.setSelected(true);
            } else if (writable) {
                boolean inlineThis = this.isInlineThis();
                this.myRbInlineThisOnly.setSelected(inlineThis);
                if (this.myKeepTheDeclaration != null) {
                    this.myKeepTheDeclaration.setSelected(false);
                }
                this.myRbInlineAll.setSelected(!inlineThis);
            } else {
                this.myRbInlineAll.setSelected(false);
                this.myRbInlineThisOnly.setSelected(true);
            }
        } else {
            this.myRbInlineAll.setSelected(true);
            if (this.myKeepTheDeclaration != null) {
                this.myKeepTheDeclaration.setSelected(false);
            }
            this.myRbInlineThisOnly.setSelected(false);
        }
        this.getPreviewAction().setEnabled(this.myRbInlineAll.isSelected() || this.myKeepTheDeclaration != null && this.myKeepTheDeclaration.isSelected());
        ActionListener previewListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = InlineOptionsDialog.this.myRbInlineAll.isSelected() || InlineOptionsDialog.this.myKeepTheDeclaration != null && InlineOptionsDialog.this.myKeepTheDeclaration.isSelected();
                InlineOptionsDialog.this.getPreviewAction().setEnabled(enabled);
            }
        };
        for (JRadioButton button3 : buttons) {
            button3.addActionListener(previewListener);
        }
        JPanel jPanel = optionsPanel;
        if (jPanel == null) {
            InlineOptionsDialog.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    protected boolean allowInlineAll() {
        return this.myElement.isWritable();
    }

    protected abstract String getNameLabelText();

    protected abstract String getBorderTitle();

    protected abstract String getInlineAllText();

    protected String getKeepTheDeclarationText() {
        return null;
    }

    protected abstract String getInlineThisText();

    protected abstract boolean isInlineThis();

    protected boolean canInlineThisOnly() {
        return false;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myRbInlineThisOnly.isSelected() ? this.myRbInlineThisOnly : this.myRbInlineAll;
    }

    protected boolean ignoreOccurrence(PsiReference reference2) {
        return false;
    }

    protected static int initOccurrencesNumber(PsiNameIdentifierOwner nameIdentifierOwner) {
        return InlineOptionsDialog.getNumberOfOccurrences(nameIdentifierOwner, reference2 -> true);
    }

    protected int getNumberOfOccurrences(PsiNameIdentifierOwner nameIdentifierOwner) {
        return InlineOptionsDialog.getNumberOfOccurrences(nameIdentifierOwner, this::ignoreOccurrence);
    }

    private static int getNumberOfOccurrences(PsiNameIdentifierOwner nameIdentifierOwner, Predicate<? super PsiReference> ignoreOccurrence) {
        ProgressManager progressManager = ProgressManager.getInstance();
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance(nameIdentifierOwner.getProject());
        GlobalSearchScope scope = GlobalSearchScope.projectScope(nameIdentifierOwner.getProject());
        String name = nameIdentifierOwner.getName();
        boolean isCheapToSearch = name != null && searchHelper.isCheapEnoughToSearch(name, scope, null, progressManager.getProgressIndicator()) != PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
        return isCheapToSearch ? (int)ReferencesSearch.search(nameIdentifierOwner, scope).findAll().stream().filter(ignoreOccurrence).count() : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/inline/InlineOptionsDialog", "createCenterPanel"));
    }
}

