/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduce.inplace;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LanguageTokenSeparatorGenerators;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.TokenSeparatorGenerator;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.MyLookupExpression;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InplaceVariableIntroducer<E extends PsiElement>
extends InplaceRefactoring {
    protected E myExpr;
    protected RangeMarker myExprMarker;
    protected E[] myOccurrences;
    protected List<RangeMarker> myOccurrenceMarkers;

    public InplaceVariableIntroducer(PsiNamedElement elementToRename, Editor editor, Project project2, String title, E[] occurrences, @Nullable E expr) {
        super(editor, elementToRename, project2);
        this.myTitle = title;
        this.myOccurrences = occurrences;
        if (expr != null) {
            ASTNode node = expr.getNode();
            if (node != null) {
                Lexer lexer;
                ASTNode astNode;
                ASTNode prev = node.getTreePrev();
                ASTNode aSTNode = astNode = prev instanceof PsiWhiteSpace ? null : ((TokenSeparatorGenerator)LanguageTokenSeparatorGenerators.INSTANCE.forLanguage(expr.getLanguage())).generateWhitespaceBetweenTokens(prev, node);
                if (astNode != null && LanguageUtil.canStickTokensTogetherByLexer(prev, prev, lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(expr.getLanguage())).createLexer(project2)) == ParserDefinition.SpaceRequirements.MUST) {
                    PostprocessReformattingAspect.getInstance(project2).disablePostprocessFormattingInside(() -> WriteCommandAction.writeCommandAction(project2).withName(RefactoringBundle.message("introduce.normalize.declaration.command.name")).run(() -> node.getTreeParent().addChild(astNode, node)));
                }
            }
            this.myExpr = expr;
        }
        this.myExprMarker = this.myExpr != null && this.myExpr.isPhysical() ? this.createMarker((PsiElement)this.myExpr) : null;
        this.initOccurrencesMarkers();
    }

    @Override
    protected boolean shouldSelectAll() {
        return true;
    }

    @Override
    protected StartMarkAction startRename() throws StartMarkAction.AlreadyStartedException {
        return null;
    }

    public void setOccurrenceMarkers(List<RangeMarker> occurrenceMarkers) {
        this.myOccurrenceMarkers = occurrenceMarkers;
    }

    public void setExprMarker(RangeMarker exprMarker) {
        this.myExprMarker = exprMarker;
    }

    @Nullable
    public E getExpr() {
        return this.myExpr != null && this.myExpr.isValid() && this.myExpr.isPhysical() ? (E)this.myExpr : null;
    }

    public E[] getOccurrences() {
        return this.myOccurrences;
    }

    public List<RangeMarker> getOccurrenceMarkers() {
        if (this.myOccurrenceMarkers == null) {
            this.initOccurrencesMarkers();
        }
        return this.myOccurrenceMarkers;
    }

    protected void initOccurrencesMarkers() {
        if (this.myOccurrenceMarkers != null) {
            return;
        }
        this.myOccurrenceMarkers = new ArrayList<RangeMarker>();
        for (E occurrence : this.myOccurrences) {
            this.myOccurrenceMarkers.add(this.createMarker((PsiElement)occurrence));
        }
    }

    protected RangeMarker createMarker(PsiElement element2) {
        return this.myEditor.getDocument().createRangeMarker(element2.getTextRange());
    }

    public RangeMarker getExprMarker() {
        return this.myExprMarker;
    }

    @Override
    protected boolean performRefactoring() {
        return false;
    }

    @Override
    protected void collectAdditionalElementsToRename(@NotNull List<Pair<PsiElement, TextRange>> stringUsages) {
        if (stringUsages == null) {
            InplaceVariableIntroducer.$$$reportNull$$$0(0);
        }
    }

    @Override
    protected String getCommandName() {
        return this.myTitle;
    }

    @Override
    protected void moveOffsetAfter(boolean success) {
        super.moveOffsetAfter(success);
        if (this.myOccurrenceMarkers != null) {
            for (RangeMarker marker : this.myOccurrenceMarkers) {
                marker.dispose();
            }
        }
        if (this.myExprMarker != null && !this.isRestart()) {
            this.myExprMarker.dispose();
        }
    }

    @Override
    protected MyLookupExpression createLookupExpression(PsiElement selectedElement) {
        return new MyIntroduceLookupExpression(this.getInitialName(), this.myNameSuggestions, this.myElementToRename, this.shouldSelectAll(), this.myAdvertisementText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringUsages", "com/intellij/refactoring/introduce/inplace/InplaceVariableIntroducer", "collectAdditionalElementsToRename"));
    }

    private static class MyIntroduceLookupExpression
    extends MyLookupExpression {
        private final SmartPsiElementPointer<PsiNamedElement> myPointer;

        MyIntroduceLookupExpression(String initialName, LinkedHashSet<String> names2, PsiNamedElement elementToRename, boolean shouldSelectAll, String advertisementText) {
            super(initialName, names2, elementToRename, elementToRename, shouldSelectAll, advertisementText);
            this.myPointer = SmartPointerManager.getInstance(elementToRename.getProject()).createSmartPsiElementPointer(elementToRename);
        }

        @Override
        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            return this.createLookupItems(this.myName, context.getEditor(), this.getElement());
        }

        @Nullable
        public PsiNamedElement getElement() {
            return this.myPointer.getElement();
        }

        private LookupElement @Nullable [] createLookupItems(String name, Editor editor, PsiNamedElement psiVariable) {
            TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
            if (psiVariable != null) {
                String text2;
                TextResult insertedValue;
                TextResult textResult = insertedValue = templateState != null ? templateState.getVariableValue("PrimaryVariable") : null;
                if (insertedValue != null && !(text2 = insertedValue.getText()).isEmpty() && !Comparing.strEqual(text2, name)) {
                    LinkedHashSet<String> names2 = new LinkedHashSet<String>();
                    names2.add(text2);
                    NameSuggestionProvider.suggestNames(psiVariable, psiVariable, names2);
                    LookupElement[] items = new LookupElement[names2.size()];
                    Iterator iterator2 = names2.iterator();
                    for (int i = 0; i < items.length; ++i) {
                        items[i] = LookupElementBuilder.create((String)iterator2.next());
                    }
                    return items;
                }
            }
            return this.myLookupItems;
        }
    }
}

