/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduce.inplace;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.ToolWindowManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComboBox;

public class KeyboardComboSwitcher {
    public static void setupActions(final JComboBox comboBox2, final Project project2) {
        final Ref<Boolean> moveFocusBack = Ref.create(true);
        comboBox2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!((Boolean)moveFocusBack.get()).booleanValue()) {
                    moveFocusBack.set(true);
                    return;
                }
                int size = comboBox2.getModel().getSize();
                int next = comboBox2.getSelectedIndex() + 1;
                if (size > 0) {
                    if (next < 0 || next >= size) {
                        if (!UISettings.getInstance().getCycleScrolling()) {
                            return;
                        }
                        next = (next + size) % size;
                    }
                    comboBox2.setSelectedIndex(next);
                }
                ToolWindowManager.getInstance(project2).activateEditorComponent();
            }
        });
        comboBox2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                moveFocusBack.set(false);
            }
        });
        comboBox2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                moveFocusBack.set(true);
            }
        });
        comboBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                moveFocusBack.set(true);
                if (!project2.isDisposed()) {
                    ToolWindowManager.getInstance(project2).activateEditorComponent();
                }
            }
        });
    }
}

