/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.invertBoolean;

import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.invertBoolean.InvertBooleanHandler;
import com.intellij.refactoring.invertBoolean.InvertBooleanProcessor;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.usageView.UsageViewUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InvertBooleanDialog
extends RefactoringDialog {
    private JTextField myNameField;
    private JPanel myPanel;
    private JLabel myLabel;
    private JLabel myCaptionLabel;
    private final PsiElement myElement;

    public InvertBooleanDialog(PsiElement element2) {
        super(element2.getProject(), false);
        this.myElement = element2;
        boolean bl = this.myElement instanceof PsiNamedElement;
        this.$$$setupUI$$$();
        String name = bl ? ((PsiNamedElement)this.myElement).getName() : this.myElement.getText();
        this.myNameField.setText(name);
        this.myLabel.setLabelFor(this.myNameField);
        String typeString = UsageViewUtil.getType(this.myElement);
        this.myLabel.setText(RefactoringBundle.message("invert.boolean.name.of.inverted.element", typeString));
        this.myCaptionLabel.setText(RefactoringBundle.message("invert.0.1", typeString, DescriptiveNameUtil.getDescriptiveName(this.myElement)));
        this.setTitle(InvertBooleanHandler.getRefactoringName());
        this.init();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    @Override
    protected void doAction() {
        String name = this.myNameField.getText().trim();
        if (!LanguageNamesValidation.isIdentifier(this.myElement.getLanguage(), name, this.myProject)) {
            CommonRefactoringUtil.showErrorMessage(InvertBooleanHandler.getRefactoringName(), RefactoringBundle.message("please.enter.a.valid.name.for.inverted.element", UsageViewUtil.getType(this.myElement)), this.getHelpId(), this.myProject);
            return;
        }
        this.invokeRefactoring(new InvertBooleanProcessor(this.myElement, name));
    }

    @Override
    protected String getHelpId() {
        return "refactoring.invertBoolean";
    }

    @Override
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextField jTextField;
        JLabel jLabel2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myLabel = jLabel2 = new JLabel();
        jLabel2.setInheritsPopupMenu(false);
        jLabel2.setText("");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCaptionLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

