/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.listeners;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;

public class RefactoringEventData
extends UserDataHolderBase {
    public static final Key<Collection<? extends String>> CONFLICTS_KEY = Key.create("conflicts");
    public static final Key<PsiElement> PSI_ELEMENT_KEY = Key.create("element");
    public static final Key<String[]> STRING_PROPERTIES = Key.create("stringProperties");
    public static final Key<PsiElement[]> PSI_ELEMENT_ARRAY_KEY = Key.create("elementArray");
    public static final Key<Collection<UsageInfo>> USAGE_INFOS_KEY = Key.create("usageInfos");

    public void addElement(PsiElement element2) {
        this.putUserData(PSI_ELEMENT_KEY, element2);
    }

    public <T> void addMembers(T[] members, Function<? super T, ? extends PsiElement> converter) {
        ArrayList<PsiElement> elements2 = new ArrayList<PsiElement>();
        for (T info : members) {
            elements2.add(converter.fun(info));
        }
        this.addElements(elements2);
    }

    public void addElements(Collection<PsiElement> elements2) {
        this.putUserData(PSI_ELEMENT_ARRAY_KEY, elements2.toArray(PsiElement.EMPTY_ARRAY));
    }

    public void addElements(PsiElement[] elements2) {
        this.putUserData(PSI_ELEMENT_ARRAY_KEY, elements2);
    }

    public void addUsages(Collection<UsageInfo> usageInfos) {
        this.putUserData(USAGE_INFOS_KEY, usageInfos);
    }

    public void addStringProperties(String ... properties) {
        this.putUserData(STRING_PROPERTIES, properties);
    }
}

