/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPushDown;

import com.intellij.lang.LanguageExtension;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.memberPushDown.NewSubClassData;
import com.intellij.refactoring.memberPushDown.PushDownData;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PushDownDelegate<MemberInfo extends MemberInfoBase<Member>, Member extends PsiElement> {
    public static final LanguageExtension<PushDownDelegate> EP_NAME = new LanguageExtension("com.intellij.refactoring.pushDown");

    @Nullable
    protected static <MemberInfo extends MemberInfoBase<Member>, Member extends PsiElement> PushDownDelegate<MemberInfo, Member> findDelegate(@NotNull PsiElement sourceClass) {
        if (sourceClass == null) {
            PushDownDelegate.$$$reportNull$$$0(0);
        }
        return EP_NAME.forLanguage(sourceClass.getLanguage());
    }

    @Nullable
    protected static PushDownDelegate findDelegateForTarget(@NotNull PsiElement sourceClass, @NotNull PsiElement targetClass) {
        if (sourceClass == null) {
            PushDownDelegate.$$$reportNull$$$0(1);
        }
        if (targetClass == null) {
            PushDownDelegate.$$$reportNull$$$0(2);
        }
        for (PushDownDelegate delegate : EP_NAME.allForLanguage(targetClass.getLanguage())) {
            if (!delegate.isApplicableForSource(sourceClass)) continue;
            return delegate;
        }
        return null;
    }

    protected abstract boolean isApplicableForSource(@NotNull PsiElement var1);

    protected abstract List<PsiElement> findInheritors(PushDownData<MemberInfo, Member> var1);

    protected UsageInfo createUsageInfo(PsiElement element2) {
        return new UsageInfo(element2);
    }

    protected abstract void checkSourceClassConflicts(PushDownData<MemberInfo, Member> var1, MultiMap<PsiElement, String> var2);

    protected abstract void checkTargetClassConflicts(@Nullable PsiElement var1, PushDownData<MemberInfo, Member> var2, MultiMap<PsiElement, String> var3, @Nullable NewSubClassData var4);

    protected void prepareToPush(PushDownData<MemberInfo, Member> pushDownData) {
    }

    protected abstract void pushDownToClass(PsiElement var1, PushDownData<MemberInfo, Member> var2);

    protected abstract void removeFromSourceClass(PushDownData<MemberInfo, Member> var1);

    protected NewSubClassData preprocessNoInheritorsFound(PsiElement sourceClass, String conflictDialogTitle) {
        String message = RefactoringBundle.message("class.0.does.not.have.inheritors", DescriptiveNameUtil.getDescriptiveName(sourceClass)) + "\n" + RefactoringBundle.message("push.down.will.delete.members");
        int answer = Messages.showYesNoDialog(message, conflictDialogTitle, Messages.getWarningIcon());
        if (answer != 0) {
            return NewSubClassData.ABORT_REFACTORING;
        }
        return null;
    }

    @Nullable
    protected PsiElement createSubClass(PsiElement aClass, NewSubClassData subClassData) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/memberPushDown/PushDownDelegate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findDelegate";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findDelegateForTarget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

