/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPushDown;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.memberPushDown.NewSubClassData;
import com.intellij.refactoring.memberPushDown.PushDownData;
import com.intellij.refactoring.memberPushDown.PushDownDelegate;
import com.intellij.refactoring.memberPushDown.PushDownUsageViewDescriptor;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushDownProcessor<MemberInfo extends MemberInfoBase<Member>, Member extends PsiElement, Klass extends PsiElement>
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(PushDownProcessor.class);
    private NewSubClassData mySubClassData;
    private final PushDownDelegate<MemberInfo, Member> myDelegate;
    private final PushDownData<MemberInfo, Member> myPushDownData;

    public PushDownProcessor(@NotNull Klass sourceClass, @NotNull List<MemberInfo> memberInfos, @NotNull DocCommentPolicy javaDocPolicy) {
        if (sourceClass == null) {
            PushDownProcessor.$$$reportNull$$$0(0);
        }
        if (memberInfos == null) {
            PushDownProcessor.$$$reportNull$$$0(1);
        }
        if (javaDocPolicy == null) {
            PushDownProcessor.$$$reportNull$$$0(2);
        }
        super(sourceClass.getProject());
        this.myDelegate = PushDownDelegate.findDelegate(sourceClass);
        LOG.assertTrue(this.myDelegate != null);
        this.myPushDownData = new PushDownData((PsiElement)sourceClass, memberInfos, javaDocPolicy);
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PushDownProcessor.$$$reportNull$$$0(3);
        }
        return new PushDownUsageViewDescriptor(this.myPushDownData.getSourceClass(), this.myPushDownData.getMembersToMove());
    }

    @Override
    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor2) {
        if (descriptor2 == null) {
            PushDownProcessor.$$$reportNull$$$0(4);
        }
        List<PsiElement> list2 = Collections.singletonList(this.myPushDownData.getSourceClass());
        if (list2 == null) {
            PushDownProcessor.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElement(this.myPushDownData.getSourceClass());
        data2.addElements(ContainerUtil.map(this.myPushDownData.getMembersToMove(), MemberInfoBase::getMember));
        return data2;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PushDownProcessor.$$$reportNull$$$0(6);
        }
        ArrayList<PsiElement> elements2 = new ArrayList<PsiElement>();
        for (UsageInfo usage : usages) {
            elements2.add(usage.getElement());
        }
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElements(elements2);
        return data2;
    }

    @Override
    protected UsageInfo @NotNull [] findUsages() {
        List<PsiElement> inheritors = this.myDelegate.findInheritors(this.myPushDownData);
        UsageInfo[] usageInfoArray = ContainerUtil.map2Array(inheritors, UsageInfo.EMPTY_ARRAY, this.myDelegate::createUsageInfo);
        if (usageInfoArray == null) {
            PushDownProcessor.$$$reportNull$$$0(7);
        }
        return usageInfoArray;
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            PushDownProcessor.$$$reportNull$$$0(8);
        }
        MultiMap<PsiElement, String> conflicts = new MultiMap<PsiElement, String>();
        this.myDelegate.checkSourceClassConflicts(this.myPushDownData, conflicts);
        UsageInfo[] usagesIn = refUsages.get();
        if (usagesIn.length == 0) {
            this.mySubClassData = this.myDelegate.preprocessNoInheritorsFound(this.myPushDownData.getSourceClass(), this.getCommandName());
            if (this.mySubClassData == NewSubClassData.ABORT_REFACTORING) {
                return false;
            }
        }
        Runnable runnable2 = () -> ApplicationManager.getApplication().runReadAction(() -> {
            if (this.mySubClassData != null) {
                this.myDelegate.checkTargetClassConflicts(null, this.myPushDownData, conflicts, this.mySubClassData);
            } else {
                for (UsageInfo usage : usagesIn) {
                    PsiElement element2 = usage.getElement();
                    if (element2 == null) continue;
                    PushDownDelegate delegate = PushDownDelegate.findDelegateForTarget(this.myPushDownData.getSourceClass(), element2);
                    if (delegate != null) {
                        delegate.checkTargetClassConflicts(element2, this.myPushDownData, conflicts, null);
                        continue;
                    }
                    conflicts.putValue(element2, "Not supported source/target pair detected");
                }
            }
        });
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable2, RefactoringBundle.message("detecting.possible.conflicts"), true, this.myProject)) {
            return false;
        }
        return this.showConflicts(conflicts, usagesIn);
    }

    @Override
    protected void refreshElements(PsiElement @NotNull [] elements2) {
        if (elements2 == null) {
            PushDownProcessor.$$$reportNull$$$0(9);
        }
        if (elements2.length == 1) {
            this.myPushDownData.setSourceClass(elements2[0]);
        } else {
            LOG.assertTrue(false);
        }
    }

    @Override
    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PushDownProcessor.$$$reportNull$$$0(10);
        }
        try {
            this.pushDownToClasses(usages);
            this.myDelegate.removeFromSourceClass(this.myPushDownData);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }

    public void pushDownToClasses(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PushDownProcessor.$$$reportNull$$$0(11);
        }
        this.myDelegate.prepareToPush(this.myPushDownData);
        PsiElement sourceClass = this.myPushDownData.getSourceClass();
        if (this.mySubClassData != null) {
            PsiElement subClass = this.myDelegate.createSubClass(sourceClass, this.mySubClassData);
            if (subClass != null) {
                this.myDelegate.pushDownToClass(subClass, this.myPushDownData);
            }
        } else {
            for (UsageInfo usage : usages) {
                PushDownDelegate targetDelegate;
                PsiElement element2 = usage.getElement();
                if (element2 == null || (targetDelegate = PushDownDelegate.findDelegateForTarget(sourceClass, element2)) == null) continue;
                targetDelegate.pushDownToClass(element2, this.myPushDownData);
            }
        }
    }

    @Override
    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message("push.members.down.title");
        if (string == null) {
            PushDownProcessor.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.push.down";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfos";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaDocPolicy";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/memberPushDown/PushDownProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/memberPushDown/PushDownProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "pushDownToClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

