/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import org.jetbrains.annotations.NotNull;

public class MoveMultipleElementsViewDescriptor
implements UsageViewDescriptor {
    private final PsiElement[] myPsiElements;
    private String myProcessedElementsHeader;
    private final String myCodeReferencesText;

    public MoveMultipleElementsViewDescriptor(PsiElement @NotNull [] psiElements, @NotNull String targetName) {
        if (targetName == null) {
            MoveMultipleElementsViewDescriptor.$$$reportNull$$$0(0);
        }
        if (psiElements == null) {
            MoveMultipleElementsViewDescriptor.$$$reportNull$$$0(1);
        }
        this.myPsiElements = psiElements;
        if (psiElements.length == 1) {
            this.myProcessedElementsHeader = StringUtil.capitalize(RefactoringBundle.message("move.single.element.elements.header", UsageViewUtil.getType(psiElements[0]), targetName));
            this.myCodeReferencesText = RefactoringBundle.message("references.in.code.to.0.1", UsageViewUtil.getType(psiElements[0]), UsageViewUtil.getLongName(psiElements[0]));
        } else {
            if (psiElements.length > 0) {
                this.myProcessedElementsHeader = StringUtil.capitalize(RefactoringBundle.message("move.single.element.elements.header", StringUtil.pluralize(UsageViewUtil.getType(psiElements[0])), targetName));
            }
            this.myCodeReferencesText = RefactoringBundle.message("references.found.in.code");
        }
    }

    @Override
    public PsiElement @NotNull [] getElements() {
        if (this.myPsiElements == null) {
            MoveMultipleElementsViewDescriptor.$$$reportNull$$$0(2);
        }
        return this.myPsiElements;
    }

    @Override
    public String getProcessedElementsHeader() {
        return this.myProcessedElementsHeader;
    }

    @Override
    @NotNull
    public String getCodeReferencesText(int usagesCount, int filesCount) {
        String string = this.myCodeReferencesText + UsageViewBundle.getReferencesString(usagesCount, filesCount);
        if (string == null) {
            MoveMultipleElementsViewDescriptor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public String getCommentReferencesText(int usagesCount, int filesCount) {
        return RefactoringBundle.message("comments.elements.header", UsageViewBundle.getOccurencesString(usagesCount, filesCount));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElements";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/MoveMultipleElementsViewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/MoveMultipleElementsViewDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeReferencesText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

