/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.util.DirectoryUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBLabelDecorator;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.FormBuilder;
import java.io.File;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;

public abstract class MoveFilesOrDirectoriesDialog
extends RefactoringDialog {
    private static final String MOVE_FILE = "MoveFile";
    private static final String RECENT_KEYS = "MoveFile.RECENT_KEYS";
    private static final String MOVE_FILES_OPEN_IN_EDITOR = "MoveFile.OpenInEditor";
    private JLabel myNameLabel;
    private TextFieldWithHistoryWithBrowseButton myTargetDirectoryField;
    private JCheckBox myCbSearchForReferences;

    public MoveFilesOrDirectoriesDialog(@NotNull Project project2, PsiElement @NotNull [] psiElements, PsiDirectory initialTargetDirectory) {
        if (project2 == null) {
            MoveFilesOrDirectoriesDialog.$$$reportNull$$$0(0);
        }
        if (psiElements == null) {
            MoveFilesOrDirectoriesDialog.$$$reportNull$$$0(1);
        }
        super(project2, true, true);
        this.setTitle(RefactoringBundle.message("move.title"));
        this.init();
        if (psiElements.length == 1) {
            PsiFileSystemItem element2 = (PsiFileSystemItem)psiElements[0];
            String path2 = CopyFilesOrDirectoriesDialog.shortenPath(element2.getVirtualFile());
            String string = RefactoringBundle.message(element2 instanceof PsiFile ? "move.file.0" : "move.directory.0", path2);
            this.myNameLabel.setText(string);
        } else {
            boolean isFile = true;
            boolean isDirectory = true;
            for (PsiElement psiElement : psiElements) {
                isFile &= psiElement instanceof PsiFile;
                isDirectory &= psiElement instanceof PsiDirectory;
            }
            this.myNameLabel.setText(isFile ? RefactoringBundle.message("move.specified.files") : (isDirectory ? RefactoringBundle.message("move.specified.directories") : RefactoringBundle.message("move.specified.elements")));
        }
        String initialTargetPath = initialTargetDirectory == null ? "" : initialTargetDirectory.getVirtualFile().getPresentableUrl();
        ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).setText(initialTargetPath);
        int lastDirectoryIdx = initialTargetPath.lastIndexOf(File.separator);
        int n = initialTargetPath.length();
        if (lastDirectoryIdx > 0 && lastDirectoryIdx + 1 < n) {
            ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).getTextEditor().select(lastDirectoryIdx + 1, n);
        }
        this.validateButtons();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myTargetDirectoryField;
    }

    @Override
    protected JComponent createCenterPanel() {
        return null;
    }

    @Override
    protected JComponent createNorthPanel() {
        this.myNameLabel = JBLabelDecorator.createJBLabelDecorator().setBold(true);
        this.myTargetDirectoryField = new TextFieldWithHistoryWithBrowseButton();
        List<String> recentEntries = RecentsManager.getInstance(this.myProject).getRecentEntries(RECENT_KEYS);
        if (recentEntries != null) {
            ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).setHistory(recentEntries);
        }
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myTargetDirectoryField.addBrowseFolderListener(RefactoringBundle.message("select.target.directory"), RefactoringBundle.message("the.file.will.be.moved.to.this.directory"), this.myProject, descriptor2, (TextComponentAccessor<? super TextFieldWithHistory>)TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        JTextField textField2 = ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).getTextEditor();
        FileChooserFactory.getInstance().installFileCompletion(textField2, descriptor2, true, this.getDisposable());
        textField2.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                MoveFilesOrDirectoriesDialog.this.validateButtons();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesDialog$1", "textChanged"));
            }
        });
        this.myTargetDirectoryField.setTextFieldPreferredWidth(70);
        Disposer.register(this.getDisposable(), this.myTargetDirectoryField);
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText(ActionManager.getInstance().getAction("CodeCompletion"));
        this.myCbSearchForReferences = new NonFocusableCheckBox(RefactoringBundle.message("search.for.references"));
        this.myCbSearchForReferences.setSelected(RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE);
        return FormBuilder.createFormBuilder().addComponent(this.myNameLabel).addLabeledComponent(RefactoringBundle.message("move.files.to.directory.label"), (JComponent)this.myTargetDirectoryField, 12).addTooltip(RefactoringBundle.message("path.completion.shortcut", shortcutText)).addComponentToRightColumn(this.myCbSearchForReferences, 12).getPanel();
    }

    @Override
    @NotNull
    protected String getRefactoringId() {
        return MOVE_FILE;
    }

    @Override
    protected String getHelpId() {
        return "refactoring.moveFile";
    }

    public static boolean isOpenInEditorProperty() {
        return !ApplicationManager.getApplication().isUnitTestMode() && PropertiesComponent.getInstance().getBoolean(MOVE_FILES_OPEN_IN_EDITOR, true);
    }

    @Override
    protected boolean hasPreviewButton() {
        return false;
    }

    @Override
    protected boolean areButtonsValid() {
        return ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).getText().length() > 0;
    }

    @Override
    protected void doAction() {
        RecentsManager.getInstance(this.myProject).registerRecentEntry(RECENT_KEYS, ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).getText());
        RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE = this.myCbSearchForReferences.isSelected();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            PsiDirectory targetDirectory = ApplicationManager.getApplication().runWriteAction(() -> {
                String directoryName = ((TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent()).getText().replace(File.separatorChar, '/');
                try {
                    return DirectoryUtil.mkdirs(PsiManager.getInstance(this.myProject), directoryName);
                }
                catch (IncorrectOperationException ignored) {
                    return null;
                }
            });
            if (targetDirectory == null) {
                CommonRefactoringUtil.showErrorMessage(this.getTitle(), RefactoringBundle.message("cannot.create.directory"), this.getHelpId(), this.myProject);
            } else {
                this.performMove(targetDirectory);
            }
        }, RefactoringBundle.message("move.title"), null);
    }

    protected abstract void performMove(@NotNull PsiDirectory var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

