/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import org.jetbrains.annotations.NotNull;

class MoveFilesOrDirectoriesViewDescriptor
implements UsageViewDescriptor {
    private final PsiElement[] myElementsToMove;
    private String myProcessedElementsHeader;
    private final String myCodeReferencesText;

    MoveFilesOrDirectoriesViewDescriptor(PsiElement[] elementsToMove, PsiDirectory newParent) {
        this.myElementsToMove = elementsToMove;
        if (elementsToMove.length == 1) {
            this.myProcessedElementsHeader = StringUtil.capitalize(RefactoringBundle.message("move.single.element.elements.header", UsageViewUtil.getType(elementsToMove[0]), newParent.getVirtualFile().getPresentableUrl()));
            this.myCodeReferencesText = RefactoringBundle.message("references.in.code.to.0.1", UsageViewUtil.getType(elementsToMove[0]), UsageViewUtil.getLongName(elementsToMove[0]));
        } else {
            if (elementsToMove[0] instanceof PsiFile) {
                this.myProcessedElementsHeader = StringUtil.capitalize(RefactoringBundle.message("move.files.elements.header", newParent.getVirtualFile().getPresentableUrl()));
            } else if (elementsToMove[0] instanceof PsiDirectory) {
                this.myProcessedElementsHeader = StringUtil.capitalize(RefactoringBundle.message("move.directories.elements.header", newParent.getVirtualFile().getPresentableUrl()));
            }
            this.myCodeReferencesText = RefactoringBundle.message("references.found.in.code");
        }
    }

    @Override
    public PsiElement @NotNull [] getElements() {
        if (this.myElementsToMove == null) {
            MoveFilesOrDirectoriesViewDescriptor.$$$reportNull$$$0(0);
        }
        return this.myElementsToMove;
    }

    @Override
    public String getProcessedElementsHeader() {
        return this.myProcessedElementsHeader;
    }

    @Override
    @NotNull
    public String getCodeReferencesText(int usagesCount, int filesCount) {
        String string = this.myCodeReferencesText + UsageViewBundle.getReferencesString(usagesCount, filesCount);
        if (string == null) {
            MoveFilesOrDirectoriesViewDescriptor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String getCommentReferencesText(int usagesCount, int filesCount) {
        return RefactoringBundle.message("comments.elements.header", UsageViewBundle.getOccurencesString(usagesCount, filesCount));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesViewDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeReferencesText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

