/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.file.PsiPackageBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.DirectoryRenameHandlerBase;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.util.Function;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public abstract class DirectoryAsPackageRenameHandlerBase<T extends PsiDirectoryContainer>
extends DirectoryRenameHandlerBase {
    private static final Logger LOG = Logger.getInstance(DirectoryAsPackageRenameHandlerBase.class);

    protected abstract VirtualFile[] occursInPackagePrefixes(T var1);

    protected abstract boolean isIdentifier(String var1, Project var2);

    protected abstract String getQualifiedName(T var1);

    @Nullable
    protected abstract T getPackage(PsiDirectory var1);

    protected abstract BaseRefactoringProcessor createProcessor(String var1, Project var2, PsiDirectory[] var3, boolean var4, boolean var5);

    @Override
    protected boolean isSuitableDirectory(PsiDirectory directory) {
        return this.getPackage(directory) != null;
    }

    @Override
    protected void doRename(PsiElement element2, Project project2, PsiElement nameSuggestionContext, Editor editor) {
        String qualifiedName;
        PsiDirectory psiDirectory = (PsiDirectory)element2;
        T aPackage = this.getPackage(psiDirectory);
        String string = qualifiedName = aPackage != null ? this.getQualifiedName(aPackage) : "";
        if (aPackage == null || qualifiedName.length() == 0 || !this.isIdentifier(psiDirectory.getName(), project2)) {
            PsiElementRenameHandler.rename(element2, project2, nameSuggestionContext, editor);
        } else {
            PsiDirectory[] directories = aPackage.getDirectories();
            VirtualFile[] virtualFiles = this.occursInPackagePrefixes(aPackage);
            if (virtualFiles.length == 0 && directories.length == 1) {
                PsiElementRenameHandler.rename(aPackage, project2, nameSuggestionContext, editor);
            } else {
                ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
                boolean inLib = false;
                for (PsiDirectory directory : directories) {
                    inLib |= !projectFileIndex.isInContent(directory.getVirtualFile());
                }
                PsiDirectory[] projectDirectories = aPackage.getDirectories(GlobalSearchScope.projectScope(project2));
                if (inLib) {
                    Module module2 = ModuleUtilCore.findModuleForPsiElement(psiDirectory);
                    LOG.assertTrue(module2 != null);
                    PsiDirectory[] moduleDirs = null;
                    if (nameSuggestionContext instanceof PsiPackageBase && (moduleDirs = aPackage.getDirectories(GlobalSearchScope.moduleScope(module2))).length <= 1) {
                        moduleDirs = null;
                    }
                    if (projectDirectories.length > 0) {
                        PsiDirectory[] psiDirectoryArray;
                        int ret = Messages.showYesNoCancelDialog(project2, RefactoringBundle.message("rename.package.with.lib.multiple.message", aPackage.getName(), moduleDirs == null ? 1 : 2), RefactoringBundle.message("warning.title"), RefactoringBundle.message("rename.current.directory"), RefactoringBundle.message("rename.directories"), CommonBundle.getCancelButtonText(), Messages.getWarningIcon());
                        if (ret == 2) {
                            return;
                        }
                        if (ret == 0) {
                            if (moduleDirs == null) {
                                PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                                psiDirectoryArray = psiDirectoryArray2;
                                psiDirectoryArray2[0] = psiDirectory;
                            } else {
                                psiDirectoryArray = moduleDirs;
                            }
                        } else {
                            psiDirectoryArray = projectDirectories;
                        }
                        this.renameDirs(project2, nameSuggestionContext, editor, psiDirectory, aPackage, psiDirectoryArray);
                    } else if (Messages.showOkCancelDialog(project2, RefactoringBundle.message("rename.package.with.lib.message", aPackage.getName(), moduleDirs == null ? 1 : 2), RefactoringBundle.message("warning.title"), Messages.getWarningIcon()) == 0) {
                        this.renameDirs(project2, nameSuggestionContext, editor, psiDirectory, aPackage, psiDirectory);
                    }
                } else {
                    StringBuffer message = new StringBuffer();
                    RenameUtil.buildPackagePrefixChangedMessage(virtualFiles, message, qualifiedName);
                    DirectoryAsPackageRenameHandlerBase.buildMultipleDirectoriesInPackageMessage(message, this.getQualifiedName(aPackage), directories);
                    message.append(RefactoringBundle.message("directories.and.all.references.to.package.will.be.renamed", psiDirectory.getVirtualFile().getPresentableUrl()));
                    int ret = Messages.showYesNoCancelDialog(project2, message.toString(), RefactoringBundle.message("warning.title"), RefactoringBundle.message("rename.package.button.text"), RefactoringBundle.message("rename.directory.button.text"), CommonBundle.getCancelButtonText(), Messages.getWarningIcon());
                    if (ret == 0) {
                        PsiElementRenameHandler.rename(aPackage, project2, nameSuggestionContext, editor);
                    } else if (ret == 1) {
                        this.renameDirs(project2, nameSuggestionContext, editor, psiDirectory, aPackage, psiDirectory);
                    }
                }
            }
        }
    }

    private void renameDirs(Project project2, PsiElement nameSuggestionContext, Editor editor, PsiDirectory contextDirectory, T aPackage, PsiDirectory ... dirsToRename) {
        RenameDialog dialog2 = new RenameDialog(project2, contextDirectory, nameSuggestionContext, editor, (PsiDirectoryContainer)aPackage, project2, dirsToRename){
            final /* synthetic */ PsiDirectoryContainer val$aPackage;
            final /* synthetic */ Project val$project;
            final /* synthetic */ PsiDirectory[] val$dirsToRename;
            {
                this.val$aPackage = psiDirectoryContainer;
                this.val$project = project3;
                this.val$dirsToRename = psiDirectoryArray;
                super(project2, psiElement, nameSuggestionContext, editor);
            }

            @Override
            protected void doAction() {
                String newQName = StringUtil.getQualifiedName(StringUtil.getPackageName(DirectoryAsPackageRenameHandlerBase.this.getQualifiedName(this.val$aPackage)), this.getNewName());
                BaseRefactoringProcessor moveProcessor = DirectoryAsPackageRenameHandlerBase.this.createProcessor(newQName, this.val$project, this.val$dirsToRename, this.isSearchInComments(), this.isSearchInNonJavaFiles());
                this.invokeRefactoring(moveProcessor);
            }
        };
        dialog2.show();
    }

    public static void buildMultipleDirectoriesInPackageMessage(StringBuffer message, String packageQname, PsiDirectory[] directories) {
        message.append(RefactoringBundle.message("multiple.directories.correspond.to.package"));
        message.append(packageQname);
        message.append(":\n\n");
        ArrayList<PsiDirectory> generated = new ArrayList<PsiDirectory>();
        ArrayList<PsiDirectory> source = new ArrayList<PsiDirectory>();
        for (PsiDirectory directory2 : directories) {
            VirtualFile virtualFile2 = directory2.getVirtualFile();
            if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(virtualFile2, directory2.getProject())) {
                generated.add(directory2);
                continue;
            }
            source.add(directory2);
        }
        Function<PsiDirectory, String> directoryPresentation = directory -> directory.getVirtualFile().getPresentableUrl();
        message.append(StringUtil.join(source, directoryPresentation, "\n"));
        if (!generated.isEmpty()) {
            message.append("\n\nalso generated:\n");
            message.append(StringUtil.join(generated, directoryPresentation, "\n"));
        }
    }
}

