/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageViewUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementRenameHandler
implements RenameHandler {
    private static final Logger LOG = Logger.getInstance(PsiElementRenameHandler.class);
    private static final ExtensionPointName<Condition<? super PsiElement>> VETO_RENAME_CONDITION_EP = ExtensionPointName.create("com.intellij.vetoRenameCondition");
    public static final DataKey<String> DEFAULT_NAME = DataKey.create("DEFAULT_NAME");

    @Override
    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, @NotNull DataContext dataContext) {
        String newName;
        PsiElement element2;
        if (project2 == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(1);
        }
        if ((element2 = PsiElementRenameHandler.getElement(dataContext)) == null) {
            element2 = BaseRefactoringAction.getElementAtCaret(editor, file2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (newName = DEFAULT_NAME.getData(dataContext)) != null) {
            PsiElementRenameHandler.rename(element2, project2, element2, editor, newName);
            return;
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement nameSuggestionContext = InjectedLanguageUtil.findElementAtNoCommit(file2, editor.getCaretModel().getOffset());
        PsiElementRenameHandler.invoke(element2, project2, nameSuggestionContext, editor, this.shouldCheckInProject());
    }

    @Override
    public void invoke(@NotNull Project project2, PsiElement @NotNull [] elements2, DataContext dataContext) {
        PsiElement element2;
        if (project2 == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(2);
        }
        if (elements2 == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(3);
        }
        PsiElement psiElement = element2 = elements2.length == 1 ? elements2[0] : null;
        if (element2 == null) {
            element2 = PsiElementRenameHandler.getElement(dataContext);
        }
        LOG.assertTrue(element2 != null);
        Editor editor = CommonDataKeys.EDITOR.getData(dataContext);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String newName = DEFAULT_NAME.getData(dataContext);
            LOG.assertTrue(newName != null);
            PsiElementRenameHandler.rename(element2, project2, element2, editor, newName);
        } else {
            PsiElementRenameHandler.invoke(element2, project2, element2, editor, this.shouldCheckInProject());
        }
    }

    protected boolean shouldCheckInProject() {
        return true;
    }

    public static void invoke(@NotNull PsiElement element2, @NotNull Project project2, PsiElement nameSuggestionContext, @Nullable Editor editor) {
        if (element2 == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(5);
        }
        PsiElementRenameHandler.invoke(element2, project2, nameSuggestionContext, editor, true);
    }

    public static void invoke(@NotNull PsiElement element2, @NotNull Project project2, PsiElement nameSuggestionContext, @Nullable Editor editor, boolean checkInProject) {
        if (element2 == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(7);
        }
        if (!PsiElementRenameHandler.canRename(project2, editor, element2)) {
            return;
        }
        VirtualFile contextFile = PsiUtilCore.getVirtualFile(nameSuggestionContext);
        if (checkInProject && nameSuggestionContext != null && nameSuggestionContext.isPhysical() && (contextFile == null || !ScratchUtil.isScratch(contextFile)) && !PsiManager.getInstance(project2).isInProject(nameSuggestionContext)) {
            String message = "Selected element is used from non-project files. These usages won't be renamed. Proceed anyway?";
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new CommonRefactoringUtil.RefactoringErrorHintException("Selected element is used from non-project files. These usages won't be renamed. Proceed anyway?");
            }
            if (Messages.showYesNoDialog(project2, "Selected element is used from non-project files. These usages won't be renamed. Proceed anyway?", RefactoringBundle.getCannotRefactorMessage(null), Messages.getWarningIcon()) != 0) {
                return;
            }
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.rename");
        PsiElementRenameHandler.rename(element2, project2, nameSuggestionContext, editor);
    }

    public static boolean canRename(@NotNull Project project2, Editor editor, PsiElement element2) throws CommonRefactoringUtil.RefactoringErrorHintException {
        String message;
        if (project2 == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(8);
        }
        String string = message = element2 == null ? null : PsiElementRenameHandler.renameabilityStatus(project2, element2);
        if (StringUtil.isNotEmpty(message)) {
            PsiElementRenameHandler.showErrorMessage(project2, editor, message);
            return false;
        }
        return true;
    }

    @Nullable
    private static String renameabilityStatus(@NotNull Project project2, @NotNull PsiElement element2) {
        boolean hasWritableMetaData;
        if (project2 == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(9);
        }
        if (element2 == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(10);
        }
        boolean hasRenameProcessor = RenamePsiElementProcessor.forElement(element2) != RenamePsiElementProcessor.DEFAULT;
        boolean bl = hasWritableMetaData = element2 instanceof PsiMetaOwner && ((PsiMetaOwner)((Object)element2)).getMetaData() instanceof PsiWritableMetaData;
        if (!(hasRenameProcessor || hasWritableMetaData || element2 instanceof PsiNamedElement)) {
            return RefactoringBundle.getCannotRefactorMessage(RefactoringBundle.message("error.wrong.caret.position.symbol.to.rename"));
        }
        if (!PsiManager.getInstance(project2).isInProject(element2)) {
            VirtualFile virtualFile2;
            if (element2.isPhysical() && ((virtualFile2 = PsiUtilCore.getVirtualFile(element2)) == null || !NonProjectFileWritingAccessProvider.isWriteAccessAllowed(virtualFile2, project2))) {
                String message = RefactoringBundle.message("error.out.of.project.element", UsageViewUtil.getType(element2));
                return RefactoringBundle.getCannotRefactorMessage(message);
            }
            if (!element2.isWritable()) {
                return RefactoringBundle.getCannotRefactorMessage(RefactoringBundle.message("error.cannot.be.renamed"));
            }
        }
        if (InjectedLanguageUtil.isInInjectedLanguagePrefixSuffix(element2)) {
            String message = RefactoringBundle.message("error.in.injected.lang.prefix.suffix", UsageViewUtil.getType(element2));
            return RefactoringBundle.getCannotRefactorMessage(message);
        }
        return null;
    }

    private static void showErrorMessage(@NotNull Project project2, @Nullable Editor editor, @NotNull String message) {
        if (project2 == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(11);
        }
        if (message == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(12);
        }
        CommonRefactoringUtil.showErrorHint(project2, editor, message, RefactoringBundle.message("rename.title"), null);
    }

    public static void rename(@NotNull PsiElement element2, @NotNull Project project2, PsiElement nameSuggestionContext, Editor editor) {
        if (element2 == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(13);
        }
        if (project2 == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(14);
        }
        PsiElementRenameHandler.rename(element2, project2, nameSuggestionContext, editor, null);
    }

    public static void rename(@NotNull PsiElement element2, @NotNull Project project2, PsiElement nameSuggestionContext, Editor editor, String defaultName) {
        if (element2 == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(15);
        }
        if (project2 == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(16);
        }
        RenamePsiElementProcessor processor2 = RenamePsiElementProcessor.forElement(element2);
        PsiElementRenameHandler.rename(element2, project2, nameSuggestionContext, editor, defaultName, processor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rename(@NotNull PsiElement element2, @NotNull Project project2, PsiElement nameSuggestionContext, Editor editor, String defaultName, RenamePsiElementProcessor processor2) {
        PsiElement substituted;
        if (element2 == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(17);
        }
        if (project2 == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(18);
        }
        if ((substituted = processor2.substituteElementToRename(element2, editor)) == null || !PsiElementRenameHandler.canRename(project2, editor, substituted)) {
            return;
        }
        RenameDialog dialog2 = processor2.createRenameDialog(project2, substituted, nameSuggestionContext, editor);
        if (defaultName == null && ApplicationManager.getApplication().isUnitTestMode()) {
            Object[] strings = dialog2.getSuggestedNames();
            if (strings != null && strings.length > 0) {
                Arrays.sort(strings);
                defaultName = strings[0];
            } else {
                defaultName = "undefined";
            }
        }
        if (defaultName != null) {
            try {
                dialog2.performRename((String)defaultName);
            }
            finally {
                dialog2.close(1);
            }
        } else {
            dialog2.show();
        }
    }

    @Override
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(19);
        }
        return !PsiElementRenameHandler.isVetoed(PsiElementRenameHandler.getElement(dataContext));
    }

    public static boolean isVetoed(PsiElement element2) {
        if (element2 == null || element2 instanceof SyntheticElement || element2 instanceof PsiNamedElement && ((PsiNamedElement)element2).getName() == null) {
            return true;
        }
        for (Condition<? super PsiElement> condition2 : VETO_RENAME_CONDITION_EP.getExtensionList()) {
            if (!condition2.value(element2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiElement getElement(@NotNull DataContext dataContext) {
        PsiElement[] elementArray;
        if (dataContext == null) {
            PsiElementRenameHandler.$$$reportNull$$$0(20);
        }
        if ((elementArray = BaseRefactoringAction.getPsiElementArray(dataContext)).length != 1) {
            return null;
        }
        return elementArray[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/PsiElementRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "canRename";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "renameabilityStatus";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorMessage";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "rename";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "getElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

