/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.refactoring.rename.RenameInputValidatorEx;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class RenameInputValidatorRegistry {
    private RenameInputValidatorRegistry() {
    }

    @Nullable
    public static Condition<String> getInputValidator(PsiElement element2) {
        ArrayList<Pair<RenameInputValidator, ProcessingContext>> validators = new ArrayList<Pair<RenameInputValidator, ProcessingContext>>();
        for (RenameInputValidator validator2 : RenameInputValidator.EP_NAME.getExtensionList()) {
            ProcessingContext context = new ProcessingContext();
            if (!validator2.getPattern().accepts(element2, context)) continue;
            validators.add(Pair.pair(validator2, context));
        }
        return validators.isEmpty() ? null : newName -> validators.stream().allMatch(p -> ((RenameInputValidator)p.first).isInputValid((String)newName, element2, (ProcessingContext)p.second));
    }

    @Nullable
    public static Function<String, String> getInputErrorValidator(PsiElement element2) {
        ArrayList<RenameInputValidatorEx> validators = new ArrayList<RenameInputValidatorEx>();
        for (RenameInputValidator validator2 : RenameInputValidator.EP_NAME.getExtensionList()) {
            if (!(validator2 instanceof RenameInputValidatorEx) || !validator2.getPattern().accepts(element2, new ProcessingContext())) continue;
            validators.add((RenameInputValidatorEx)validator2);
        }
        if (validators.isEmpty()) {
            return null;
        }
        Project project2 = element2.getProject();
        return newName -> validators.stream().map(v -> v.getErrorMessage((String)newName, project2)).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

