/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.find.findUsages.FindUsagesHelper;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiCheckedRenameElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import com.intellij.refactoring.rename.NonCodeUsageInfoFactory;
import com.intellij.refactoring.rename.RenameInputValidatorRegistry;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtilBase;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.TextOccurrencesUtilBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameUtil {
    private static final Logger LOG = Logger.getInstance(RenameUtil.class);

    private RenameUtil() {
    }

    public static UsageInfo @NotNull [] findUsages(@NotNull PsiElement element2, String newName, boolean searchInStringsAndComments, boolean searchForTextOccurrences, Map<? extends PsiElement, String> allRenames) {
        if (element2 == null) {
            RenameUtil.$$$reportNull$$$0(0);
        }
        return RenameUtil.findUsages(element2, newName, GlobalSearchScope.projectScope(element2.getProject()), searchInStringsAndComments, searchForTextOccurrences, allRenames);
    }

    public static UsageInfo @NotNull [] findUsages(@NotNull PsiElement element2, String newName, @NotNull SearchScope searchScope, boolean searchInStringsAndComments, boolean searchForTextOccurrences, Map<? extends PsiElement, String> allRenames) {
        if (element2 == null) {
            RenameUtil.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            RenameUtil.$$$reportNull$$$0(2);
        }
        List<UsageInfo> result2 = Collections.synchronizedList(new ArrayList());
        RenamePsiElementProcessor elementProcessor = RenamePsiElementProcessor.forElement(element2);
        RenameUtil.processUsages(info -> {
            result2.add((UsageInfo)info);
            return true;
        }, element2, elementProcessor, newName, searchScope, true, searchInStringsAndComments, searchForTextOccurrences);
        elementProcessor.findCollisions(element2, newName, allRenames, result2);
        UsageInfo[] usageInfoArray = result2.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            RenameUtil.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    public static boolean hasNonCodeUsages(@NotNull PsiElement element2, String newName, @NotNull SearchScope searchScope, boolean searchInStringsAndComments, boolean searchForTextOccurrences) {
        RenamePsiElementProcessor elementProcessor;
        if (element2 == null) {
            RenameUtil.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            RenameUtil.$$$reportNull$$$0(5);
        }
        return !RenameUtil.processUsages(info -> false, element2, elementProcessor = RenamePsiElementProcessor.forElement(element2), newName, searchScope, false, searchInStringsAndComments, searchForTextOccurrences);
    }

    private static boolean processUsages(@NotNull Processor<UsageInfo> processor2, @NotNull PsiElement element2, @NotNull RenamePsiElementProcessor elementProcessor, String newName, @NotNull SearchScope searchScope, boolean searchInCode, boolean searchInStringsAndComments, boolean searchForTextOccurrences) {
        String stringToReplace;
        NonCodeUsageInfoFactory factory;
        String stringToSearch;
        SearchScope useScope;
        if (processor2 == null) {
            RenameUtil.$$$reportNull$$$0(6);
        }
        if (element2 == null) {
            RenameUtil.$$$reportNull$$$0(7);
        }
        if (elementProcessor == null) {
            RenameUtil.$$$reportNull$$$0(8);
        }
        if (searchScope == null) {
            RenameUtil.$$$reportNull$$$0(9);
        }
        if (!((useScope = PsiSearchHelper.getInstance(element2.getProject()).getUseScope(element2)) instanceof LocalSearchScope)) {
            useScope = searchScope.intersectWith(useScope);
        }
        if (searchInCode) {
            Collection<PsiReference> refs = elementProcessor.findReferences(element2, useScope, searchInStringsAndComments);
            for (PsiReference ref : refs) {
                if (ref == null) {
                    LOG.error("null reference from processor " + elementProcessor);
                    continue;
                }
                PsiElement referenceElement = ref.getElement();
                if (processor2.process(elementProcessor.createUsageInfo(element2, ref, referenceElement))) continue;
                return false;
            }
        }
        PsiElement searchForInComments = elementProcessor.getElementToSearchInStringsAndComments(element2);
        if (searchInStringsAndComments && searchForInComments != null && (stringToSearch = ElementDescriptionUtil.getElementDescription(searchForInComments, NonCodeSearchDescriptionLocation.STRINGS_AND_COMMENTS)).length() > 0 && !TextOccurrencesUtilBase.processUsagesInStringsAndComments(processor2, searchForInComments, searchScope, stringToSearch, factory = new NonCodeUsageInfoFactory(searchForInComments, stringToReplace = RenameUtil.getStringToReplace(element2, newName, false, elementProcessor)))) {
            return false;
        }
        if (searchForTextOccurrences && searchForInComments != null) {
            stringToSearch = ElementDescriptionUtil.getElementDescription(searchForInComments, NonCodeSearchDescriptionLocation.NON_JAVA);
            if (stringToSearch.length() > 0 && !RenameUtil.processTextOccurrences(processor2, searchForInComments, searchScope, stringToSearch, stringToReplace = RenameUtil.getStringToReplace(element2, newName, true, elementProcessor))) {
                return false;
            }
            Pair<String, String> additionalStringToSearch = elementProcessor.getTextOccurrenceSearchStrings(searchForInComments, newName);
            if (additionalStringToSearch != null && ((String)additionalStringToSearch.first).length() > 0 && !RenameUtil.processTextOccurrences(processor2, searchForInComments, searchScope, (String)additionalStringToSearch.first, (String)additionalStringToSearch.second)) {
                return false;
            }
        }
        return true;
    }

    private static boolean processTextOccurrences(@NotNull Processor<UsageInfo> processor2, final @NotNull PsiElement element2, @NotNull SearchScope searchScope, @NotNull String stringToSearch, final String stringToReplace) {
        if (processor2 == null) {
            RenameUtil.$$$reportNull$$$0(10);
        }
        if (element2 == null) {
            RenameUtil.$$$reportNull$$$0(11);
        }
        if (searchScope == null) {
            RenameUtil.$$$reportNull$$$0(12);
        }
        if (stringToSearch == null) {
            RenameUtil.$$$reportNull$$$0(13);
        }
        UsageInfoFactory factory = new UsageInfoFactory(){

            @Override
            public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
                TextRange textRange;
                if (usage == null) {
                    1.$$$reportNull$$$0(0);
                }
                int start2 = (textRange = usage.getTextRange()) == null ? 0 : textRange.getStartOffset();
                return NonCodeUsageInfo.create(usage.getContainingFile(), start2 + startOffset, start2 + endOffset, element2, stringToReplace);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/refactoring/rename/RenameUtil$1", "createUsageInfo"));
            }
        };
        if (searchScope instanceof GlobalSearchScope) {
            return FindUsagesHelper.processTextOccurrences(element2, stringToSearch, (GlobalSearchScope)searchScope, factory, processor2);
        }
        return true;
    }

    public static void buildPackagePrefixChangedMessage(VirtualFile[] virtualFiles, StringBuffer message, String qualifiedName) {
        if (virtualFiles.length > 0) {
            message.append(RefactoringBundle.message("package.occurs.in.package.prefixes.of.the.following.source.folders.n", qualifiedName));
            for (VirtualFile virtualFile2 : virtualFiles) {
                message.append(virtualFile2.getPresentableUrl()).append("\n");
            }
            message.append(RefactoringBundle.message("these.package.prefixes.will.be.changed"));
        }
    }

    private static String getStringToReplace(PsiElement element2, String newName, boolean nonJava, RenamePsiElementProcessor theProcessor) {
        String result2;
        PsiMetaOwner psiMetaOwner;
        PsiMetaData metaData;
        if (element2 instanceof PsiMetaOwner && (metaData = (psiMetaOwner = (PsiMetaOwner)((Object)element2)).getMetaData()) != null) {
            return metaData.getName();
        }
        if (theProcessor != null && (result2 = theProcessor.getQualifiedNameAfterRename(element2, newName, nonJava)) != null) {
            return result2;
        }
        if (element2 instanceof PsiNamedElement) {
            return newName;
        }
        LOG.error("Unknown element type : " + element2);
        return null;
    }

    public static void checkRename(PsiElement element2, String newName) throws IncorrectOperationException {
        if (element2 instanceof PsiCheckedRenameElement) {
            ((PsiCheckedRenameElement)element2).checkSetName(newName);
        }
    }

    public static void doRename(final PsiElement element2, String newName, UsageInfo[] usages, Project project2, final @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        String fqn;
        RenamePsiElementProcessor processor2 = RenamePsiElementProcessor.forElement(element2);
        String string = fqn = element2 instanceof PsiFile ? ((PsiFile)element2).getVirtualFile().getPath() : CopyReferenceAction.elementToFqn(element2);
        if (fqn != null) {
            BasicUndoableAction action2 = new BasicUndoableAction(){

                @Override
                public void undo() {
                    if (listener2 instanceof UndoRefactoringElementListener) {
                        ((UndoRefactoringElementListener)((Object)listener2)).undoElementMovedOrRenamed(element2, fqn);
                    }
                }

                @Override
                public void redo() {
                }
            };
            UndoManager.getInstance(project2).undoableActionPerformed(action2);
        }
        processor2.renameElement(element2, newName, usages, listener2);
    }

    public static void showErrorMessage(IncorrectOperationException e, PsiElement element2, Project project2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(e);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            String helpID = RenamePsiElementProcessor.forElement(element2).getHelpID(element2);
            String message = e.getMessage();
            if (StringUtil.isEmpty(message)) {
                message = RefactoringBundle.message("rename.not.supported");
            }
            CommonRefactoringUtil.showErrorMessage(RefactoringBundle.message("rename.title"), message, helpID, project2);
        });
    }

    public static void doRenameGenericNamedElement(@NotNull PsiElement namedElement, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        if (namedElement == null) {
            RenameUtil.$$$reportNull$$$0(14);
        }
        RenameUtilBase.doRenameGenericNamedElement(namedElement, newName, usages, listener2);
    }

    public static void rename(UsageInfo info, String newName) throws IncorrectOperationException {
        RenameUtilBase.rename(info, newName);
    }

    @Nullable
    public static List<UnresolvableCollisionUsageInfo> removeConflictUsages(Set<UsageInfo> usages) {
        ArrayList<UnresolvableCollisionUsageInfo> result2 = new ArrayList<UnresolvableCollisionUsageInfo>();
        Iterator<UsageInfo> iterator2 = usages.iterator();
        while (iterator2.hasNext()) {
            UsageInfo usageInfo = iterator2.next();
            if (!(usageInfo instanceof UnresolvableCollisionUsageInfo)) continue;
            result2.add((UnresolvableCollisionUsageInfo)usageInfo);
            iterator2.remove();
        }
        return result2.isEmpty() ? null : result2;
    }

    public static void addConflictDescriptions(UsageInfo[] usages, MultiMap<PsiElement, String> conflicts) {
        for (UsageInfo usage : usages) {
            if (!(usage instanceof UnresolvableCollisionUsageInfo)) continue;
            conflicts.putValue(usage.getElement(), ((UnresolvableCollisionUsageInfo)usage).getDescription());
        }
    }

    public static void renameNonCodeUsages(@NotNull Project project2, NonCodeUsageInfo @NotNull [] usages) {
        if (project2 == null) {
            RenameUtil.$$$reportNull$$$0(15);
        }
        if (usages == null) {
            RenameUtil.$$$reportNull$$$0(16);
        }
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        HashMap docsToOffsetsMap = new HashMap();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(project2);
        for (NonCodeUsageInfo usage : usages) {
            ProperTextRange rangeInElement;
            PsiElement element2 = usage.getElement();
            if (element2 == null || (element2 = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(element2, true)) == null || (rangeInElement = usage.getRangeInElement()) == null) continue;
            PsiFile containingFile = element2.getContainingFile();
            Document document = psiDocumentManager.getDocument(containingFile);
            Segment segment = usage.getSegment();
            LOG.assertTrue(segment != null);
            TextRange replaceRange = TextRange.create(segment);
            while (document instanceof DocumentWindow) {
                DocumentWindow documentWindow = (DocumentWindow)document;
                replaceRange = documentWindow.injectedToHost(replaceRange);
                document = documentWindow.getDelegate();
            }
            int fileOffset = replaceRange.getStartOffset();
            HashMap<Integer, UsageOffset> offsetMap = (HashMap<Integer, UsageOffset>)docsToOffsetsMap.get(document);
            if (offsetMap == null) {
                offsetMap = new HashMap<Integer, UsageOffset>();
                docsToOffsetsMap.put(document, offsetMap);
            }
            UsageOffset substitution = new UsageOffset(fileOffset, fileOffset + rangeInElement.getLength(), usage.newText);
            UsageOffset duplicate = (UsageOffset)offsetMap.get(fileOffset);
            if (duplicate != null) {
                LOG.assertTrue(duplicate.equals(substitution), "unequal renaming in the same place of document");
                continue;
            }
            offsetMap.put(fileOffset, substitution);
        }
        for (Document document : docsToOffsetsMap.keySet()) {
            Map offsetMap = (Map)docsToOffsetsMap.get(document);
            LOG.assertTrue(offsetMap != null, document);
            Object[] offsets2 = offsetMap.values().toArray(new UsageOffset[0]);
            Arrays.sort(offsets2);
            for (int i = offsets2.length - 1; i >= 0; --i) {
                Object usageOffset = offsets2[i];
                document.replaceString(((UsageOffset)usageOffset).startOffset, ((UsageOffset)usageOffset).endOffset, ((UsageOffset)usageOffset).newText);
            }
            PsiDocumentManager.getInstance(project2).commitDocument(document);
        }
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
    }

    public static boolean isValidName(Project project2, PsiElement psiElement, String newName) {
        Language fileLanguage;
        if (newName == null || newName.length() == 0) {
            return false;
        }
        Condition<String> inputValidator = RenameInputValidatorRegistry.getInputValidator(psiElement);
        if (inputValidator != null) {
            return inputValidator.value(newName);
        }
        if (psiElement instanceof PsiFile || psiElement instanceof PsiDirectory) {
            return newName.indexOf(92) < 0 && newName.indexOf(47) < 0;
        }
        if (psiElement instanceof PomTargetPsiElement) {
            return !StringUtil.isEmptyOrSpaces(newName);
        }
        PsiFile file2 = psiElement.getContainingFile();
        Language elementLanguage = psiElement.getLanguage();
        Language language2 = fileLanguage = file2 == null ? null : file2.getLanguage();
        Language language3 = fileLanguage == null ? elementLanguage : (fileLanguage.isKindOf(elementLanguage) ? fileLanguage : elementLanguage);
        return LanguageNamesValidation.isIdentifier(language3, newName.trim(), project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/RenameUtil";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementProcessor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToSearch";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/RenameUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasNonCodeUsages";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processUsages";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processTextOccurrences";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doRenameGenericNamedElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "renameNonCodeUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UsageOffset
    implements Comparable<UsageOffset> {
        final int startOffset;
        final int endOffset;
        final String newText;

        UsageOffset(int startOffset, int endOffset, String newText) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.newText = newText;
        }

        @Override
        public int compareTo(@NotNull UsageOffset o) {
            if (o == null) {
                UsageOffset.$$$reportNull$$$0(0);
            }
            return this.startOffset - o.startOffset;
        }

        @Contract(value="null -> false", pure=true)
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UsageOffset offset = (UsageOffset)o;
            return this.startOffset == offset.startOffset && this.endOffset == offset.endOffset && Objects.equals(this.newText, offset.newText);
        }

        public int hashCode() {
            return Objects.hash(this.startOffset, this.endOffset, this.newText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/refactoring/rename/RenameUtil$UsageOffset", "compareTo"));
        }
    }
}

