/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtilRt;
import gnu.trove.THashSet;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;

public class RenameViewDescriptor
implements UsageViewDescriptor {
    private static final Logger LOG = Logger.getInstance(RenameViewDescriptor.class);
    private final String myProcessedElementsHeader;
    private final String myCodeReferencesText;
    private final PsiElement[] myElements;

    public RenameViewDescriptor(LinkedHashMap<PsiElement, String> renamesMap) {
        this.myElements = PsiUtilCore.toPsiElementArray(renamesMap.keySet());
        THashSet<String> processedElementsHeaders = new THashSet<String>();
        THashSet<String> codeReferences = new THashSet<String>();
        for (PsiElement element2 : this.myElements) {
            String fullName;
            int lastDot;
            PsiUtilCore.ensureValid(element2);
            String newName = renamesMap.get(element2);
            String prefix = "";
            if (element2 instanceof PsiDirectory && (lastDot = (fullName = UsageViewUtil.getLongName(element2)).lastIndexOf(46)) >= 0 && lastDot + 1 < fullName.length() && ((PsiDirectory)element2).getName().equals(fullName.substring(lastDot + 1))) {
                prefix = fullName.substring(0, lastDot + 1);
            }
            processedElementsHeaders.add(StringUtil.capitalize(RefactoringBundle.message("0.to.be.renamed.to.1.2", UsageViewUtil.getType(element2), prefix, newName)));
            codeReferences.add(UsageViewUtil.getType(element2) + " " + UsageViewUtil.getLongName(element2));
        }
        this.myProcessedElementsHeader = StringUtil.join(ArrayUtilRt.toStringArray(processedElementsHeaders), ", ");
        this.myCodeReferencesText = RefactoringBundle.message("references.in.code.to.0", StringUtil.join(ArrayUtilRt.toStringArray(codeReferences), ", "));
    }

    @Override
    public PsiElement @NotNull [] getElements() {
        if (this.myElements == null) {
            RenameViewDescriptor.$$$reportNull$$$0(0);
        }
        return this.myElements;
    }

    @Override
    public String getProcessedElementsHeader() {
        return this.myProcessedElementsHeader;
    }

    @Override
    @NotNull
    public String getCodeReferencesText(int usagesCount, int filesCount) {
        String string = this.myCodeReferencesText + UsageViewBundle.getReferencesString(usagesCount, filesCount);
        if (string == null) {
            RenameViewDescriptor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String getCommentReferencesText(int usagesCount, int filesCount) {
        return RefactoringBundle.message("comments.elements.header", UsageViewBundle.getOccurencesString(usagesCount, filesCount));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/refactoring/rename/RenameViewDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeReferencesText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

