/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MyLookupExpression
extends Expression {
    protected final String myName;
    protected final LookupElement[] myLookupItems;
    private final String myAdvertisementText;
    private volatile LookupFocusDegree myLookupFocusDegree = LookupFocusDegree.FOCUSED;

    public MyLookupExpression(String name, @Nullable LinkedHashSet<String> names2, @Nullable PsiNamedElement elementToRename, @Nullable PsiElement nameSuggestionContext, boolean shouldSelectAll, String advertisement) {
        this.myName = name;
        this.myAdvertisementText = advertisement;
        this.myLookupItems = MyLookupExpression.initLookupItems(names2, elementToRename, nameSuggestionContext, shouldSelectAll);
    }

    private static LookupElement[] initLookupItems(@Nullable LinkedHashSet<String> names2, @Nullable PsiNamedElement elementToRename, @Nullable PsiElement nameSuggestionContext, final boolean shouldSelectAll) {
        if (names2 == null) {
            if (elementToRename == null) {
                return LookupElement.EMPTY_ARRAY;
            }
            names2 = new LinkedHashSet();
            NameSuggestionProvider.suggestNames(elementToRename, nameSuggestionContext, names2);
        }
        LookupElement[] lookupElements = new LookupElement[names2.size()];
        Iterator iterator2 = names2.iterator();
        for (int i = 0; i < lookupElements.length; ++i) {
            final String suggestion = (String)iterator2.next();
            lookupElements[i] = LookupElementBuilder.create(suggestion).withInsertHandler(new InsertHandler<LookupElement>(){

                @Override
                public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                    TextRange range2;
                    if (context == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (item == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (shouldSelectAll) {
                        return;
                    }
                    Editor topLevelEditor = InjectedLanguageUtil.getTopLevelEditor(context.getEditor());
                    TemplateState templateState = TemplateManagerImpl.getTemplateState(topLevelEditor);
                    if (templateState != null && (range2 = templateState.getCurrentVariableRange()) != null) {
                        topLevelEditor.getDocument().replaceString(range2.getStartOffset(), range2.getEndOffset(), suggestion);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "item";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/refactoring/rename/inplace/MyLookupExpression$1";
                    objectArray[2] = "handleInsert";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        return lookupElements;
    }

    @Override
    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        return this.myLookupItems;
    }

    @Override
    public Result calculateQuickResult(ExpressionContext context) {
        return this.calculateResult(context);
    }

    @Override
    public Result calculateResult(ExpressionContext context) {
        TextResult insertedValue;
        TemplateState templateState = TemplateManagerImpl.getTemplateState(context.getEditor());
        TextResult textResult = insertedValue = templateState != null ? templateState.getVariableValue("PrimaryVariable") : null;
        if (insertedValue != null && !insertedValue.getText().isEmpty()) {
            return insertedValue;
        }
        return new TextResult(this.myName);
    }

    @Override
    public boolean requiresCommittedPSI() {
        return false;
    }

    @Override
    public String getAdvertisingText() {
        return this.myAdvertisementText;
    }

    @Override
    @NotNull
    public LookupFocusDegree getLookupFocusDegree() {
        LookupFocusDegree lookupFocusDegree = this.myLookupFocusDegree;
        if (lookupFocusDegree == null) {
            MyLookupExpression.$$$reportNull$$$0(0);
        }
        return lookupFocusDegree;
    }

    public void setLookupFocusDegree(@NotNull LookupFocusDegree lookupFocusDegree) {
        if (lookupFocusDegree == null) {
            MyLookupExpression.$$$reportNull$$$0(1);
        }
        this.myLookupFocusDegree = lookupFocusDegree;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/inplace/MyLookupExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupFocusDegree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupFocusDegree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/inplace/MyLookupExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setLookupFocusDegree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

