/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.EditorTextField;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;

public class CodeFragmentTableCellEditorBase
extends AbstractCellEditor
implements TableCellEditor {
    private Document myDocument;
    protected PsiCodeFragment myCodeFragment;
    private final Project myProject;
    private final FileType myFileType;
    protected EditorTextField myEditorTextField;
    private final List<DocumentListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public CodeFragmentTableCellEditorBase(Project project2, FileType fileType) {
        this.myProject = project2;
        this.myFileType = fileType;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
        this.myCodeFragment = (PsiCodeFragment)value2;
        this.myDocument = PsiDocumentManager.getInstance(this.myProject).getDocument(this.myCodeFragment);
        this.myEditorTextField = this.createEditorField(this.myDocument);
        if (this.myEditorTextField != null) {
            for (DocumentListener listener2 : this.myListeners) {
                this.myEditorTextField.addDocumentListener(listener2);
            }
            this.myEditorTextField.setDocument(this.myDocument);
            this.myEditorTextField.setBorder(new LineBorder(table.getSelectionBackground()));
        }
        return this.myEditorTextField;
    }

    protected EditorTextField createEditorField(Document document) {
        EditorTextField field = new EditorTextField(document, this.myProject, this.myFileType){

            @Override
            protected boolean shouldHaveBorder() {
                return false;
            }
        };
        field.setBorder(new EmptyBorder(1, 1, 1, 1));
        return field;
    }

    @Override
    public PsiCodeFragment getCellEditorValue() {
        return this.myCodeFragment;
    }

    @Override
    public boolean stopCellEditing() {
        super.stopCellEditing();
        PsiDocumentManager.getInstance(this.myProject).commitDocument(this.myDocument);
        return true;
    }

    public void addDocumentListener(DocumentListener listener2) {
        this.myListeners.add(listener2);
    }

    public void clearListeners() {
        this.myListeners.clear();
    }
}

