/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ReadWriteAccessUsageInfo2UsageAdapter;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConflictsDialog
extends DialogWrapper {
    private static final int SHOW_CONFLICTS_EXIT_CODE = 4;
    private static final int MAX_CONFLICTS_SHOWN = 20;
    @NonNls
    private static final String EXPAND_LINK = "expand";
    protected final String[] myConflictDescriptions;
    protected MultiMap<PsiElement, String> myElementConflictDescription;
    private final Project myProject;
    private Runnable myDoRefactoringRunnable;
    private final boolean myCanShowConflictsInView;
    private String myCommandName;

    public ConflictsDialog(@NotNull Project project2, @NotNull MultiMap<PsiElement, String> conflictDescriptions) {
        if (project2 == null) {
            ConflictsDialog.$$$reportNull$$$0(0);
        }
        if (conflictDescriptions == null) {
            ConflictsDialog.$$$reportNull$$$0(1);
        }
        this(project2, conflictDescriptions, null, true, true);
    }

    public ConflictsDialog(@NotNull Project project2, @NotNull MultiMap<PsiElement, String> conflictDescriptions, @Nullable Runnable doRefactoringRunnable) {
        if (project2 == null) {
            ConflictsDialog.$$$reportNull$$$0(2);
        }
        if (conflictDescriptions == null) {
            ConflictsDialog.$$$reportNull$$$0(3);
        }
        this(project2, conflictDescriptions, doRefactoringRunnable, true, true);
    }

    public ConflictsDialog(@NotNull Project project2, @NotNull MultiMap<PsiElement, String> conflictDescriptions, @Nullable Runnable doRefactoringRunnable, boolean alwaysShowOkButton, boolean canShowConflictsInView) {
        if (project2 == null) {
            ConflictsDialog.$$$reportNull$$$0(4);
        }
        if (conflictDescriptions == null) {
            ConflictsDialog.$$$reportNull$$$0(5);
        }
        super(project2, true);
        this.myProject = project2;
        this.myDoRefactoringRunnable = doRefactoringRunnable;
        this.myCanShowConflictsInView = canShowConflictsInView;
        LinkedHashSet<String> conflicts = new LinkedHashSet<String>(conflictDescriptions.values());
        this.myConflictDescriptions = ArrayUtilRt.toStringArray(conflicts);
        this.myElementConflictDescription = conflictDescriptions;
        this.setTitle(RefactoringBundle.message("problems.detected.title"));
        this.setOKButtonText(RefactoringBundle.message("continue.button"));
        this.setOKActionEnabled(alwaysShowOkButton || this.getDoRefactoringRunnable(null) != null);
        this.init();
    }

    @Deprecated
    public ConflictsDialog(Project project2, String ... conflictDescriptions) {
        super(project2, true);
        this.myProject = project2;
        this.myConflictDescriptions = conflictDescriptions;
        this.myCanShowConflictsInView = true;
        this.setTitle(RefactoringBundle.message("problems.detected.title"));
        this.setOKButtonText(RefactoringBundle.message("continue.button"));
        this.init();
    }

    @Override
    protected Action @NotNull [] createActions() {
        boolean showUsagesButton;
        Action okAction = this.getOKAction();
        boolean bl = showUsagesButton = this.myElementConflictDescription != null && this.myCanShowConflictsInView;
        if (showUsagesButton || !okAction.isEnabled()) {
            okAction.putValue("DefaultAction", null);
        }
        if (!showUsagesButton) {
            Action[] actionArray = new Action[]{okAction, new CancelAction()};
            if (actionArray == null) {
                ConflictsDialog.$$$reportNull$$$0(6);
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{okAction, new MyShowConflictsInUsageViewAction(), new CancelAction()};
        if (actionArray == null) {
            ConflictsDialog.$$$reportNull$$$0(7);
        }
        return actionArray;
    }

    public boolean isShowConflicts() {
        return this.getExitCode() == 4;
    }

    @Override
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout(0, 2));
        panel2.add((Component)new JLabel(RefactoringBundle.message("the.following.problems.were.found")), "North");
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < Math.min(this.myConflictDescriptions.length, 20); ++i) {
            buf.append(this.myConflictDescriptions[i]).append("<br><br>");
        }
        if (this.myConflictDescriptions.length > 20) {
            buf.append("<a href='expand'>Show more...</a>");
        }
        JEditorPane messagePane = new JEditorPane();
        messagePane.setEditorKit(UIUtil.getHTMLEditorKit());
        messagePane.setText(buf.toString());
        messagePane.setEditable(false);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(messagePane, 22, 30);
        scrollPane.setPreferredSize(JBUI.size(500, 400));
        messagePane.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && EXPAND_LINK.equals(e.getDescription())) {
                messagePane.setText(StringUtil.join(this.myConflictDescriptions, "<br><br>"));
            }
        });
        panel2.add((Component)scrollPane, "Center");
        if (this.getOKAction().isEnabled()) {
            panel2.add((Component)new JLabel(RefactoringBundle.message("do.you.wish.to.ignore.them.and.continue")), "South");
        }
        return panel2;
    }

    public void setCommandName(String commandName) {
        this.myCommandName = commandName;
    }

    protected Runnable getDoRefactoringRunnable(@Nullable UsageView usageView) {
        return this.myDoRefactoringRunnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictDescriptions";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/ui/ConflictsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/ui/ConflictsDialog";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyShowConflictsInUsageViewAction
    extends AbstractAction {
        MyShowConflictsInUsageViewAction() {
            super(RefactoringBundle.message("action.show.conflicts.in.view.text"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UsageViewPresentation presentation = new UsageViewPresentation();
            String codeUsagesString = RefactoringBundle.message("conflicts.tab.name");
            presentation.setCodeUsagesString(codeUsagesString);
            presentation.setTabName(codeUsagesString);
            presentation.setTabText(codeUsagesString);
            presentation.setShowCancelButton(true);
            ArrayList<Usage> usages = new ArrayList<Usage>(ConflictsDialog.this.myElementConflictDescription.values().size());
            for (PsiElement element2 : ConflictsDialog.this.myElementConflictDescription.keySet()) {
                if (element2 == null) {
                    usages.add(new DescriptionOnlyUsage());
                    continue;
                }
                boolean isRead = false;
                boolean isWrite = false;
                ReadWriteAccessDetector detector = ReadWriteAccessDetector.findDetector(element2);
                if (detector != null) {
                    ReadWriteAccessDetector.Access access = detector.getExpressionAccess(element2);
                    isRead = access != ReadWriteAccessDetector.Access.Write;
                    isWrite = access != ReadWriteAccessDetector.Access.Read;
                }
                for (String conflictDescription : ConflictsDialog.this.myElementConflictDescription.get(element2)) {
                    final UsagePresentation usagePresentation = new DescriptionOnlyUsage(conflictDescription).getPresentation();
                    UsageInfo2UsageAdapter usage = isRead || isWrite ? new ReadWriteAccessUsageInfo2UsageAdapter(new UsageInfo(element2), isRead, isWrite){

                        @Override
                        @NotNull
                        public UsagePresentation getPresentation() {
                            UsagePresentation usagePresentation2 = usagePresentation;
                            if (usagePresentation2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return usagePresentation2;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/ConflictsDialog$MyShowConflictsInUsageViewAction$1", "getPresentation"));
                        }
                    } : new UsageInfo2UsageAdapter(new UsageInfo(element2)){

                        @Override
                        @NotNull
                        public UsagePresentation getPresentation() {
                            UsagePresentation usagePresentation2 = usagePresentation;
                            if (usagePresentation2 == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            return usagePresentation2;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/ConflictsDialog$MyShowConflictsInUsageViewAction$2", "getPresentation"));
                        }
                    };
                    usages.add(usage);
                }
            }
            UsageView usageView = UsageViewManager.getInstance(ConflictsDialog.this.myProject).showUsages(UsageTarget.EMPTY_ARRAY, usages.toArray(Usage.EMPTY_ARRAY), presentation);
            Runnable doRefactoringRunnable = ConflictsDialog.this.getDoRefactoringRunnable(usageView);
            if (doRefactoringRunnable != null) {
                usageView.addPerformOperationAction(doRefactoringRunnable, ConflictsDialog.this.myCommandName != null ? ConflictsDialog.this.myCommandName : RefactoringBundle.message("retry.command"), "Unable to perform refactoring. There were changes in code after the usages have been found.", RefactoringBundle.message("usageView.doAction"));
            }
            ConflictsDialog.this.close(4);
        }

        private class DescriptionOnlyUsage
        implements Usage {
            private final String myConflictDescription;

            DescriptionOnlyUsage(String conflictDescription) {
                if (conflictDescription == null) {
                    DescriptionOnlyUsage.$$$reportNull$$$0(0);
                }
                this.myConflictDescription = StringUtil.unescapeXmlEntities(conflictDescription).replaceAll("<code>", "").replaceAll("</code>", "").replaceAll("<b>", "").replaceAll("</b>", "");
            }

            DescriptionOnlyUsage() {
                this.myConflictDescription = Pattern.compile("<[^<>]*>").matcher(StringUtil.join(new LinkedHashSet<String>(ConflictsDialog.this.myElementConflictDescription.get(null)), "\n")).replaceAll("");
            }

            @Override
            @NotNull
            public UsagePresentation getPresentation() {
                return new UsagePresentation(){

                    @Override
                    public TextChunk @NotNull [] getText() {
                        TextChunk[] textChunkArray = new TextChunk[]{new TextChunk(SimpleTextAttributes.REGULAR_ATTRIBUTES.toTextAttributes(), DescriptionOnlyUsage.this.myConflictDescription)};
                        if (textChunkArray == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return textChunkArray;
                    }

                    @Override
                    @Nullable
                    public Icon getIcon() {
                        return null;
                    }

                    @Override
                    public String getTooltipText() {
                        return DescriptionOnlyUsage.this.myConflictDescription;
                    }

                    @Override
                    @NotNull
                    public String getPlainText() {
                        String string = DescriptionOnlyUsage.this.myConflictDescription;
                        if (string == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/intellij/refactoring/ui/ConflictsDialog$MyShowConflictsInUsageViewAction$DescriptionOnlyUsage$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getText";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getPlainText";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                };
            }

            @Override
            public boolean canNavigateToSource() {
                return false;
            }

            @Override
            public boolean canNavigate() {
                return false;
            }

            @Override
            public void navigate(boolean requestFocus) {
            }

            @Override
            public FileEditorLocation getLocation() {
                return null;
            }

            @Override
            public boolean isReadOnly() {
                return false;
            }

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public void selectInEditor() {
            }

            @Override
            public void highlightInEditor() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictDescription", "com/intellij/refactoring/ui/ConflictsDialog$MyShowConflictsInUsageViewAction$DescriptionOnlyUsage", "<init>"));
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            super(RefactoringBundle.message("cancel.button"));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConflictsDialog.this.doCancelAction();
        }
    }
}

