/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import org.jetbrains.annotations.Nullable;

public class MoveRenameUsageInfo
extends UsageInfo {
    private static final Logger LOG = Logger.getInstance(MoveRenameUsageInfo.class);
    private SmartPsiElementPointer myReferencedElementPointer = null;
    private PsiElement myReferencedElement;
    private PsiReference myReference;
    private RangeMarker myReferenceRangeMarker = null;

    public MoveRenameUsageInfo(PsiReference reference2, PsiElement referencedElement) {
        this(reference2.getElement(), reference2, referencedElement);
    }

    public MoveRenameUsageInfo(PsiElement element2, PsiReference reference2, PsiElement referencedElement) {
        super(element2);
        this.init(element2, reference2, referencedElement);
    }

    public MoveRenameUsageInfo(PsiElement element2, PsiReference reference2, int startOffset, int endOffset, PsiElement referencedElement, boolean nonCodeUsage) {
        super(element2, startOffset, endOffset, nonCodeUsage);
        this.init(element2, reference2, referencedElement);
    }

    private void init(PsiElement element2, PsiReference reference2, PsiElement referencedElement) {
        TextRange textRange;
        Project project2 = element2.getProject();
        this.myReferencedElement = referencedElement;
        if (referencedElement != null) {
            this.myReferencedElementPointer = SmartPointerManager.getInstance(project2).createSmartPsiElementPointer(referencedElement);
        }
        if (reference2 == null) {
            reference2 = element2.getReference();
        }
        PsiFile containingFile = element2.getContainingFile();
        if (reference2 == null && (textRange = element2.getTextRange()) != null) {
            reference2 = containingFile.findReferenceAt(textRange.getStartOffset());
        }
        this.myReference = reference2;
        if (reference2 != null) {
            Document document = PsiDocumentManager.getInstance(project2).getDocument(containingFile);
            if (document != null) {
                TextRange rangeInElement;
                int elementStart = reference2.getElement().getTextRange().getStartOffset();
                LOG.assertTrue(elementStart + (rangeInElement = reference2.getRangeInElement()).getEndOffset() <= document.getTextLength(), reference2);
                this.myReferenceRangeMarker = document.createRangeMarker(elementStart + rangeInElement.getStartOffset(), elementStart + rangeInElement.getEndOffset());
            }
            this.myDynamicUsage = reference2.resolve() == null;
        }
    }

    @Nullable
    public PsiElement getUpToDateReferencedElement() {
        return this.myReferencedElementPointer == null ? null : (PsiElement)this.myReferencedElementPointer.getElement();
    }

    @Nullable
    public PsiElement getReferencedElement() {
        return this.myReferencedElement;
    }

    @Override
    @Nullable
    public PsiReference getReference() {
        PsiElement element2;
        if (this.myReference != null && (element2 = this.myReference.getElement()) != null && element2.isValid()) {
            if (this.myReferenceRangeMarker == null) {
                return this.myReference;
            }
            PsiReference reference2 = this.checkReferenceRange(element2, start2 -> this.myReference);
            if (reference2 != null) {
                return reference2;
            }
        }
        if (this.myReferenceRangeMarker == null) {
            return null;
        }
        element2 = this.getElement();
        if (element2 == null || !element2.isValid()) {
            return null;
        }
        return this.checkReferenceRange(element2, start2 -> element2.findReferenceAt((int)start2));
    }

    @Nullable
    private PsiReference checkReferenceRange(PsiElement element2, Function<? super Integer, ? extends PsiReference> fn) {
        int start2 = this.myReferenceRangeMarker.getStartOffset() - element2.getTextRange().getStartOffset();
        int end = this.myReferenceRangeMarker.getEndOffset() - element2.getTextRange().getStartOffset();
        PsiReference reference2 = fn.fun((Integer)start2);
        if (reference2 == null) {
            return null;
        }
        TextRange rangeInElement = reference2.getRangeInElement();
        if (rangeInElement.getStartOffset() != start2 || rangeInElement.getEndOffset() != end) {
            return null;
        }
        return reference2;
    }
}

