/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.RemoteCredentialsHandler;
import com.intellij.remote.ext.UnknownCredentialsHolder;
import com.intellij.remote.ext.UnknownTypeRemoteCredentialHandler;
import org.jetbrains.annotations.Nls;

public abstract class CredentialsType<T> {
    public static final ExtensionPointName<CredentialsType<?>> EP_NAME = ExtensionPointName.create("com.intellij.remote.credentialsType");
    public static final Key<UnknownCredentialsHolder> UNKNOWN_CREDENTIALS = Key.create("UNKNOWN_CREDENTIALS");
    public static final CredentialsType<UnknownCredentialsHolder> UNKNOWN = new CredentialsType<UnknownCredentialsHolder>("Unknown", ""){

        @Override
        public Key<UnknownCredentialsHolder> getCredentialsKey() {
            return UNKNOWN_CREDENTIALS;
        }

        @Override
        public RemoteCredentialsHandler getHandler(UnknownCredentialsHolder credentials) {
            return new UnknownTypeRemoteCredentialHandler(credentials);
        }

        @Override
        public UnknownCredentialsHolder createCredentials() {
            return new UnknownCredentialsHolder();
        }
    };
    private final String myName;
    private final String myPrefix;

    protected CredentialsType(@Nls(capitalization=Nls.Capitalization.Title) String name, String prefix) {
        this.myName = name;
        this.myPrefix = prefix;
    }

    public String getName() {
        return this.myName;
    }

    public T getCredentials(UserDataHolderBase dataHolder) {
        return dataHolder.getUserData(this.getCredentialsKey());
    }

    public void putCredentials(UserDataHolderBase dataHolder, T credentials) {
        dataHolder.putUserData(this.getCredentialsKey(), credentials);
    }

    public abstract Key<T> getCredentialsKey();

    public abstract RemoteCredentialsHandler getHandler(T var1);

    public boolean hasPrefix(String path2) {
        return path2.startsWith(this.myPrefix);
    }

    public abstract T createCredentials();

    public int getWeight() {
        return Integer.MAX_VALUE;
    }

    public void saveCredentials(RemoteSdkAdditionalData data2, CredentialsCase ... cases2) {
        for (CredentialsCase credentialsCase : cases2) {
            if (credentialsCase.getType() != this) continue;
            T credentials = this.createCredentials();
            credentialsCase.process(credentials);
            data2.setCredentials(this.getCredentialsKey(), credentials);
        }
    }
}

