/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class WebDeploymentCredentialsHolder {
    private static final String SFTP_DEPLOYMENT_PREFIX = "sftp://";
    public static final String WEB_SERVER_CREDENTIALS_ID = "WEB_SERVER_CREDENTIALS_ID";
    public static final String WEB_SERVER_CONFIG_ID = "WEB_SERVER_CONFIG_ID";
    public static final String WEB_SERVER_CONFIG_NAME = "WEB_SERVER_CONFIG_NAME";
    @NotNull
    private String myCredentialsId;
    @NotNull
    private String myWebServerConfigId;
    private String myWebServerConfigName;

    public WebDeploymentCredentialsHolder() {
        this.myCredentialsId = "";
        this.myWebServerConfigId = "";
    }

    public WebDeploymentCredentialsHolder(@NotNull String webServerConfigId, String name, @NotNull RemoteCredentials remoteCredentials) {
        if (webServerConfigId == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(0);
        }
        if (remoteCredentials == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(1);
        }
        this.myCredentialsId = "";
        this.myWebServerConfigId = "";
        this.myWebServerConfigId = webServerConfigId;
        this.myWebServerConfigName = name;
        this.myCredentialsId = WebDeploymentCredentialsHolder.constructSftpCredentialsFullPath(remoteCredentials);
    }

    @NotNull
    public String getCredentialsId() {
        String string = this.myCredentialsId;
        if (string == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getWebServerConfigId() {
        String string = this.myWebServerConfigId;
        if (string == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setWebServerConfigId(@NotNull String webServerConfigId) {
        if (webServerConfigId == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(4);
        }
        this.myWebServerConfigId = webServerConfigId;
    }

    public String getWebServerConfigName() {
        return this.myWebServerConfigName;
    }

    public void setWebServerConfigName(@NotNull String name) {
        if (name == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(5);
        }
        this.myWebServerConfigName = name;
    }

    public void load(Element element2) {
        this.setWebServerConfigId(StringUtil.notNullize(element2.getAttributeValue(WEB_SERVER_CONFIG_ID)));
        this.setWebServerConfigName(StringUtil.notNullize(element2.getAttributeValue(WEB_SERVER_CONFIG_NAME)));
        this.myCredentialsId = StringUtil.notNullize(element2.getAttributeValue(WEB_SERVER_CREDENTIALS_ID));
        if (StringUtil.isEmpty(this.myCredentialsId)) {
            RemoteCredentialsHolder credentials = new RemoteCredentialsHolder();
            credentials.load(element2);
            this.myCredentialsId = WebDeploymentCredentialsHolder.constructSftpCredentialsFullPath(credentials);
        }
    }

    public void save(Element element2) {
        element2.setAttribute(WEB_SERVER_CONFIG_ID, this.getWebServerConfigId());
        element2.setAttribute(WEB_SERVER_CONFIG_NAME, this.getWebServerConfigName());
        element2.setAttribute(WEB_SERVER_CREDENTIALS_ID, StringUtil.notNullize(this.getCredentialsId()));
    }

    @NotNull
    public WebDeploymentCredentialsHolder copyFrom(@NotNull WebDeploymentCredentialsHolder holder) {
        if (holder == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(6);
        }
        this.setWebServerConfigId(holder.getWebServerConfigId());
        this.setWebServerConfigName(holder.getWebServerConfigName());
        this.myCredentialsId = holder.getCredentialsId();
        WebDeploymentCredentialsHolder webDeploymentCredentialsHolder = this;
        if (webDeploymentCredentialsHolder == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(7);
        }
        return webDeploymentCredentialsHolder;
    }

    @NotNull
    private static String constructSftpCredentialsFullPath(@NotNull RemoteCredentials cred) {
        if (cred == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(8);
        }
        String string = SFTP_DEPLOYMENT_PREFIX + cred.getUserName() + "@" + cred.getHost() + ":" + cred.getLiteralPort();
        if (string == null) {
            WebDeploymentCredentialsHolder.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebDeploymentCredentialsHolder holder = (WebDeploymentCredentialsHolder)o;
        return this.myWebServerConfigId.equals(holder.myWebServerConfigId);
    }

    public int hashCode() {
        return this.myWebServerConfigId.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webServerConfigId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteCredentials";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/WebDeploymentCredentialsHolder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cred";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/WebDeploymentCredentialsHolder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentialsId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebServerConfigId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFrom";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "constructSftpCredentialsFullPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setWebServerConfigId";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setWebServerConfigName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "constructSftpCredentialsFullPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

