/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.impl;

import com.intellij.remoteServer.agent.RemoteAgentProxyFactory;
import com.intellij.remoteServer.agent.impl.CallerClassLoaderProvider;
import com.intellij.remoteServer.agent.impl.util.UrlCollector;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.List;

public abstract class RemoteAgentProxyFactoryBase
implements RemoteAgentProxyFactory {
    private final CallerClassLoaderProvider myCallerClassLoaderProvider;

    public RemoteAgentProxyFactoryBase(CallerClassLoaderProvider callerClassLoaderProvider) {
        this.myCallerClassLoaderProvider = callerClassLoaderProvider;
    }

    @Override
    public <T> T createProxy(List<File> libraries, Class<T> agentInterface, String agentClassName) throws Exception {
        ClassLoader callerClassLoader = this.myCallerClassLoaderProvider.getCallerClassLoader(agentInterface);
        ClassLoader agentClassLoader = this.createAgentClassLoader(libraries);
        Object agentImpl = agentClassLoader.loadClass(agentClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return agentInterface.cast(Proxy.newProxyInstance(agentInterface.getClassLoader(), new Class[]{agentInterface}, this.createInvocationHandler(agentImpl, agentClassLoader, callerClassLoader)));
    }

    protected ClassLoader createAgentClassLoader(List<File> libraries) throws Exception {
        return this.createAgentClassLoader(new UrlCollector().collect(libraries));
    }

    protected abstract ClassLoader createAgentClassLoader(URL[] var1) throws Exception;

    protected abstract InvocationHandler createInvocationHandler(Object var1, ClassLoader var2, ClassLoader var3);
}

