/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.impl.configuration.RemoteServerImpl;
import com.intellij.remoteServer.impl.configuration.RemoteServerState;
import com.intellij.remoteServer.impl.configuration.RemoteServersManagerState;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="RemoteServers", storages={@Storage(value="remote-servers.xml")})
public class RemoteServersManagerImpl
extends RemoteServersManager
implements PersistentStateComponent<RemoteServersManagerState> {
    public static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTERS = new SkipDefaultValuesSerializationFilters();
    private final List<RemoteServer<?>> myServers = new ArrayList();
    private final List<RemoteServerState> myUnknownServers = new ArrayList<RemoteServerState>();
    private final MessageBus myMessageBus;

    public RemoteServersManagerImpl(MessageBus messageBus) {
        this.myMessageBus = messageBus;
    }

    @Override
    public List<RemoteServer<?>> getServers() {
        return Collections.unmodifiableList(this.myServers);
    }

    @Override
    public <C extends ServerConfiguration> List<RemoteServer<C>> getServers(@NotNull ServerType<C> type) {
        if (type == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(0);
        }
        ArrayList<RemoteServer<C>> servers = new ArrayList<RemoteServer<C>>();
        for (RemoteServer<?> server : this.myServers) {
            if (!server.getType().equals(type)) continue;
            servers.add(server);
        }
        return servers;
    }

    @Override
    @Nullable
    public <C extends ServerConfiguration> RemoteServer<C> findByName(@NotNull String name, @NotNull ServerType<C> type) {
        if (name == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(1);
        }
        if (type == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(2);
        }
        for (RemoteServer<?> server : this.myServers) {
            if (!server.getType().equals(type) || !server.getName().equals(name)) continue;
            return server;
        }
        return null;
    }

    @Override
    @NotNull
    public <C extends ServerConfiguration> RemoteServer<C> createServer(@NotNull ServerType<C> type, @NotNull String name) {
        if (type == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(3);
        }
        if (name == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(4);
        }
        return new RemoteServerImpl<C>(name, type, type.createDefaultConfiguration());
    }

    @Override
    @NotNull
    public <C extends ServerConfiguration> RemoteServer<C> createServer(@NotNull ServerType<C> type) {
        if (type == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(5);
        }
        String name = UniqueNameGenerator.generateUniqueName(type.getPresentableName(), s -> this.getServers(type).stream().map(RemoteServer::getName).noneMatch(s::equals));
        RemoteServer<C> remoteServer = this.createServer(type, name);
        if (remoteServer == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(6);
        }
        return remoteServer;
    }

    @Override
    public void addServer(RemoteServer<?> server) {
        this.myServers.add(server);
        this.myMessageBus.syncPublisher(RemoteServerListener.TOPIC).serverAdded(server);
    }

    @Override
    public void removeServer(RemoteServer<?> server) {
        this.myServers.remove(server);
        this.myMessageBus.syncPublisher(RemoteServerListener.TOPIC).serverRemoved(server);
    }

    @Override
    @Nullable
    public RemoteServersManagerState getState() {
        RemoteServersManagerState state = new RemoteServersManagerState();
        for (RemoteServer<?> server : this.myServers) {
            RemoteServerState serverState = new RemoteServerState();
            serverState.myName = server.getName();
            serverState.myTypeId = server.getType().getId();
            serverState.myConfiguration = XmlSerializer.serialize(((ServerConfiguration)server.getConfiguration()).getSerializer().getState(), SERIALIZATION_FILTERS);
            state.myServers.add(serverState);
        }
        state.myServers.addAll(this.myUnknownServers);
        return state;
    }

    @Override
    public void loadState(@NotNull RemoteServersManagerState state) {
        if (state == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(7);
        }
        this.myUnknownServers.clear();
        this.myServers.clear();
        LinkedList<CloudConfigurationBase> needsMigration = new LinkedList<CloudConfigurationBase>();
        for (RemoteServerState server : state.myServers) {
            ServerType<?> type = RemoteServersManagerImpl.findServerType(server.myTypeId);
            if (type == null) {
                this.myUnknownServers.add(server);
                continue;
            }
            RemoteServerImpl<?> nextServer = RemoteServersManagerImpl.createConfiguration(type, server);
            this.myServers.add(nextServer);
            Object nextConfig = nextServer.getConfiguration();
            if (!(nextConfig instanceof CloudConfigurationBase) || !((CloudConfigurationBase)nextConfig).shouldMigrateToPasswordSafe()) continue;
            needsMigration.add((CloudConfigurationBase)nextConfig);
        }
        if (!needsMigration.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                for (CloudConfigurationBase nextConfig : needsMigration) {
                    nextConfig.migrateToPasswordSafe();
                }
            });
        }
    }

    @NotNull
    private static <C extends ServerConfiguration> RemoteServerImpl<C> createConfiguration(ServerType<C> type, RemoteServerState server) {
        C configuration = type.createDefaultConfiguration();
        PersistentStateComponent<?> serializer = ((ServerConfiguration)configuration).getSerializer();
        ComponentSerializationUtil.loadComponentState(serializer, server.myConfiguration);
        return new RemoteServerImpl<C>(server.myName, type, configuration);
    }

    @Nullable
    private static ServerType<?> findServerType(@NotNull String typeId) {
        if (typeId == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(8);
        }
        for (ServerType serverType : ServerType.EP_NAME.getExtensions()) {
            if (!serverType.getId().equals(typeId)) continue;
            return serverType;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/RemoteServersManagerImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/RemoteServersManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getServers";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createServer";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findServerType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

