/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.log;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerImpl;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ConsoleTerminalHandlerImpl
extends TerminalHandlerBase {
    private static final Logger LOG = Logger.getInstance(ConsoleTerminalHandlerImpl.class);
    private final LoggingHandlerImpl myLoggingHandler;

    public ConsoleTerminalHandlerImpl(String presentableName, Project project2, InputStream terminalOutput, final OutputStream terminalInput) {
        super(presentableName);
        this.myLoggingHandler = new LoggingHandlerImpl(presentableName, project2);
        this.myLoggingHandler.attachToProcess(new ProcessHandler(){

            @Override
            protected void destroyProcessImpl() {
            }

            @Override
            protected void detachProcessImpl() {
            }

            @Override
            public boolean detachIsDefault() {
                return false;
            }

            @Override
            @Nullable
            public OutputStream getProcessInput() {
                return terminalInput;
            }
        });
        Disposer.register(this, this.myLoggingHandler);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try (BufferedReader outputReader = new BufferedReader(new InputStreamReader(terminalOutput, StandardCharsets.UTF_8));){
                while (!this.isClosed()) {
                    String line = outputReader.readLine();
                    if (line == null) {
                        break;
                    }
                    this.myLoggingHandler.print(line + "\n");
                }
            }
            catch (IOException e) {
                LOG.debug(e);
            }
        });
    }

    @Override
    public JComponent getComponent() {
        return this.myLoggingHandler.getComponent();
    }
}

