/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.impl.runtime.log.DeploymentLogManagerImpl;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersServiceViewContributor;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DefaultRemoteServersServiceViewContributor
extends RemoteServersServiceViewContributor {
    private static final ServiceViewDescriptor CONTRIBUTOR_DESCRIPTOR = new SimpleServiceViewDescriptor("Clouds", AllIcons.General.Balloon){

        @Override
        public ActionGroup getToolbarActions() {
            return RemoteServersServiceViewContributor.getToolbarActions(RemoteServersServiceViewContributor.ActionGroups.SHARED_ACTION_GROUPS);
        }

        @Override
        public ActionGroup getPopupActions() {
            return RemoteServersServiceViewContributor.getPopupActions(RemoteServersServiceViewContributor.ActionGroups.SHARED_ACTION_GROUPS);
        }
    };

    @Override
    @NotNull
    public ServiceViewDescriptor getViewDescriptor(@NotNull Project project2) {
        if (project2 == null) {
            DefaultRemoteServersServiceViewContributor.$$$reportNull$$$0(0);
        }
        ServiceViewDescriptor serviceViewDescriptor = CONTRIBUTOR_DESCRIPTOR;
        if (serviceViewDescriptor == null) {
            DefaultRemoteServersServiceViewContributor.$$$reportNull$$$0(1);
        }
        return serviceViewDescriptor;
    }

    public boolean accept(@NotNull RemoteServer server) {
        if (server == null) {
            DefaultRemoteServersServiceViewContributor.$$$reportNull$$$0(2);
        }
        return DefaultRemoteServersServiceViewContributor.isDefaultRemoteServer(server);
    }

    public void selectLog(@NotNull AbstractTreeNode deploymentNode, @NotNull String logName) {
        ServersTreeStructure.DeploymentNodeImpl node;
        if (deploymentNode == null) {
            DefaultRemoteServersServiceViewContributor.$$$reportNull$$$0(3);
        }
        if (logName == null) {
            DefaultRemoteServersServiceViewContributor.$$$reportNull$$$0(4);
        }
        if ((node = ObjectUtils.tryCast(deploymentNode, ServersTreeStructure.DeploymentNodeImpl.class)) == null) {
            return;
        }
        ServerConnection<?> connection = node.getConnection();
        if (connection == null) {
            return;
        }
        Project project2 = Objects.requireNonNull(node.getProject());
        DeploymentLogManagerImpl logManager = (DeploymentLogManagerImpl)connection.getLogManager(project2, node.getDeployment());
        if (logManager == null) {
            return;
        }
        for (LoggingHandlerBase loggingComponent : logManager.getAdditionalLoggingHandlers()) {
            if (!logName.equals(loggingComponent.getPresentableName())) continue;
            ServersTreeStructure.DeploymentLogNode logNode = new ServersTreeStructure.DeploymentLogNode(project2, loggingComponent, node);
            ServiceViewManager.getInstance(project2).select(logNode, DefaultRemoteServersServiceViewContributor.class, true, true);
        }
    }

    @Override
    @NotNull
    public RemoteServersServiceViewContributor.ActionGroups getActionGroups() {
        RemoteServersServiceViewContributor.ActionGroups actionGroups = RemoteServersServiceViewContributor.ActionGroups.SHARED_ACTION_GROUPS;
        if (actionGroups == null) {
            DefaultRemoteServersServiceViewContributor.$$$reportNull$$$0(5);
        }
        return actionGroups;
    }

    @Override
    public AbstractTreeNode<?> createDeploymentNode(ServerConnection<?> connection, ServersTreeStructure.RemoteServerNode serverNode, Deployment deployment) {
        return new ServersTreeStructure.DeploymentNodeImpl(serverNode.getProject(), connection, serverNode, deployment, this);
    }

    private static boolean isDefaultRemoteServer(RemoteServer<?> server) {
        String toolWindowId = ((ServerConfiguration)server.getConfiguration()).getCustomToolWindowId();
        if (toolWindowId == null) {
            toolWindowId = server.getType().getCustomToolWindowId();
        }
        return toolWindowId == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/runtime/ui/DefaultRemoteServersServiceViewContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ui/DefaultRemoteServersServiceViewContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getViewDescriptor";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectLog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

