/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class ApplicationActionUtils {
    private ApplicationActionUtils() {
    }

    @Nullable
    public static DeploymentNode getDeploymentTarget(@NotNull AnActionEvent e) {
        if (e == null) {
            ApplicationActionUtils.$$$reportNull$$$0(0);
        }
        return ServiceViewActionUtils.getTarget(e, DeploymentNode.class);
    }

    @Nullable
    public static Deployment getDeployment(@Nullable DeploymentNode node) {
        return node == null ? null : ObjectUtils.tryCast(node.getValue(), Deployment.class);
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T> T getApplicationRuntime(@Nullable DeploymentNode node, @NotNull Class<T> clazz) {
        Deployment deployment;
        if (clazz == null) {
            ApplicationActionUtils.$$$reportNull$$$0(1);
        }
        return (deployment = ApplicationActionUtils.getDeployment(node)) == null ? null : (T)ObjectUtils.tryCast(deployment.getRuntime(), clazz);
    }

    @Nullable
    public static <T> T getApplicationRuntime(@NotNull AnActionEvent e, @NotNull Class<T> clazz) {
        Deployment deployment;
        if (e == null) {
            ApplicationActionUtils.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            ApplicationActionUtils.$$$reportNull$$$0(3);
        }
        return (deployment = ApplicationActionUtils.getDeployment(ApplicationActionUtils.getDeploymentTarget(e))) == null ? null : (T)ObjectUtils.tryCast(deployment.getRuntime(), clazz);
    }

    @NotNull
    public static Runnable createLogSelector(@NotNull Project project2, @NotNull ServersTreeNodeSelector selector, @NotNull DeploymentNode node, @NotNull String logName) {
        if (project2 == null) {
            ApplicationActionUtils.$$$reportNull$$$0(4);
        }
        if (selector == null) {
            ApplicationActionUtils.$$$reportNull$$$0(5);
        }
        if (node == null) {
            ApplicationActionUtils.$$$reportNull$$$0(6);
        }
        if (logName == null) {
            ApplicationActionUtils.$$$reportNull$$$0(7);
        }
        SelectLogRunnable selectLogRunnable = new SelectLogRunnable(project2, selector, node, logName);
        DisposableSelectLogRunnableWrapper wrapper2 = new DisposableSelectLogRunnableWrapper(selectLogRunnable);
        Disposer.register(project2, wrapper2);
        DisposableSelectLogRunnableWrapper disposableSelectLogRunnableWrapper = wrapper2;
        if (disposableSelectLogRunnableWrapper == null) {
            ApplicationActionUtils.$$$reportNull$$$0(8);
        }
        return disposableSelectLogRunnableWrapper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/util/ApplicationActionUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/util/ApplicationActionUtils";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLogSelector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentTarget";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationRuntime";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLogSelector";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SelectLogRunnable
    implements Runnable {
        private final Project myProject;
        private final ServersTreeNodeSelector mySelector;
        private final DeploymentNode myNode;
        private final String myLogName;

        SelectLogRunnable(@NotNull Project project2, @NotNull ServersTreeNodeSelector selector, @NotNull DeploymentNode node, @NotNull String logName) {
            if (project2 == null) {
                SelectLogRunnable.$$$reportNull$$$0(0);
            }
            if (selector == null) {
                SelectLogRunnable.$$$reportNull$$$0(1);
            }
            if (node == null) {
                SelectLogRunnable.$$$reportNull$$$0(2);
            }
            if (logName == null) {
                SelectLogRunnable.$$$reportNull$$$0(3);
            }
            this.myProject = project2;
            this.mySelector = selector;
            this.myNode = node;
            this.myLogName = logName;
        }

        @Override
        public void run() {
            RemoteServer server = (RemoteServer)this.myNode.getServerNode().getValue();
            ServerConnection connection = ServerConnectionManager.getInstance().getConnection(server);
            if (connection == null) {
                return;
            }
            Deployment deployment = this.findDeployment(connection);
            if (deployment == null) {
                return;
            }
            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith(this.myProject)).submit(() -> this.mySelector.select(connection, deployment.getName(), this.myLogName));
        }

        private Deployment findDeployment(ServerConnection<?> connection) {
            DeploymentRuntime applicationRuntime = ApplicationActionUtils.getApplicationRuntime(this.myNode, DeploymentRuntime.class);
            for (Deployment deployment : connection.getDeployments()) {
                if (applicationRuntime != deployment.getRuntime()) continue;
                return deployment;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "logName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/remoteServer/util/ApplicationActionUtils$SelectLogRunnable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DisposableSelectLogRunnableWrapper
    implements Runnable,
    Disposable {
        private volatile Runnable mySelectLogRunnable;

        private DisposableSelectLogRunnableWrapper(Runnable selectLogRunnable) {
            this.mySelectLogRunnable = selectLogRunnable;
        }

        @Override
        public void dispose() {
            this.mySelectLogRunnable = null;
        }

        @Override
        public void run() {
            Runnable selectLogRunnable = this.mySelectLogRunnable;
            if (selectLogRunnable != null) {
                selectLogRunnable.run();
                Disposer.dispose(this);
            }
        }
    }
}

