/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.DynamicBundle;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.configuration.SingleRemoteServerConfigurable;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudRunConfigurationUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudAccountSelectionEditor {
    private static final Map<ServerType<?>, Key<RemoteServer<?>>> ourCloudType2AccountKey = new HashMap();
    private JButton myNewButton;
    private ComboBox myAccountComboBox;
    private JPanel myMainPanel;
    private final List<? extends ServerType<?>> myCloudTypes;
    private Runnable myServerSelectionListener;

    public CloudAccountSelectionEditor(List<? extends ServerType<?>> cloudTypes) {
        this.myCloudTypes = cloudTypes;
        this.$$$setupUI$$$();
        for (ServerType<?> cloudType : cloudTypes) {
            for (RemoteServer<?> account : RemoteServersManager.getInstance().getServers(cloudType)) {
                this.myAccountComboBox.addItem(new AccountItem(account));
            }
        }
        this.myNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudAccountSelectionEditor.this.onNewButton();
            }
        });
        this.myAccountComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CloudAccountSelectionEditor.this.myServerSelectionListener != null) {
                    CloudAccountSelectionEditor.this.myServerSelectionListener.run();
                }
            }
        });
    }

    public void setAccountSelectionListener(Runnable listener2) {
        this.myServerSelectionListener = listener2;
    }

    private void onNewButton() {
        if (this.myCloudTypes.size() == 1) {
            this.createAccount(ContainerUtil.getFirstItem(this.myCloudTypes));
            return;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        for (final ServerType<?> cloudType : this.myCloudTypes) {
            group.add(new AnAction(cloudType.getPresentableName(), cloudType.getPresentableName(), cloudType.getIcon()){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    CloudAccountSelectionEditor.this.createAccount(cloudType);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/remoteServer/util/CloudAccountSelectionEditor$3", "actionPerformed"));
                }
            });
        }
        JBPopupFactory.getInstance().createActionGroupPopup(CloudBundle.message("popup.title.new.account", new Object[0]), group, DataManager.getInstance().getDataContext(this.myMainPanel), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false).showUnderneathOf(this.myNewButton);
    }

    private void createAccount(ServerType<?> cloudType) {
        Ref errorConsumerRef;
        RemoteServer<?> newAccount = RemoteServersManager.getInstance().createServer(cloudType, CloudAccountSelectionEditor.generateServerName(cloudType));
        SingleRemoteServerConfigurable configurable2 = new SingleRemoteServerConfigurable(newAccount, null, true, errorConsumerRef = new Ref()){
            final /* synthetic */ Ref val$errorConsumerRef;
            {
                this.val$errorConsumerRef = ref;
                super(server, treeUpdater, isNew);
            }

            @Override
            protected void setConnectionStatusText(boolean error, String text2) {
                super.setConnectionStatusText(error, error ? "" : text2);
                ((Consumer)this.val$errorConsumerRef.get()).consume(error ? text2 : null);
            }
        };
        if (!new SingleConfigurableEditor(this.myMainPanel, configurable2, ShowSettingsUtilImpl.createDimensionKey(configurable2), false){
            {
                super(x0, x1, x2, x3);
                errorConsumerRef.set(s -> this.setErrorText((String)s, CloudAccountSelectionEditor.this.myMainPanel));
            }
        }.showAndGet()) {
            return;
        }
        newAccount.setName(configurable2.getDisplayName());
        RemoteServersManager.getInstance().addServer(newAccount);
        AccountItem newAccountItem = new AccountItem(newAccount);
        this.myAccountComboBox.addItem(newAccountItem);
        this.myAccountComboBox.setSelectedItem(newAccountItem);
    }

    public JComponent getMainPanel() {
        return this.myMainPanel;
    }

    @Nullable
    public RemoteServer<?> getSelectedAccount() {
        AccountItem selectedItem = (AccountItem)this.myAccountComboBox.getSelectedItem();
        return selectedItem == null ? null : selectedItem.getAccount();
    }

    private static String generateServerName(ServerType<?> cloudType) {
        return UniqueNameGenerator.generateUniqueName(cloudType.getPresentableName(), s -> {
            for (RemoteServer<?> server : RemoteServersManager.getInstance().getServers()) {
                if (!server.getName().equals(s)) continue;
                return false;
            }
            return true;
        });
    }

    public void validate() throws ConfigurationException {
        if (this.getSelectedAccount() == null) {
            throw new ConfigurationException("Account required");
        }
    }

    public void setAccountOnContext(WizardContext context) {
        RemoteServer<?> account = this.getSelectedAccount();
        if (account == null) {
            return;
        }
        context.putUserData(CloudAccountSelectionEditor.getKey(account.getType()), account);
    }

    public static void unsetAccountOnContext(WizardContext context, ServerType<?> cloudType) {
        context.putUserData(CloudAccountSelectionEditor.getKey(cloudType), null);
    }

    private static Key<RemoteServer<?>> getKey(ServerType<?> cloudType) {
        Key<RemoteServer<Object>> result2 = ourCloudType2AccountKey.get(cloudType);
        if (result2 == null) {
            result2 = new Key("cloud-account-" + cloudType.getId());
            ourCloudType2AccountKey.put(cloudType, result2);
        }
        return result2;
    }

    public static void createRunConfiguration(WizardContext context, ServerType<?> cloudType, Module module2, CloudDeploymentNameConfiguration configuration) {
        RemoteServer<?> account = context.getUserData(CloudAccountSelectionEditor.getKey(cloudType));
        if (account == null) {
            return;
        }
        CloudRunConfigurationUtil.createRunConfiguration(account, module2, configuration);
    }

    public void setSelectedAccount(String accountName) {
        for (int i = 0; i < this.myAccountComboBox.getItemCount(); ++i) {
            AccountItem accountItem = (AccountItem)this.myAccountComboBox.getItemAt(i);
            if (!StringUtil.equals(accountName, accountItem.getAccount().getName())) continue;
            this.myAccountComboBox.setSelectedItem(accountItem);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox2;
        JButton jButton;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 5, 6, null, null, null));
        this.myNewButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle("messages/CloudBundle", CloudAccountSelectionEditor.class).getString("button.cloud.new"));
        jPanel.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        this.myAccountComboBox = comboBox2 = new ComboBox();
        jPanel.add(comboBox2, new GridConstraints(0, 0, 1, 1, 0, 1, 2, 0, null, new Dimension(200, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class AccountItem {
        private final RemoteServer<?> myAccount;

        AccountItem(RemoteServer<?> account) {
            this.myAccount = account;
        }

        public RemoteServer<?> getAccount() {
            return this.myAccount;
        }

        public String toString() {
            return this.myAccount.getName();
        }
    }
}

