/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.RemoteServerConfigurable;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public abstract class CloudConfigurableBase<SC extends CloudConfigurationBase>
extends RemoteServerConfigurable {
    private final ServerType<SC> myCloudType;
    protected final SC myConfiguration;

    public CloudConfigurableBase(ServerType<SC> cloudType, SC configuration) {
        this.myCloudType = cloudType;
        this.myConfiguration = configuration;
    }

    protected final ServerType<SC> getCloudType() {
        return this.myCloudType;
    }

    @Override
    @Nullable
    public JComponent createComponent() {
        return this.getMainPanel();
    }

    @Override
    public boolean isModified() {
        return !this.getEmailTextField().getText().equals(((CloudConfigurationBase)this.myConfiguration).getEmail()) || !new String(this.getPasswordField().getPassword()).equals(((CloudConfigurationBase)this.myConfiguration).getPasswordSafe()) || !((CloudConfigurationBase)this.myConfiguration).isPasswordSafe();
    }

    @Override
    public void apply() throws ConfigurationException {
        this.applyCoreTo(this.myConfiguration, false);
    }

    @Override
    public void reset() {
        this.getEmailTextField().setText(((CloudConfigurationBase)this.myConfiguration).getEmail());
        this.getPasswordField().setText(((CloudConfigurationBase)this.myConfiguration).getPasswordSafe());
    }

    protected void applyCoreTo(SC configuration) throws ConfigurationException {
        this.applyCoreTo(configuration, false);
    }

    protected void applyCoreTo(SC configuration, boolean forComparison) throws ConfigurationException {
        String email = this.getEmailTextField().getText();
        if (StringUtil.isEmpty(email)) {
            throw new RuntimeConfigurationError("Email required");
        }
        String password = new String(this.getPasswordField().getPassword());
        if (StringUtil.isEmpty(password)) {
            throw new RuntimeConfigurationError("Password required");
        }
        ((CloudConfigurationBase)configuration).setEmail(email);
        if (forComparison) {
            ((CloudConfigurationBase)configuration).setPassword(password);
        } else {
            ((CloudConfigurationBase)configuration).setPasswordSafe(password);
        }
    }

    protected boolean isCoreConfigEqual(SC configuration1, SC configuration2) {
        return Comparing.equal(((CloudConfigurationBase)configuration1).getEmail(), ((CloudConfigurationBase)configuration2).getEmail()) && Comparing.equal(((CloudConfigurationBase)configuration1).getPasswordSafe(), ((CloudConfigurationBase)configuration2).getPasswordSafe());
    }

    protected abstract JComponent getMainPanel();

    protected abstract JTextField getEmailTextField();

    protected abstract JPasswordField getPasswordField();
}

